/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.xforceplus.phoenix.bill.client.model.BillConfigRequest;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.service.BillConfigService;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.xplatframework.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillConfigServiceImpl
implements BillConfigService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OrdSalesbillDao ordSalesbillDao;

    @Override
    public Response getBillCountByBillType(BillConfigRequest billConfigRequest) {
        try {
            this.logger.debug("billConfigRequest:{}", (Object)billConfigRequest);
            OrdSalesbillExample example = new OrdSalesbillExample();
            OrdSalesbillExample.Criteria purchaserCriteria = example.createCriteria();
            OrdSalesbillExample.Criteria sellerCriteria = example.createCriteria();
            purchaserCriteria.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType());
            purchaserCriteria.andPurchaserGroupIdEqualTo(billConfigRequest.getGroupId());
            purchaserCriteria.andSalesbillTypeEqualTo(billConfigRequest.getSalesBillType());
            purchaserCriteria.andStatusEqualTo(SalesBillStatus.NORMAL.value());
            sellerCriteria.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
            sellerCriteria.andSellerGroupIdEqualTo(billConfigRequest.getGroupId());
            sellerCriteria.andSalesbillTypeEqualTo(billConfigRequest.getSalesBillType());
            sellerCriteria.andStatusEqualTo(SalesBillStatus.NORMAL.value());
            example.getOredCriteria().add(purchaserCriteria);
            example.or(sellerCriteria);
            long count = this.ordSalesbillDao.countByExample(example);
            return Response.from((Integer)Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (Object)count);
        }
        catch (Exception e) {
            this.logger.warn("{}", (Object)e.getMessage());
            return Response.from((Integer)Response.Fail, (String)"\u67e5\u8be2\u5931\u8d25");
        }
    }
}

