/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.model.BillBatchQueryResponse;
import com.xforceplus.phoenix.bill.client.model.BillQueryItemResponse;
import com.xforceplus.phoenix.bill.client.model.BillQueryResponse;
import com.xforceplus.phoenix.bill.client.model.BillSourceRelationship;
import com.xforceplus.phoenix.bill.client.model.BillSourceResponse;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillItem;
import com.xforceplus.phoenix.bill.client.model.InvoiceBillMain;
import com.xforceplus.phoenix.bill.client.model.MsSplitAndMakeOutParams;
import com.xforceplus.phoenix.bill.client.model.MsSplitAndMakeOutRequest;
import com.xforceplus.phoenix.bill.constant.enums.BillItemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillCatalog;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.service.BillInvoiceService;
import com.xforceplus.phoenix.bill.core.vo.BillInvoiceMapKey;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillSourceRelDao;
import com.xforceplus.phoenix.bill.repository.daoext.OrdAutoSalesBillItemBatchDao;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSalesbillExtDao;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSalesbillItemExtDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRelEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRelExample;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillExtExample;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillItemExtBatchNoUpdate;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillItemExtExample;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.seller.invoice.client.model.BillReleaseType;
import com.xforceplus.seller.invoice.client.model.DetailInfo;
import com.xforceplus.seller.invoice.client.model.InvoiceOperation;
import com.xforceplus.seller.invoice.client.model.NoticeBillMsg;
import com.xforceplus.seller.invoice.client.model.NoticeBillReleaseMsg;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.service.BaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Service
public class BillInvoiceServiceImpl
extends BaseService
implements BillInvoiceService {
    private static final int QUERY_MAX_SIZE = 5000;
    private static final int CLEAR_BATCH_NO_CANCEL = 1;
    private static final int CLEAR_BATCH_NO_DELETE = 2;
    private static final int UPDATE_TYPE_ADD = 1;
    private static final int UPDATE_TYPE_SUBTRACT = 2;
    @Autowired
    private OrdSalesbillDao ordSalesbillDao;
    @Autowired
    private OrdSalesbillExtDao ordSalesbillExtDao;
    @Autowired
    private OrdSalesbillItemDao ordSalesbillItemDao;
    @Autowired
    private OrdSalesbillSourceRelDao ordSalesbillSourceRelDao;
    @Autowired
    private OrdSalesbillItemExtDao ordSalesbillItemExtDao;
    @Autowired
    private OrdAutoSalesBillItemBatchDao ordAutoSalesBillItemBatchDao;
    private static final Logger logger = LoggerFactory.getLogger(BillInvoiceServiceImpl.class);

    @Override
    public BillQueryResponse queryBillByIds(List<Long> billIdList) {
        logger.info("\u5355\u636eids:{}", billIdList);
        if (CommonTools.isEmpty(billIdList)) {
            return BillQueryResponse.fail((String)"\u672a\u6307\u5b9a\u5355\u636eid\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
        ordSalesbillExample.createCriteria().andSalesbillIdIn((List)billIdList).andStatusNotIn((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.DELETED.value()}));
        List<OrdSalesbillEntity> mainEntityList = this.ordSalesbillDao.selectByExample(ordSalesbillExample);
        List<InvoiceBillMain> billList = this.generateBillMainList(mainEntityList, 0L);
        BillQueryResponse billQueryResponse = new BillQueryResponse();
        if (billList.size() > 0) {
            billQueryResponse.setResult(billList);
            billQueryResponse.setCode(Response.OK);
            billQueryResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        } else {
            billQueryResponse.setCode(Response.Fail);
            billQueryResponse.setMessage("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5355\u636e\u4fe1\u606f");
        }
        return billQueryResponse;
    }

    @Override
    public BillQueryItemResponse queryBillItemByBillId(Long billId, Long batchNo) {
        logger.info("\u5355\u636eid{}", (Object)billId);
        OrdSalesbillItemExample itemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = itemExample.createCriteria().andSalesbillIdEqualTo(billId).andStatusNotIn((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.DELETED.value()}));
        if (batchNo != null && batchNo > 0L) {
            criteria.andBatchNoEqualTo(batchNo);
        }
        List<OrdSalesbillItemEntity> itemList = this.ordSalesbillItemDao.selectByExample(itemExample);
        ArrayList billItemList = Lists.newArrayList();
        if (itemList != null && itemList.size() > 0) {
            itemList.forEach(item -> {
                InvoiceBillItem billItem = new InvoiceBillItem();
                BeanUtils.copyProperties(item, billItem);
                billItemList.add(billItem);
            });
        }
        BillQueryItemResponse itemResponse = new BillQueryItemResponse();
        if (billItemList.size() > 0) {
            itemResponse.setResult((List)billItemList);
            itemResponse.setCode(Response.OK);
            itemResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        } else {
            itemResponse.setCode(Response.Fail);
            itemResponse.setMessage("\u672a\u67e5\u8be2\u5230\u5355\u636e\u5bf9\u5e94\u7684\u660e\u7ec6\u4fe1\u606f");
        }
        return itemResponse;
    }

    @Override
    public BillSourceResponse queryBillSource(Long batchNo) {
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        ordSalesbillItemExample.createCriteria().andBatchNoEqualTo(batchNo);
        long count = this.ordSalesbillItemDao.countByExample(ordSalesbillItemExample);
        List<Object> sourceList = Lists.newArrayList();
        int page = 0;
        while ((long)(page * 5000) < count) {
            ordSalesbillItemExample.setLimit(5000);
            ordSalesbillItemExample.setOffset(page * 5000);
            List<OrdSalesbillItemEntity> itemList = this.ordSalesbillItemDao.selectByExample(ordSalesbillItemExample);
            if (itemList != null && itemList.size() > 0) {
                ArrayList idList = Lists.newArrayList();
                ArrayList originItemList = Lists.newArrayList();
                itemList.forEach(item -> {
                    if (BillItemOrigin.ORIGINAL.value().equals(item.getOrigin())) {
                        originItemList.add(item);
                    } else {
                        idList.add(item.getSalesbillItemId());
                    }
                });
                OrdSalesbillSourceRelExample ordSalesbillSourceRelExample = new OrdSalesbillSourceRelExample();
                ordSalesbillSourceRelExample.createCriteria().andTargetSalesbillItemIdIn((List)idList);
                if (!CollectionUtils.isEmpty((Collection)idList)) {
                    logger.info("BillInvoiceServiceImpl.queryBillSource page:{}, idList:{}", (Object)page, (Object)idList.size());
                    List<OrdSalesbillSourceRelEntity> sourcePageList = this.ordSalesbillSourceRelDao.selectByExample(ordSalesbillSourceRelExample);
                    sourceList = this.convertToSourceBill(sourcePageList, sourceList);
                }
                sourceList = this.convertBillItemToSourceBill(originItemList, sourceList);
            }
            ++page;
        }
        BillSourceResponse billSourceResponse = new BillSourceResponse();
        if (sourceList.isEmpty()) {
            billSourceResponse.setCode(Response.Fail);
            billSourceResponse.setMessage("\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7ed3\u679c");
        } else {
            billSourceResponse.setCode(Response.OK);
            billSourceResponse.setMessage("\u67e5\u8be2\u6210\u529f");
            billSourceResponse.setResult((List)sourceList);
        }
        return billSourceResponse;
    }

    private List<BillSourceRelationship> convertToSourceBill(List<OrdSalesbillSourceRelEntity> sourceList, List<BillSourceRelationship> targetList) {
        if (!CollectionUtils.isEmpty(sourceList)) {
            sourceList.forEach(item -> {
                BillSourceRelationship source = new BillSourceRelationship();
                BeanUtils.copyProperties(item, source);
                targetList.add(source);
            });
        }
        return targetList;
    }

    private List<BillSourceRelationship> convertBillItemToSourceBill(List<OrdSalesbillItemEntity> sourceList, List<BillSourceRelationship> targetList) {
        if (!CollectionUtils.isEmpty(sourceList)) {
            sourceList.forEach(item -> {
                BillSourceRelationship source = new BillSourceRelationship();
                BeanUtils.copyProperties(item, source);
                source.setSourceSalesbillItemId(item.getSalesbillItemId());
                source.setTargetSalesbillItemId(item.getSalesbillItemId());
                source.setSourceSalesbillId(item.getSalesbillId());
                source.setTargetSalesbillId(item.getSalesbillId());
                source.setSourceAmountWithoutTax(item.getAmountWithoutTax());
                source.setSourceAmountWithTax(item.getAmountWithTax());
                source.setSourceTaxAmount(item.getTaxAmount());
                targetList.add(source);
            });
        }
        return targetList;
    }

    @Override
    @Transactional
    public void invoiceComplete(List<NoticeBillMsg> noticeBillMsgList) {
        if (CommonTools.isEmpty(noticeBillMsgList)) {
            logger.warn("\u5f00\u7968\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        for (NoticeBillMsg noticeBillMsg : noticeBillMsgList) {
            try {
                this.invoiceComplete(noticeBillMsg);
            }
            catch (Exception e) {
                logger.error("\u6279\u6b21\u53f7:{}\uff0c\u56de\u586b\u5355\u636e\u5931\u8d25", (Object)noticeBillMsg.getBatchNo(), (Object)e);
            }
        }
    }

    @Override
    @Transactional
    public void invoiceComplete(NoticeBillMsg noticeBillMsg) {
        if (noticeBillMsg == null || CommonTools.isEmpty(noticeBillMsg.getDetailInfoList())) {
            logger.warn("\u5f00\u7968\u6570\u636e\u4e0d\u6b63\u786e,{}", (Object)noticeBillMsg);
            return;
        }
        List<Object> billList = Lists.newArrayList();
        List<Object> itemList = Lists.newArrayList();
        try {
            logger.info("\u5f00\u7968\u6279\u6b21:{},invoiceCode:{}, invoiceNO:{}", new Object[]{noticeBillMsg.getBatchNo(), noticeBillMsg.getInvoiceCode(), noticeBillMsg.getInvoiceNo()});
            long batchNo = noticeBillMsg.getBatchNo();
            List detailInfoList = noticeBillMsg.getDetailInfoList();
            itemList = this.queryItemList(batchNo, detailInfoList);
            HashMap itemEntityMap = Maps.newHashMap();
            if (CommonTools.isEmpty(itemList)) {
                logger.error("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5355\u636e\u660e\u7ec6,\u6279\u6b21\u53f7:{}", (Object)batchNo);
            } else {
                ArrayList salesBillIdList = Lists.newArrayList();
                itemList.forEach(item -> {
                    itemEntityMap.put(item.getSalesbillItemId(), item);
                    if (!salesBillIdList.contains(item.getSalesbillId())) {
                        salesBillIdList.add(item.getSalesbillId());
                    }
                });
                OrdSalesbillExample billExample = new OrdSalesbillExample();
                billExample.createCriteria().andSalesbillIdIn((List)salesBillIdList);
                billList = this.ordSalesbillDao.selectByExample(billExample);
                HashMap billMap = Maps.newHashMap();
                billList.forEach(bill -> billMap.put(bill.getSalesbillId(), bill));
                detailInfoList.forEach(detailInfo -> {
                    long salesBillItemId = detailInfo.getSalesBillItemId();
                    OrdSalesbillItemEntity item = (OrdSalesbillItemEntity)((Object)((Object)itemEntityMap.get(salesBillItemId)));
                    this.updateBillItemAlreadyMakeOutAmount(item, (DetailInfo)detailInfo, 1);
                    if (item.getAlreadyAmountWithTax().compareTo(item.getAmountWithTax()) >= 0) {
                        item.setStatus(BillItemStatus.INVOICED.value());
                    }
                    OrdSalesbillEntity bill = (OrdSalesbillEntity)((Object)((Object)billMap.get(item.getSalesbillId())));
                    this.updateBillAlreadyMakeOutAmount(bill, (DetailInfo)detailInfo, 1);
                    if (bill.getAlreadyMakeAmountWithTax().compareTo(bill.getAmountWithTax()) >= 0) {
                        bill.setUploadConfirmFlag(SalesBillCatalog.ALREADY_MAKE.value());
                        bill.setReceiveConfirmFlag(SalesBillCatalog.ALREADY_MAKE.value());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("\u5f00\u7968\u5b8c\u6210\u66f4\u65b0\u5355\u636e\u548c\u5355\u636e\u660e\u7ec6\u53d1\u751f\u5f02\u5e38,\u6279\u6b21\u53f7:{}", (Object)noticeBillMsg.getBatchNo(), (Object)e);
        }
        this.ordSalesbillItemExtDao.batchUpdateBillItemAlreadyMakeOutAmountAndStatus((List<OrdSalesbillItemEntity>)itemList);
        this.ordSalesbillExtDao.batchUpdateBillAlreadyMakeOutAmountAndStatus((List<OrdSalesbillEntity>)billList);
    }

    @Override
    public BillQueryResponse queryBillByBatchNo(Long batchNo) {
        Map<Long, List<InvoiceBillMain>> resultMap = this.queryBillByBatchNoList(Lists.newArrayList((Object[])new Long[]{batchNo}), null);
        if (CollectionUtils.isEmpty(resultMap)) {
            return BillQueryResponse.fail((String)CommonTools.format("\u6839\u636e\u6279\u6b21\u53f7{}\u672a\u67e5\u8be2\u5230", batchNo));
        }
        BillQueryResponse response = new BillQueryResponse();
        response.setCode(BaseResponse.OK);
        response.setResult(resultMap.get(batchNo));
        return response;
    }

    @Override
    public BillQueryItemResponse queryBillItemBatchNo(Long batchNo) {
        BillQueryItemResponse response = new BillQueryItemResponse();
        try {
            logger.info("\u67e5\u8be2\u5355\u636e\u4fe1\u606f\uff0c\u6279\u6b21\u53f7{}", (Object)batchNo);
            OrdSalesbillItemExample example = BillInvoiceServiceImpl.byBatchNo(batchNo);
            logger.info("selectByExample\uff0cexample:{}", (Object)example);
            List<OrdSalesbillItemEntity> itemList = this.ordSalesbillItemDao.selectByExample(example);
            logger.info("selectByExample\uff0citemList:{}", itemList);
            ArrayList invoiceBillItems = Lists.newArrayList();
            for (OrdSalesbillItemEntity ordSalesbillItemEntity : itemList) {
                InvoiceBillItem invoiceBillItem = new InvoiceBillItem();
                BeanUtils.copyProperties((Object)ordSalesbillItemEntity, invoiceBillItem);
                invoiceBillItems.add(invoiceBillItem);
            }
            response.setResult((List)invoiceBillItems);
            response.setCode(BaseResponse.OK);
        }
        catch (Exception e) {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u67e5\u8be2\u5355\u636e\u660e\u7ec6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return response;
    }

    @Override
    public BillBatchQueryResponse queryBillByBatchNo(MsSplitAndMakeOutRequest request) {
        List<Long> batchNoList = request.getParamList().stream().map(MsSplitAndMakeOutParams::getBatchNo).collect(Collectors.toList());
        Map<Long, List<InvoiceBillMain>> resultMap = this.queryBillByBatchNoList(batchNoList, request.getSort());
        if (CollectionUtils.isEmpty(resultMap)) {
            return BillBatchQueryResponse.fail(batchNoList, (String)"\u6839\u636e\u6279\u6b21\u53f7\u672a\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f");
        }
        return BillBatchQueryResponse.ok(batchNoList, (String)"", resultMap);
    }

    public Map<Long, List<InvoiceBillMain>> queryBillByBatchNoList(List<Long> batchNoList, SearchSort sort) {
        String fieldName;
        StopWatch stopWatch = new StopWatch("start query batch");
        HashMap resultMap = Maps.newHashMap();
        logger.info("\u67e5\u8be2\u5355\u636e\u4fe1\u606f\uff0c\u6279\u6b21\u53f7{},sort{}", batchNoList, (Object)JsonUtils.writeObjectToFastJson(sort));
        OrdSalesbillItemExample example = new OrdSalesbillItemExample();
        example.createCriteria().andBatchNoIn((List)batchNoList).andStatusNotIn((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.ABANDONED.value(), BillItemStatus.DELETED.value(), BillItemStatus.REJECTED.value()}));
        boolean isDefault = false;
        if (sort != null && !CommonTools.isEmpty(fieldName = sort.getFieldName())) {
            isDefault = true;
            String field_name = CommonTools.camelToUnderline(fieldName);
            String order = "0".equals(sort.getSort()) ? "ASC" : "DESC";
            example.setOrderByClause(field_name + " " + order);
        }
        stopWatch.start("start query by batch-no");
        List<OrdSalesbillItemEntity> itemList = this.ordSalesbillItemDao.selectByExample(example);
        stopWatch.stop();
        HashMap invoiceBillItemMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(itemList)) {
            return null;
        }
        if (isDefault) {
            itemList = this.sortPreInvoiceList(itemList, sort);
        }
        ArrayList salesBillIdList = Lists.newArrayList();
        stopWatch.start("start copy the field");
        for (OrdSalesbillItemEntity item : itemList) {
            List<InvoiceBillItem> tmpList;
            if (!salesBillIdList.contains(item.getSalesbillId())) {
                salesBillIdList.add(item.getSalesbillId());
            }
            BillInvoiceMapKey bm2 = new BillInvoiceMapKey();
            bm2.setBatchNo(item.getBatchNo());
            bm2.setSalesBillId(item.getSalesbillId());
            if (invoiceBillItemMap.containsKey(bm2)) {
                tmpList = (List)invoiceBillItemMap.get(bm2);
            } else {
                tmpList = Lists.newArrayList();
                invoiceBillItemMap.put(bm2, tmpList);
            }
            InvoiceBillItem invoiceBillItem = new InvoiceBillItem();
            BeanUtils.copyProperties((Object)item, invoiceBillItem);
            tmpList.add(invoiceBillItem);
        }
        stopWatch.stop();
        OrdSalesbillExample salesbillExample = new OrdSalesbillExample();
        salesbillExample.createCriteria().andSalesbillIdIn((List)salesBillIdList).andStatusNotIn((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.ABANDONED.value(), SalesBillCatalog.NO_EFFECT.value()}));
        stopWatch.start("start query by bill-id");
        List<OrdSalesbillEntity> salesbillEntities = this.ordSalesbillDao.selectByExample(salesbillExample);
        stopWatch.stop();
        if (CollectionUtils.isEmpty(salesbillEntities)) {
            return null;
        }
        HashMap billMap = Maps.newHashMap();
        salesbillEntities.forEach(salesBill -> billMap.put(salesBill.getSalesbillId(), salesBill));
        invoiceBillItemMap.forEach((bm, value) -> {
            List<InvoiceBillMain> invoiceBillMainList;
            if (resultMap.containsKey(bm.getBatchNo())) {
                invoiceBillMainList = (List)resultMap.get(bm.getBatchNo());
            } else {
                invoiceBillMainList = Lists.newArrayList();
                resultMap.put(bm.getBatchNo(), invoiceBillMainList);
            }
            if (billMap.containsKey(bm.getSalesBillId())) {
                InvoiceBillMain billMain = new InvoiceBillMain();
                OrdSalesbillEntity salesBill = (OrdSalesbillEntity)((Object)((Object)billMap.get(((InvoiceBillItem)value.get(0)).getSalesbillId())));
                BeanUtils.copyProperties((Object)salesBill, billMain);
                billMain.setBillItems(value);
                invoiceBillMainList.add(billMain);
            }
        });
        logger.info(stopWatch.prettyPrint());
        double seconds = stopWatch.getTotalTimeSeconds();
        logger.info("\u5171\u8017\u8d39\u79d2\u6570=" + seconds);
        return resultMap;
    }

    public List<OrdSalesbillItemEntity> sortPreInvoiceList(List<OrdSalesbillItemEntity> itemEntities, SearchSort sort) {
        ArrayList items;
        String salesBillNo;
        ArrayList list = Lists.newArrayList();
        List salesBillIds = itemEntities.stream().map(m -> m.getSalesbillId()).collect(Collectors.toList());
        Set sets = itemEntities.stream().map(m -> m.getSalesbillNo()).collect(Collectors.toSet());
        List<Object> salesBillNos = Lists.newArrayList(sets);
        Collections.reverse(salesBillNos);
        if (sort.getMainSort() != null && sort.getMainSort().getFieldName() != null) {
            String mainSortFieldName = sort.getMainSort().getFieldName();
            String mainSort = sort.getMainSort().getSort();
            OrdSalesbillExample salesbillExample = new OrdSalesbillExample();
            salesbillExample.createCriteria().andSalesbillIdIn(salesBillIds).andStatusNotIn((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.ABANDONED.value(), SalesBillCatalog.NO_EFFECT.value()}));
            String field_name = CommonTools.camelToUnderline(mainSortFieldName);
            String order = "0".equals(mainSort) ? "ASC" : "DESC";
            salesbillExample.setOrderByClause(field_name + " " + order);
            List<OrdSalesbillEntity> salesbillEntities = this.ordSalesbillDao.selectByExample(salesbillExample);
            salesBillNos = salesbillEntities.stream().map(m -> m.getSalesbillNo()).collect(Collectors.toList());
        }
        if (!sort.getFieldName().equals("salesbillItemId")) {
            for (int i = 0; i < salesBillNos.size(); ++i) {
                salesBillNo = (String)salesBillNos.get(i);
                items = Lists.newArrayList();
                itemEntities.stream().forEach(m -> {
                    if (m.getSalesbillNo().equals(salesBillNo)) {
                        items.add(m);
                    }
                });
                list.addAll(items);
            }
        } else {
            for (int i = 0; i < salesBillNos.size(); ++i) {
                salesBillNo = (String)salesBillNos.get(i);
                items = Lists.newArrayList();
                itemEntities.stream().forEach(m -> {
                    if (m.getSalesbillNo().equals(salesBillNo)) {
                        items.add(m);
                    }
                });
                Collections.sort(items, new Comparator<OrdSalesbillItemEntity>(){

                    @Override
                    public int compare(OrdSalesbillItemEntity o1, OrdSalesbillItemEntity o2) {
                        return o1.getSalesbillItemNo().compareTo(o2.getSalesbillItemNo());
                    }
                });
                list.addAll(items);
            }
        }
        return list;
    }

    private List<InvoiceBillMain> generateBillMainList(List<OrdSalesbillEntity> entityList, Long batchNo) {
        ArrayList billList = Lists.newArrayList();
        entityList.forEach(entity -> {
            InvoiceBillMain billMain = new InvoiceBillMain();
            BeanUtils.copyProperties(entity, billMain);
            BillQueryItemResponse billQueryItemResponse = this.queryBillItemByBillId(entity.getSalesbillId(), batchNo);
            if (Response.OK.equals(billQueryItemResponse.getCode())) {
                billMain.setBillItems(billQueryItemResponse.getResult());
            }
            billList.add(billMain);
        });
        return billList;
    }

    @Override
    public Response afterDeletePreInvoice(List<Long> batchNoList) {
        return this.clearSalesBillItemBatchNo(batchNoList, 2);
    }

    @Override
    public Response afterCancelPreviewPreInvoice(List<Long> batchNoList) {
        return this.clearSalesBillItemBatchNo(batchNoList, 1);
    }

    private Response clearSalesBillItemBatchNo(List<Long> batchNoList, int type) {
        logger.info("{},\u6279\u6b21\u53f7{}, \u64cd\u4f5c{}", new Object[]{type == 1 ? "\u53d6\u6d88\u9884\u5236\u53d1\u7968\u9884\u89c8" : "\u5220\u9664\u9884\u5236\u53d1\u7968", batchNoList, type});
        StringBuilder buf = new StringBuilder();
        int code = Response.Fail;
        for (Long batchNo : batchNoList) {
            try {
                OrdSalesbillItemExample itemExample = new OrdSalesbillItemExample();
                itemExample.createCriteria().andBatchNoEqualTo(batchNo);
                List<OrdSalesbillItemEntity> itemList = this.ordSalesbillItemDao.selectByExample(itemExample);
                ArrayList itemIdList = Lists.newArrayList();
                itemList.forEach(item -> itemIdList.add(item.getSalesbillItemId()));
                if (CollectionUtils.isEmpty((Collection)itemIdList)) {
                    buf.append(batchNo).append("\u672a\u67e5\u8be2\u5230\u660e\u7ec6.");
                    continue;
                }
                itemExample.clear();
                itemExample.createCriteria().andSalesbillItemIdIn((List)itemIdList);
                OrdSalesbillItemExtBatchNoUpdate ordSalesbillItemExtBatchNoUpdate = new OrdSalesbillItemExtBatchNoUpdate();
                ordSalesbillItemExtBatchNoUpdate.setAfterBatchNo(0L);
                ordSalesbillItemExtBatchNoUpdate.setAfterStatus(BillItemStatus.NORMAL.value());
                ordSalesbillItemExtBatchNoUpdate.setPreBatchNo(batchNo);
                ordSalesbillItemExtBatchNoUpdate.setPreStatus(BillItemStatus.PRE_INVOICED.value());
                ordSalesbillItemExtBatchNoUpdate.setSalesbillItemIdList(itemIdList);
                ordSalesbillItemExtBatchNoUpdate.setRuleId(0L);
                int retValue = this.ordSalesbillItemExtDao.updateOrdSalesbillItemEntityBatchNoByIds(ordSalesbillItemExtBatchNoUpdate);
                buf.append(batchNo);
                if (retValue == itemList.size()) {
                    buf.append("\u91cd\u7f6e\u6210\u529f");
                    code = Response.OK;
                } else if (retValue == 0) {
                    buf.append("\u91cd\u7f6e\u5931\u8d25");
                } else {
                    buf.append("\u90e8\u5206\u6210\u529f, \u5171:").append(itemIdList.size()).append(", \u6210\u529f:").append(retValue).append(", \u5931\u8d25:").append(itemIdList.size() - retValue);
                }
                int deleteValue = this.ordAutoSalesBillItemBatchDao.deleteOrdSalesbillItemEntityByBatchNo(batchNo);
                logger.debug("batchNo:{}, deleteValue:{}", (Object)batchNo, (Object)deleteValue);
            }
            catch (Exception e) {
                logger.error("\u6279\u6b21\u53f7{}\u91cd\u7f6e\u5355\u636e\u660e\u7ec6\u5931\u8d25.", (Object)batchNo, (Object)e);
            }
        }
        return Response.from((Integer)code, (String)buf.toString());
    }

    @Override
    @Transactional
    public void revertBillAndItem(NoticeBillReleaseMsg releaseMsg) {
        BigDecimal alreadyMakeOutAmount;
        long batchNo = releaseMsg.getBatchNo();
        List<OrdSalesbillItemEntity> itemList = this.queryItemList(batchNo, releaseMsg.getDetailInfoList());
        if (CollectionUtils.isEmpty(itemList)) {
            logger.warn("\u91ca\u653e\u5931\u8d25\uff0c\u6839\u636e\u6279\u6b21\u53f7:{}, itemIdList:{}\u672a\u67e5\u5230\u6570\u636e", (Object)batchNo, (Object)releaseMsg.getDetailInfoList());
            return;
        }
        ArrayList billIdList = Lists.newArrayList();
        HashMap itemEntityMap = Maps.newHashMap();
        HashMap billMap = Maps.newHashMap();
        itemList.forEach(item -> {
            itemEntityMap.put(item.getSalesbillItemId(), item);
            billIdList.add(item.getSalesbillId());
        });
        OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
        ordSalesbillExample.createCriteria().andSalesbillIdIn((List)billIdList);
        List<OrdSalesbillEntity> billList = this.ordSalesbillDao.selectByExample(ordSalesbillExample);
        billList.forEach(bill -> billMap.put(bill.getSalesbillId(), bill));
        releaseMsg.getDetailInfoList().forEach(detailInfo -> {
            OrdSalesbillItemEntity billItem = (OrdSalesbillItemEntity)((Object)((Object)itemEntityMap.get(detailInfo.getSalesBillItemId())));
            OrdSalesbillEntity bill = (OrdSalesbillEntity)((Object)((Object)billMap.get(billItem.getSalesbillId())));
            if (releaseMsg.getOperationType() == InvoiceOperation.ABANDON_INVOICE.value()) {
                this.updateBillItemAlreadyMakeOutAmount(billItem, (DetailInfo)detailInfo, 2);
                this.updateBillAlreadyMakeOutAmount(bill, (DetailInfo)detailInfo, 2);
            } else if (releaseMsg.getOperationType() == InvoiceOperation.RED_INVOICE.value()) {
                this.updateBillItemAlreadyMakeOutAmount(billItem, (DetailInfo)detailInfo, 2);
                this.updateBillAlreadyMakeOutAmount(bill, (DetailInfo)detailInfo, 2);
            } else if (releaseMsg.getOperationType() == InvoiceOperation.ABANDON_RED_INVOICE.value()) {
                this.updateBillItemAlreadyMakeOutAmount(billItem, (DetailInfo)detailInfo, 1);
                this.updateBillAlreadyMakeOutAmount(bill, (DetailInfo)detailInfo, 1);
            }
            if (releaseMsg.getReleaseType() == BillReleaseType.REVERT_RELEASE.value().intValue()) {
                if (billItem.getAlreadyAmountWithTax().compareTo(billItem.getAmountWithTax()) >= 0) {
                    billItem.setStatus(BillItemStatus.INVOICED.value());
                }
                if (bill.getAlreadyMakeAmountWithTax().compareTo(bill.getAmountWithTax()) >= 0) {
                    bill.setUploadConfirmFlag(SalesBillCatalog.ALREADY_MAKE.value());
                    bill.setReceiveConfirmFlag(SalesBillCatalog.ALREADY_MAKE.value());
                }
            }
        });
        this.ordSalesbillItemExtDao.batchUpdateBillItemAlreadyMakeOutAmountAndStatus(itemList);
        this.ordSalesbillExtDao.batchUpdateBillAlreadyMakeOutAmountAndStatus(billList);
        if (releaseMsg.getReleaseType() == BillReleaseType.RELEASE.value().intValue() && BigDecimal.ZERO.compareTo(alreadyMakeOutAmount = this.ordSalesbillItemExtDao.selectBatchAlreadyMakeOutAmountByBatchNo(releaseMsg.getBatchNo())) == 0) {
            List<Long> salesBillIdList = this.ordSalesbillItemExtDao.selectBillIdByBatchNo(batchNo);
            OrdSalesbillItemExtExample itemExtExample = new OrdSalesbillItemExtExample();
            itemExtExample.setPreBatchNo(batchNo);
            itemExtExample.setAfterBatchNo(0L);
            itemExtExample.setPreStatus(BillItemStatus.INVOICED.value());
            itemExtExample.setAfterStatus(BillItemStatus.NORMAL.value());
            this.ordSalesbillItemExtDao.updateBillItemStatusByBatchNo(itemExtExample);
            OrdSalesbillExtExample billExtExample = new OrdSalesbillExtExample();
            billExtExample.setSalesbillIdList(salesBillIdList);
            billExtExample.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
            billExtExample.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
            this.ordSalesbillExtDao.batchUpdateBillConfirmFlagByIds(billExtExample);
        }
    }

    private List<OrdSalesbillItemEntity> queryItemList(long batchNo, List<DetailInfo> detailInfoList) {
        ArrayList itemIdList = Lists.newArrayList();
        detailInfoList.forEach(detailInfo -> itemIdList.add(detailInfo.getSalesBillItemId()));
        OrdSalesbillItemExample example = new OrdSalesbillItemExample();
        example.createCriteria().andSalesbillItemIdIn((List)itemIdList).andBatchNoEqualTo(batchNo);
        return this.ordSalesbillItemDao.selectByExample(example);
    }

    @Override
    public Response updateBillItemRuleIdBatchNo(Long batchNo, Long ruleId) {
        Response response = new Response();
        try {
            logger.info("\u67e5\u8be2\u5355\u636e\u4fe1\u606f\uff0c\u6279\u6b21\u53f7{}", (Object)batchNo);
            OrdSalesbillItemExample example = BillInvoiceServiceImpl.byBatchNo(batchNo);
            logger.info("selectByExample\uff0cexample:{}", (Object)example);
            OrdSalesbillItemEntity ordSalesbillItemEntity = new OrdSalesbillItemEntity();
            ordSalesbillItemEntity.setRuleId(ruleId);
            int num = this.ordSalesbillItemDao.updateByExampleSelective(ordSalesbillItemEntity, example);
            logger.info("updateByExample\uff0cnum:{}", (Object)num);
            response.setResult((Object)num);
            response.setCode(BaseResponse.OK);
        }
        catch (Exception e) {
            response.setCode(BaseResponse.Fail);
            response.setMessage("\u66f4\u65b0\u6279\u6b21\u3010" + batchNo + "\u3011\uff1a\u89c4\u5219ID\u5f02\u5e38" + e.getMessage());
        }
        return response;
    }

    private static OrdSalesbillItemExample byBatchNo(long batchNo) {
        OrdSalesbillItemExample example = new OrdSalesbillItemExample();
        example.createCriteria().andBatchNoEqualTo(batchNo).andStatusNotIn((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.ABANDONED.value(), BillItemStatus.DELETED.value(), BillItemStatus.REJECTED.value()}));
        return example;
    }

    private void updateBillAlreadyMakeOutAmount(OrdSalesbillEntity bill, DetailInfo detailInfo, int type) {
        switch (type) {
            case 1: {
                bill.setAlreadyMakeAmountWithTax(this.add(bill.getAlreadyMakeAmountWithTax(), detailInfo.getAmountWithTax()));
                bill.setAlreadyMakeAmountWithoutTax(this.add(bill.getAlreadyMakeAmountWithoutTax(), detailInfo.getAmountWithoutTax()));
                bill.setAlreadyMakeAmountTaxAmount(this.add(bill.getAlreadyMakeAmountTaxAmount(), detailInfo.getTaxAmount()));
                break;
            }
            case 2: {
                bill.setAlreadyMakeAmountWithTax(this.subtract(bill.getAlreadyMakeAmountWithTax(), detailInfo.getAmountWithTax()));
                bill.setAlreadyMakeAmountWithoutTax(this.subtract(bill.getAlreadyMakeAmountWithoutTax(), detailInfo.getAmountWithoutTax()));
                bill.setAlreadyMakeAmountTaxAmount(this.subtract(bill.getAlreadyMakeAmountTaxAmount(), detailInfo.getTaxAmount()));
                break;
            }
        }
    }

    private void updateBillItemAlreadyMakeOutAmount(OrdSalesbillItemEntity billItem, DetailInfo detailInfo, int type) {
        switch (type) {
            case 1: {
                billItem.setAlreadyTaxAmount(this.add(billItem.getAlreadyTaxAmount(), detailInfo.getTaxAmount()));
                billItem.setAlreadyAmountWithTax(this.add(billItem.getAlreadyAmountWithTax(), detailInfo.getAmountWithTax()));
                billItem.setAlreadyAmountWithoutTax(this.add(billItem.getAlreadyAmountWithoutTax(), detailInfo.getAmountWithoutTax()));
                break;
            }
            case 2: {
                billItem.setAlreadyTaxAmount(this.subtract(billItem.getAlreadyTaxAmount(), detailInfo.getTaxAmount()));
                billItem.setAlreadyAmountWithTax(this.subtract(billItem.getAlreadyAmountWithTax(), detailInfo.getAmountWithTax()));
                billItem.setAlreadyAmountWithoutTax(this.subtract(billItem.getAlreadyAmountWithoutTax(), detailInfo.getAmountWithoutTax()));
                break;
            }
        }
    }

    private BigDecimal subtract(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null) {
            bd1 = BigDecimal.ZERO;
        }
        if (bd2 == null) {
            bd2 = BigDecimal.ZERO;
        }
        return bd1.subtract(bd2);
    }

    private BigDecimal add(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null) {
            bd1 = BigDecimal.ZERO;
        }
        if (bd2 == null) {
            bd2 = BigDecimal.ZERO;
        }
        return bd1.add(bd2);
    }
}

