/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.cache.taxcode.LocalTaxCodeCacheManager;
import com.xforceplus.phoenix.bill.client.model.BillDetailResponse;
import com.xforceplus.phoenix.bill.client.model.BillItem;
import com.xforceplus.phoenix.bill.client.model.BillItemUpdateModel;
import com.xforceplus.phoenix.bill.client.model.BillMain;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.bill.client.splitconfig.SplitConfigClient;
import com.xforceplus.phoenix.bill.component.BillUpdateOperationBean;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.component.SplitMergeHistoryComponent;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryActionType;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryTargetType;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.CooperateModifyStatus;
import com.xforceplus.phoenix.bill.core.service.BillQueryService;
import com.xforceplus.phoenix.bill.core.service.BillUpdateService;
import com.xforceplus.phoenix.bill.core.service.BillValidateService;
import com.xforceplus.phoenix.bill.core.tools.BillSearchTools;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSalesbillItemExtDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.ReflectUtil;
import com.xforceplus.phoenix.taxcode.client.model.GoodsDetailReponse;
import com.xforceplus.phoenix.taxcode.client.model.GoodsModel;
import com.xforceplus.phoenix.taxcode.client.model.TaxConvertCodeModel;
import com.xforceplus.phoenix.taxcode.client.model.TaxNationalCode;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillUpdateServiceImpl
implements BillUpdateService {
    private Logger logger = LoggerFactory.getLogger(BillUpdateServiceImpl.class);
    @Autowired
    OrdSalesbillDao ordSalesbillDao;
    @Autowired
    OrdSalesbillItemDao ordSalesbillItemDao;
    @Autowired
    private BillValidateService billValidateService;
    @Autowired
    LocalConfigMetadataCacheManager localConfigMetadataCacheManager;
    @Autowired
    BillQueryService billQueryService;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    SplitMergeHistoryComponent splitMergeHistoryComponent;
    @Autowired
    private SplitConfigClient splitConfigClient;
    @Autowired
    OrdSalesbillItemExtDao ordSalesbillItemExtDao;
    @Autowired
    LocalTaxCodeCacheManager localTaxCodeCacheManager;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Response updateBatch(BillItemUpdateModel billItemUpdateModel) {
        Long id;
        LinkedList<Long> tempList;
        this.logger.info("---------\u6b63\u5728\u6267\u884c\u6279\u91cf\u66f4\u65b0------------");
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        this.convertToRealGoods(billItemUpdateModel);
        BillMain updateBillItems = billItemUpdateModel.getUpdateBillItems();
        BillItem updateDetailItems = billItemUpdateModel.getUpdateDetailItems();
        Set<String> checkBillSet = ReflectUtil.getNotBlankFiledsInfo(updateBillItems);
        Set<String> checkBillDetailSet = ReflectUtil.getNotBlankFiledsInfo(updateDetailItems);
        if (checkBillSet.isEmpty() && checkBillDetailSet.isEmpty()) {
            return Response.failed((String)"\u4fee\u6539\u7684\u5185\u5bb9\u4e3a\u7a7a \uff01\uff01");
        }
        BillSearchModel billSearchModel = new BillSearchModel();
        this.convertMakeoutInvoiceRequest2BillSearchModel(billItemUpdateModel, billSearchModel);
        billSearchModel.setPageSize(Integer.valueOf(100));
        BillDetailResponse response = this.billQueryService.getBillListByDetail(billSearchModel);
        if (response.getCode() == 0) {
            return Response.failed((String)"\u67e5\u8be2\u51fa\u73b0\u9519\u8bef\uff01");
        }
        if (response.getResult().getTotal() == 0L) {
            return Response.failed((String)"\u672a\u5339\u914d\u5230\u6570\u636e\uff01");
        }
        if (response.getResult().getTotal() > 1000L) {
            return Response.failed((String)"\u4e00\u6b21\u4fee\u6539\u660e\u7ec6\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71000\u6761");
        }
        List ordSalesbillDetailVOList = response.getResult().getList();
        long total = response.getResult().getTotal();
        if (total > 100L) {
            long totalPage = total / 100L;
            int pageNo = 2;
            while ((long)pageNo <= totalPage + 1L) {
                billSearchModel.setPageNo(Integer.valueOf(pageNo));
                BillDetailResponse pageResponse = this.billQueryService.getBillListByDetail(billSearchModel);
                if (pageResponse.getCode() == 1) {
                    ordSalesbillDetailVOList.addAll(pageResponse.getResult().getList());
                }
                ++pageNo;
            }
        }
        HashSet<Long> billIdSet = new HashSet<Long>();
        HashSet<Long> billIdWithModifySet = new HashSet<Long>();
        HashSet billItemIdSet = new HashSet();
        if (checkBillDetailSet.contains("taxRate")) {
            TaxNationalCode taxNationalCode;
            Response checkTaxRateResult = this.checkTaxRate(ordSalesbillDetailVOList, updateDetailItems);
            if (checkTaxRateResult.getCode() == 0) {
                return checkTaxRateResult;
            }
            String goodsTaxNo = updateDetailItems.getGoodsTaxNo();
            if (!CommonTools.isEmpty(goodsTaxNo) && (taxNationalCode = this.localTaxCodeCacheManager.getNationalTaxCode(goodsTaxNo)) != null) {
                updateDetailItems.setGoodsNoVer(taxNationalCode.getVersion());
                updateDetailItems.setItemShortName(taxNationalCode.getTaxcodeShortName());
            }
            updateDetailItems.setTaxRate(null);
        }
        ArrayList<OrdSalesbillItemEntity> billItemEntities = new ArrayList<OrdSalesbillItemEntity>();
        int size = ordSalesbillDetailVOList.size();
        for (int i = 0; i < size; ++i) {
            OrdSalesbillVO ordSalesbillVO;
            OrdSalesbillDetailVO ordSalesbillDetailVO = (OrdSalesbillDetailVO)ordSalesbillDetailVOList.get(i);
            if (!"0".equals(ordSalesbillDetailVO.getOrdSalesbillItemVO().getOrigin())) {
                return Response.failed((String)"\u62c6\u5206\u5408\u5e76\u7684\u5355\u636e\u4e0d\u80fd\u4fee\u6539!");
            }
            OrdSalesbillItemEntity billItemEntity = new OrdSalesbillItemEntity();
            Response checkQuantityPrice = this.supplementPricesAndQuantity(ordSalesbillDetailVO, updateDetailItems, checkBillDetailSet, billItemEntity);
            if (checkQuantityPrice.getCode() == 0) {
                return checkQuantityPrice;
            }
            checkBillDetailSet = ReflectUtil.getNotBlankFiledsInfo(updateDetailItems);
            Response checkMetaDataResult = this.checkBillMainBeforeUpdate(checkBillSet, checkBillDetailSet, billItemUpdateModel, ordSalesbillDetailVO);
            if (checkMetaDataResult.getCode() == 0) {
                return checkMetaDataResult;
            }
            if (!"-1".equals(ordSalesbillDetailVO.getOrdSalesbillVO().getReceiveConfirmFlag())) {
                ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO();
                if (ordSalesbillVO != null && ordSalesbillVO.getSalesbillId() != null) {
                    billIdWithModifySet.add(ordSalesbillVO.getSalesbillId());
                }
            } else if (!checkBillSet.isEmpty() && (ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO()) != null && ordSalesbillVO.getSalesbillId() != null) {
                billIdSet.add(ordSalesbillVO.getSalesbillId());
            }
            if (checkBillDetailSet.isEmpty()) continue;
            OrdSalesbillItemVO ordSalesbillItemVO = ordSalesbillDetailVO.getOrdSalesbillItemVO();
            if (ordSalesbillDetailVO == null || ordSalesbillItemVO.getSalesbillItemId() == null) continue;
            billItemEntity.setSalesbillItemId(ordSalesbillItemVO.getSalesbillItemId());
            if (checkBillDetailSet.contains("taxConvertCode")) {
                billItemEntity.setTaxConvertCode("");
            }
            if (updateDetailItems.getItemSpec() != null) {
                billItemEntity.setItemCode(updateDetailItems.getItemSpec().trim());
            }
            if (updateDetailItems.getQuantityUnit() != null) {
                billItemEntity.setQuantityUnit(updateDetailItems.getQuantityUnit().trim());
            }
            billItemEntities.add(billItemEntity);
        }
        if (!checkBillSet.isEmpty()) {
            Iterator iterator = billIdSet.iterator();
            OrdSalesbillEntity billEntity = new OrdSalesbillEntity();
            BeanUtils.copyProperties(updateBillItems, (Object)billEntity);
            tempList = new LinkedList<Long>();
            while (iterator.hasNext()) {
                id = (Long)iterator.next();
                tempList.add(id);
                if (tempList.size() <= 1000) continue;
                this.updateBillMain(tempList, billEntity);
            }
            if (tempList.size() > 0) {
                this.updateBillMain(tempList, billEntity);
            }
        }
        if (!billIdWithModifySet.isEmpty()) {
            Iterator iterator = billIdWithModifySet.iterator();
            OrdSalesbillEntity billEntity = new OrdSalesbillEntity();
            BeanUtils.copyProperties(updateBillItems, (Object)billEntity);
            billEntity.setCooperateModifyStatus(CooperateModifyStatus.modified.value());
            tempList = new LinkedList();
            while (iterator.hasNext()) {
                id = (Long)iterator.next();
                tempList.add(id);
                if (tempList.size() <= 1000) continue;
                this.updateBillMain(tempList, billEntity);
            }
            if (tempList.size() > 0) {
                this.updateBillMain(tempList, billEntity);
            }
        }
        if (!billItemEntities.isEmpty()) {
            this.updateBillDetail(billItemEntities);
        }
        this.insertHistorylogs(billItemUpdateModel, ordSalesbillDetailVOList, billItemEntities, userInfo);
        return Response.ok((String)"\u6279\u91cf\u66f4\u65b0\u6210\u529f");
    }

    private BillSearchModel convertMakeoutInvoiceRequest2BillSearchModel(BillItemUpdateModel billItemUpdateModel, BillSearchModel billSearchModel) {
        billSearchModel.setUserRole(String.valueOf(billItemUpdateModel.getUserRole()));
        billSearchModel.setBillStatus(billItemUpdateModel.getConditions().getBillStatus());
        billSearchModel.setUploadSide(billItemUpdateModel.getConditions().getUploadSide());
        billSearchModel.setOtherSideCompanyGroupId(billItemUpdateModel.getConditions().getOtherSideCompanyGroupId());
        billSearchModel.setBillType(billItemUpdateModel.getConditions().getBillType());
        billSearchModel.setBillForInvoice(billItemUpdateModel.getConditions().getBillForInvoice());
        billSearchModel.setGroups(billItemUpdateModel.getConditions().getGroups());
        ArrayList filterGroups = Lists.newArrayList();
        boolean isAllSelected = billItemUpdateModel.getIsAllSelected();
        if (isAllSelected) {
            BillSearchTools.setExcludeFilterGroups(billItemUpdateModel.getExcludes(), filterGroups);
        } else {
            BillSearchTools.setIncluceFilterGroups(billItemUpdateModel.getIncludes(), filterGroups);
        }
        billSearchModel.setChildGroups((List)filterGroups);
        return billSearchModel;
    }

    private void updateBillMain(List<Long> idList, OrdSalesbillEntity billEntity) {
        OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
        ordSalesbillExample.createCriteria().andSalesbillIdIn((List)idList).andStatusEqualTo(1);
        this.ordSalesbillDao.updateByExampleSelective(billEntity, ordSalesbillExample);
        idList.clear();
    }

    private void updateBillDetail(List<OrdSalesbillItemEntity> list) {
        this.ordSalesbillItemExtDao.updateBatchSelective(list);
    }

    private Response supplementPricesAndQuantity(OrdSalesbillDetailVO ordSalesbillDetailVO, BillItem updateDetailItems, Set checkBillDetailSet, OrdSalesbillItemEntity billItemEntity) {
        BigDecimal newAmount;
        BigDecimal newQuantity;
        String tempQuantityStr;
        BigDecimal tempQuantity;
        BigDecimal decimalPrice;
        int count;
        String unitPrice = updateDetailItems.getUnitPrice();
        String unitPriceWithTax = updateDetailItems.getUnitPriceWithTax();
        String quantity = updateDetailItems.getQuantity();
        BigDecimal originAmountWithoutTax = ordSalesbillDetailVO.getOrdSalesbillItemVO().getAmountWithoutTax();
        BigDecimal originAmountWithTax = ordSalesbillDetailVO.getOrdSalesbillItemVO().getAmountWithTax();
        BigDecimal taxRate = ordSalesbillDetailVO.getOrdSalesbillItemVO().getTaxRate();
        boolean blueFlag = true;
        if (originAmountWithTax.compareTo(BigDecimal.ZERO) < 0) {
            blueFlag = false;
        }
        BigDecimal zero = BigDecimal.ZERO;
        if (unitPrice != null && BigDecimal.ZERO.compareTo(new BigDecimal(unitPrice)) == 0) {
            if (CommonTools.isEmpty(unitPriceWithTax) && CommonTools.isEmpty(quantity)) {
                updateDetailItems.setUnitPriceWithTax("0.00");
                updateDetailItems.setQuantity("0");
                billItemEntity.setUnitPriceWithTax(BigDecimal.ZERO);
                billItemEntity.setQuantity(BigDecimal.ZERO);
                billItemEntity.setUnitPrice(BigDecimal.ZERO);
                BeanUtils.copyProperties(updateDetailItems, (Object)billItemEntity);
                return Response.ok((String)"");
            }
            unitPrice = null;
            checkBillDetailSet.remove("unitPrice");
            updateDetailItems.setUnitPrice(null);
        }
        if (unitPrice != null && !CommonTools.isNum(unitPrice).booleanValue()) {
            String msg = "\u4fee\u6539\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e0d\u662f\u6570\u5b57";
            this.logger.warn(msg);
            return Response.failed((String)msg);
        }
        if (unitPrice != null && new BigDecimal(unitPrice).compareTo(zero) <= 0) {
            String msg = "\u4fee\u6539\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u662f\u6b63\u6570";
            this.logger.warn(msg);
            return Response.failed((String)msg);
        }
        if (unitPriceWithTax != null && !CommonTools.isNum(unitPriceWithTax).booleanValue()) {
            String msg = "\u4fee\u6539\u7684\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e0d\u662f\u6570\u5b57";
            this.logger.warn(msg);
            return Response.failed((String)msg);
        }
        if (unitPriceWithTax != null && new BigDecimal(unitPriceWithTax).compareTo(zero) <= 0) {
            String msg = "\u4fee\u6539\u7684\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u662f\u6b63\u6570";
            this.logger.warn(msg);
            return Response.failed((String)msg);
        }
        if (quantity != null && !CommonTools.isNum(quantity).booleanValue()) {
            String msg = "\u4fee\u6539\u7684\u6570\u91cf\u4e0d\u80fd\u4e0d\u662f\u6570\u5b57";
            this.logger.warn(msg);
            return Response.failed((String)msg);
        }
        if (quantity != null && new BigDecimal(quantity).compareTo(zero) <= 0 && blueFlag) {
            String msg = "\u4fee\u6539\u7684\u6570\u91cf\u5fc5\u987b\u662f\u6b63\u6570";
            this.logger.warn(msg);
            return Response.failed((String)msg);
        }
        if (!blueFlag && quantity != null && new BigDecimal(quantity).compareTo(zero) > 0) {
            String msg = "\u7ea2\u5b57\u5355\u636e,\u4fee\u6539\u7684\u6570\u91cf\u5fc5\u987b\u662f\u8d1f\u6570 ";
            this.logger.warn(msg);
            return Response.failed((String)msg);
        }
        if (checkBillDetailSet.contains("unitPrice")) {
            checkBillDetailSet.remove("quantity");
            checkBillDetailSet.remove("unitPriceWithTax");
            updateDetailItems.setQuantity(null);
            updateDetailItems.setUnitPriceWithTax(null);
        } else if (checkBillDetailSet.contains("unitPriceWithTax")) {
            checkBillDetailSet.remove("quantity");
            updateDetailItems.setQuantity(null);
        }
        BeanUtils.copyProperties(updateDetailItems, (Object)billItemEntity);
        if (!checkBillDetailSet.contains("unitPrice") && !checkBillDetailSet.contains("unitPriceWithTax") && checkBillDetailSet.contains("quantity")) {
            BigDecimal decimalQuantity = new BigDecimal(quantity);
            if (quantity.length() > 6) {
                decimalQuantity = decimalQuantity.setScale(6, 4);
            }
            BigDecimal price = originAmountWithoutTax.divide(decimalQuantity, 15, 4);
            String unitPriceStr = price.toPlainString();
            count = unitPriceStr.length() - (unitPriceStr.indexOf(".") + 1);
            for (int i = 1; i < count; ++i) {
                String checkUnitPrice = unitPriceStr.substring(0, unitPriceStr.length() - i);
                BigDecimal newUnitPrice = new BigDecimal(checkUnitPrice);
                BigDecimal newAmount2 = decimalQuantity.multiply(newUnitPrice).setScale(2, 4);
                if (originAmountWithoutTax.compareTo(newAmount2) != 0) continue;
                billItemEntity.setUnitPrice(newUnitPrice);
                break;
            }
            BigDecimal unitriceWithTax = originAmountWithTax.divide(decimalQuantity, 15, 4);
            String unitPriceWithTaxStr = unitriceWithTax.toPlainString();
            int tempCount = unitPriceWithTaxStr.length() - (unitPriceWithTaxStr.indexOf(".") + 1);
            for (int i = 1; i < tempCount; ++i) {
                String checkUnitPriceWithTax = unitPriceWithTaxStr.substring(0, unitPriceWithTaxStr.length() - i);
                BigDecimal newUnitPriceWithTax = new BigDecimal(checkUnitPriceWithTax);
                BigDecimal newAmount3 = decimalQuantity.multiply(newUnitPriceWithTax).setScale(2, 4);
                if (originAmountWithTax.compareTo(newAmount3) != 0) continue;
                billItemEntity.setUnitPriceWithTax(newUnitPriceWithTax);
                break;
            }
        }
        if (checkBillDetailSet.contains("unitPrice") && !checkBillDetailSet.contains("quantity") && !checkBillDetailSet.contains("unitPriceWithTax")) {
            if (CommonTools.isEmpty(unitPrice)) {
                return Response.ok((String)"\u8865\u5168\u7684\u5546\u54c1,\u4ef7\u683c\u4e0d\u8ba1\u7b97\uff01");
            }
            decimalPrice = new BigDecimal(unitPrice);
            if (unitPrice.length() > 15) {
                decimalPrice = decimalPrice.setScale(15, 4);
            }
            tempQuantity = originAmountWithoutTax.divide(decimalPrice, 6, 4);
            tempQuantityStr = tempQuantity.toPlainString();
            count = tempQuantityStr.length() - (tempQuantityStr.indexOf(".") + 1);
            newQuantity = BigDecimal.ONE;
            for (int i = 1; i < count; ++i) {
                String checkQuantity = tempQuantityStr.substring(0, tempQuantityStr.length() - i);
                newQuantity = new BigDecimal(checkQuantity);
                BigDecimal newAmount4 = newQuantity.multiply(decimalPrice).setScale(2, 4);
                if (originAmountWithoutTax.compareTo(newAmount4) != 0) continue;
                billItemEntity.setQuantity(newQuantity);
                break;
            }
            BigDecimal unitriceWithTax = originAmountWithTax.divide(newQuantity, 15, 4);
            String unitPriceWithTaxStr = unitriceWithTax.toPlainString();
            int tempCount = unitPriceWithTaxStr.length() - (unitPriceWithTaxStr.indexOf(".") + 1);
            for (int i = 1; i < tempCount; ++i) {
                String checkUnitPriceWithTax = unitPriceWithTaxStr.substring(0, unitPriceWithTaxStr.length() - i);
                BigDecimal newUnitPriceWithTax = new BigDecimal(checkUnitPriceWithTax);
                newAmount = newQuantity.multiply(newUnitPriceWithTax).setScale(2, 4);
                if (originAmountWithTax.compareTo(newAmount) != 0) continue;
                billItemEntity.setUnitPriceWithTax(newUnitPriceWithTax);
                break;
            }
        }
        if (!checkBillDetailSet.contains("unitPrice") && !checkBillDetailSet.contains("quantity") && checkBillDetailSet.contains("unitPriceWithTax")) {
            decimalPrice = new BigDecimal(unitPriceWithTax);
            if (unitPriceWithTax.length() > 15) {
                decimalPrice = decimalPrice.setScale(15, 4);
            }
            tempQuantity = originAmountWithTax.divide(decimalPrice, 6, 4);
            tempQuantityStr = tempQuantity.toPlainString();
            count = tempQuantityStr.length() - (tempQuantityStr.indexOf(".") + 1);
            newQuantity = BigDecimal.ONE;
            for (int i = 1; i < count; ++i) {
                String checkQuantity = tempQuantityStr.substring(0, tempQuantityStr.length() - i);
                newQuantity = new BigDecimal(checkQuantity);
                BigDecimal newAmount5 = newQuantity.multiply(decimalPrice).setScale(2, 4);
                if (originAmountWithTax.compareTo(newAmount5) != 0) continue;
                billItemEntity.setQuantity(newQuantity);
                break;
            }
            BigDecimal unitriceWithTax = originAmountWithoutTax.divide(newQuantity, 15, 4);
            String unitPriceStr = unitriceWithTax.toPlainString();
            int tempCount = unitPriceStr.length() - (unitPriceStr.indexOf(".") + 1);
            for (int i = 1; i < tempCount; ++i) {
                String checkUnitPrice = unitPriceStr.substring(0, unitPriceStr.length() - i);
                BigDecimal newUnitPrice = new BigDecimal(checkUnitPrice);
                newAmount = newQuantity.multiply(newUnitPrice).setScale(2, 4);
                if (originAmountWithoutTax.compareTo(newAmount) != 0) continue;
                billItemEntity.setUnitPrice(newUnitPrice);
                break;
            }
        }
        return Response.ok((String)"\u8865\u6570\u636e\u6210\u529f");
    }

    private Response checkTaxRate(List<OrdSalesbillDetailVO> ordSalesbillDetailVOList, BillItem updateDetailItems) {
        HashSet taxRateSet = new HashSet();
        boolean flag = ordSalesbillDetailVOList.size() == 1;
        ordSalesbillDetailVOList.stream().forEach(item -> {
            OrdSalesbillItemVO ordSalesbillItemVO = item.getOrdSalesbillItemVO();
            if (ordSalesbillItemVO != null) {
                OrdSalesbillItemVO itemVO;
                taxRateSet.add(ordSalesbillItemVO.getTaxRate());
                if (flag && (itemVO = ((OrdSalesbillDetailVO)ordSalesbillDetailVOList.get(0)).getOrdSalesbillItemVO()).getGoodsTaxNo() != null && itemVO.getGoodsTaxNo().equals(updateDetailItems.getGoodsTaxNo())) {
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getItemCode())) {
                        updateDetailItems.setItemCode(null);
                    }
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getItemName())) {
                        updateDetailItems.setItemName(null);
                    }
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getItemSpec())) {
                        updateDetailItems.setItemSpec(null);
                    }
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getQuantityUnit())) {
                        updateDetailItems.setQuantityUnit(null);
                    }
                    if (updateDetailItems.getUnitPrice() != null && ordSalesbillItemVO.getUnitPrice() != null && ordSalesbillItemVO.getUnitPrice().doubleValue() != 0.0) {
                        updateDetailItems.setUnitPrice(null);
                    }
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getGoodsTaxNo())) {
                        updateDetailItems.setGoodsTaxNo(null);
                    }
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getTaxPre())) {
                        updateDetailItems.setTaxPre(null);
                    }
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getTaxPreCon())) {
                        updateDetailItems.setTaxPreCon(null);
                    }
                    if (!CommonTools.isEmpty(ordSalesbillItemVO.getZeroTax())) {
                        updateDetailItems.setZeroTax(null);
                    }
                }
            }
        });
        if (taxRateSet.size() > 1) {
            return Response.failed((String)"\u6279\u91cf\u4fee\u6539\u660e\u7ec6,\u4fee\u6539\u7684\u5546\u54c1\u5bf9\u5e94\u7684\u7a0e\u7387\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        OrdSalesbillDetailVO ordSalesbillDetailVO = ordSalesbillDetailVOList.get(0);
        BigDecimal taxRate = ordSalesbillDetailVO.getOrdSalesbillItemVO().getTaxRate();
        if (!CommonTools.isNum(updateDetailItems.getTaxRate()).booleanValue()) {
            return Response.failed((String)"\u4fee\u6539\u7684\u5546\u54c1\u7ef4\u62a4\u7684\u7a0e\u7387\u4e0d\u662f\u6570\u503c");
        }
        BigDecimal updateTaxRate = new BigDecimal(updateDetailItems.getTaxRate());
        if (updateTaxRate.compareTo(taxRate) != 0) {
            return Response.failed((String)"\u4fee\u6539\u7684\u5546\u54c1\u7a0e\u7387\u4e0e\u539f\u7a0e\u7387\u4e0d\u4e00\u81f4,\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        return Response.ok((String)"\u7a0e\u7387\u6821\u9a8c\u901a\u8fc7");
    }

    private Response checkBillMainBeforeUpdate(Set billcheckSet, Set billDetailCheckSet, BillItemUpdateModel billItemUpdateModel, OrdSalesbillDetailVO ordSalesbillDetailVO) {
        OrdSalesbillVO ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO();
        String salesbillType = ordSalesbillVO.getSalesbillType();
        Long grouId = ordSalesbillVO.getSellerGroupId();
        BillMain updateBillItems = billItemUpdateModel.getUpdateBillItems();
        BillItem updateDetailItems = billItemUpdateModel.getUpdateDetailItems();
        Map map = this.localConfigMetadataCacheManager.queryEffctiveMetaData(grouId, ObjCodeEnum.BILL.getObjCode(), salesbillType);
        if (map == null) {
            return Response.failed((String)"\u83b7\u53d6\u5143\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        Response response = this.checkByMetadataConfig(updateBillItems, billcheckSet, ObjCodeEnum.BILL.getObjCode(), map);
        if (response.getCode() == 1) {
            response = this.checkByMetadataConfig(updateDetailItems, billDetailCheckSet, ObjCodeEnum.BILL_ITEM.getObjCode(), map);
        }
        return response;
    }

    Response checkByMetadataConfig(Object obj, Set<String> set, String objCode, Map<String, MsBusinessObjMetadataBean> map) {
        if (set.isEmpty()) {
            return Response.ok((String)"\u6821\u9a8c\u901a\u8fc7");
        }
        BeanMap beanMap = BeanMap.create((Object)obj);
        for (String field : set) {
            if ("goodsNoVer".equals(field)) continue;
            String key = "";
            key = ObjCodeEnum.BILL.getObjCode().equals(objCode) ? field + "#0" : field + "#1";
            MsBusinessObjMetadataBean matabean = map.get(key);
            if (matabean == null) {
                return Response.failed((String)CommonTools.format("\u4fee\u6539\u5931\u8d25\uff0c{}\u6ca1\u6709\u83b7\u53d6\u5230\u914d\u7f6e", field));
            }
            if (matabean.getFieldReadonly() == 1 && ObjCodeEnum.BILL.getObjCode().equals(objCode)) {
                return Response.failed((String)CommonTools.format("\u4fee\u6539\u5931\u8d25\uff0c{}\u914d\u7f6e\u4e3a\u4e0d\u53ef\u4fee\u6539", matabean.getFieldDisplayName()));
            }
            String value = String.valueOf(beanMap.get((Object)field));
            try {
                int newLength = value.getBytes("GBK").length;
                if (CommonTools.isEmpty(value) || !CommonTools.exceedMaxLength(value, matabean.getFieldLength())) continue;
                return Response.failed((String)CommonTools.format("\u4fee\u6539\u5931\u8d25\uff0c{}\u957f\u5ea6\u6821\u9a8c\u5931\u8d25\uff0c\u5f53\u524d\u957f\u5ea6\u4e3a:{}", matabean.getFieldDisplayName(), newLength));
            }
            catch (Exception e) {
                return Response.failed((String)"\u6821\u9a8c\u957f\u5ea6\u51fa\u73b0\u5f02\u5e38\uff01");
            }
        }
        return Response.ok((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    private void insertHistorylogs(BillItemUpdateModel billItemUpdateModel, List<OrdSalesbillDetailVO> ordSalesbillDetailVOList, ArrayList<OrdSalesbillItemEntity> billItemEntities, UserInfo userInfo) {
        BillMain updateBillItems = billItemUpdateModel.getUpdateBillItems();
        BillItem updateDetailItems = billItemUpdateModel.getUpdateDetailItems();
        Set<String> checkBillSet = ReflectUtil.getNotBlankFiledsInfo(updateBillItems);
        Set<String> checkBillDetailSet = ReflectUtil.getNotBlankFiledsInfo(updateDetailItems);
        BeanMap billMainBeanMap = null;
        BeanMap billDetailBeanMap = null;
        HashMap<Long, OrdSalesbillItemEntity> realUpdateVoMap = new HashMap<Long, OrdSalesbillItemEntity>();
        if (checkBillSet.size() > 0) {
            billMainBeanMap = BeanMap.create((Object)updateBillItems);
        }
        if (checkBillDetailSet.size() > 0) {
            billDetailBeanMap = BeanMap.create((Object)updateDetailItems);
            billItemEntities.stream().forEach(item -> realUpdateVoMap.put(item.getSalesbillItemId(), (OrdSalesbillItemEntity)((Object)item)));
        }
        Map metaDataMap = this.localConfigMetadataCacheManager.queryEffctiveMetaData(userInfo.getGroupId(), ObjCodeEnum.BILL.getObjCode(), "");
        HashMap<Long, SplitAndMergeHistoryOperationBean> billHistotyMap = new HashMap<Long, SplitAndMergeHistoryOperationBean>();
        int size = ordSalesbillDetailVOList.size();
        for (int i = 0; i < size; ++i) {
            List<BillUpdateOperationBean> billUpdateList;
            OrdSalesbillDetailVO ordSalesbillDetailVO = ordSalesbillDetailVOList.get(i);
            OrdSalesbillItemVO ordSalesbillItemVO = ordSalesbillDetailVO.getOrdSalesbillItemVO();
            OrdSalesbillVO ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO();
            OrdSalesbillEntity ordSalesbillEntity = new OrdSalesbillEntity();
            ordSalesbillEntity.setSalesbillId(ordSalesbillVO.getSalesbillId());
            ordSalesbillEntity.setCustomerNo(ordSalesbillVO.getCustomerNo() == null ? "" : ordSalesbillVO.getCustomerNo());
            if (checkBillSet != null && !checkBillSet.isEmpty() && !billHistotyMap.containsKey(ordSalesbillVO.getSalesbillId())) {
                SplitAndMergeHistoryOperationBean historyBean = new SplitAndMergeHistoryOperationBean();
                historyBean.setUserId(userInfo.getUserId());
                historyBean.setBillItemOperation(BillOperationType.UPDATE);
                billUpdateList = this.getBillUpdateList(ordSalesbillVO, checkBillSet, (Map)billMainBeanMap, metaDataMap);
                historyBean.setBillTarge(ordSalesbillEntity);
                historyBean.setBillUpdateList(billUpdateList);
                billHistotyMap.put(ordSalesbillVO.getSalesbillId(), historyBean);
            }
            if (checkBillDetailSet == null || checkBillDetailSet.isEmpty()) continue;
            SplitAndMergeHistoryOperationBean history = (SplitAndMergeHistoryOperationBean)billHistotyMap.get(ordSalesbillItemVO.getSalesbillId());
            if (history == null) {
                history = new SplitAndMergeHistoryOperationBean();
                history.setUserId(userInfo.getUserId());
                history.setBillItemOperation(BillOperationType.UPDATE);
                history.setBillTarge(ordSalesbillEntity);
                billUpdateList = this.getBillUpdateList(ordSalesbillVO, checkBillSet, (Map)billMainBeanMap, metaDataMap);
                history.setBillUpdateList(billUpdateList);
            }
            List<BillUpdateOperationBean> billItemUpdateList = this.getBillDetailUpdateList(ordSalesbillItemVO, realUpdateVoMap, (Map)billDetailBeanMap, metaDataMap);
            List<BillUpdateOperationBean> originUpdateList = history.getBillItemUpdateList();
            if (originUpdateList != null) {
                originUpdateList.addAll(billItemUpdateList);
                history.setBillItemUpdateList(originUpdateList);
            } else {
                history.setBillItemUpdateList(billItemUpdateList);
            }
            billHistotyMap.put(ordSalesbillVO.getSalesbillId(), history);
        }
        for (Map.Entry entry : billHistotyMap.entrySet()) {
            SplitAndMergeHistoryOperationBean hisroty = (SplitAndMergeHistoryOperationBean)entry.getValue();
            this.splitMergeHistoryComponent.billHitoryOper(hisroty);
        }
    }

    private List<BillUpdateOperationBean> getBillUpdateList(OrdSalesbillVO ordSalesbillVO, Set<String> checkBillSet, Map billMainBeanMap, Map<String, MsBusinessObjMetadataBean> displayMap) {
        LinkedList<BillUpdateOperationBean> list = new LinkedList<BillUpdateOperationBean>();
        BeanMap originBeanMap = BeanMap.create((Object)ordSalesbillVO);
        for (String field : checkBillSet) {
            String newValue = String.valueOf(billMainBeanMap.get(field));
            String oldValue = String.valueOf(originBeanMap.get((Object)field));
            MsBusinessObjMetadataBean metadataBean = displayMap.get(field + "#0");
            String dispayName = String.valueOf(metadataBean != null ? metadataBean.getFieldDisplayName() : "\u672a\u77e5\u5b57\u6bb5");
            BillUpdateOperationBean billUpdateOperationBean = new BillUpdateOperationBean();
            billUpdateOperationBean.setOldValue(oldValue);
            billUpdateOperationBean.setNewValue(newValue);
            billUpdateOperationBean.setFieldName(field);
            billUpdateOperationBean.setFieldCname(dispayName);
            billUpdateOperationBean.setId(ordSalesbillVO.getSalesbillId());
            billUpdateOperationBean.setBillHistoryTargetType(BillHistoryTargetType.BILL);
            billUpdateOperationBean.setBillHistoryOperation(BillHistoryActionType.UPDATE);
            list.add(billUpdateOperationBean);
        }
        return list;
    }

    private List<BillUpdateOperationBean> getBillDetailUpdateList(OrdSalesbillItemVO ordSalesbillItemVO, HashMap<Long, OrdSalesbillItemEntity> realUpdateVoMap, Map billDetailBeanMap, Map<String, MsBusinessObjMetadataBean> displayMap) {
        LinkedList<BillUpdateOperationBean> list = new LinkedList<BillUpdateOperationBean>();
        BeanMap originBeanMap = BeanMap.create((Object)ordSalesbillItemVO);
        OrdSalesbillItemEntity ordSalesbillItemEntity = realUpdateVoMap.get(ordSalesbillItemVO.getSalesbillItemId());
        ordSalesbillItemEntity.setSalesbillItemId(null);
        Set<String> billDetailSet = ReflectUtil.getNotBlankFiledsInfo((Object)ordSalesbillItemEntity);
        BeanMap newBeanMap = BeanMap.create((Object)((Object)ordSalesbillItemEntity));
        for (String field : billDetailSet) {
            MsBusinessObjMetadataBean metadataBean;
            String newValue = "";
            String oldValue = "";
            if (originBeanMap.get((Object)field) instanceof BigDecimal) {
                BigDecimal temp;
                if (newBeanMap.get((Object)field) != null) {
                    temp = new BigDecimal(String.valueOf(newBeanMap.get((Object)field)));
                    newValue = this.decimalFormat(temp, field);
                }
                if (originBeanMap.get((Object)field) != null) {
                    temp = new BigDecimal(String.valueOf(originBeanMap.get((Object)field)));
                    oldValue = this.decimalFormat(temp, field);
                }
            } else {
                newValue = String.valueOf(newBeanMap.get((Object)field));
                oldValue = String.valueOf(originBeanMap.get((Object)field));
            }
            String dispayName = String.valueOf((metadataBean = displayMap.get(field + "#1")) != null ? metadataBean.getFieldDisplayName() : "\u672a\u77e5\u5b57\u6bb5");
            BillUpdateOperationBean billUpdateOperationBean = new BillUpdateOperationBean();
            billUpdateOperationBean.setOldValue(oldValue);
            billUpdateOperationBean.setNewValue(newValue);
            billUpdateOperationBean.setFieldName(field);
            billUpdateOperationBean.setFieldCname(dispayName);
            billUpdateOperationBean.setGoodsName(ordSalesbillItemVO.getItemName());
            billUpdateOperationBean.setId(ordSalesbillItemVO.getSalesbillItemId());
            billUpdateOperationBean.setBillHistoryTargetType(BillHistoryTargetType.BILL_ITEM);
            billUpdateOperationBean.setBillHistoryOperation(BillHistoryActionType.UPDATE);
            list.add(billUpdateOperationBean);
        }
        String[] emptryList = new String[]{"taxConvertCode", "itemSpec", "quantityUnit"};
        if ("".equals(ordSalesbillItemEntity.getTaxConvertCode()) || "".equals(ordSalesbillItemEntity.getItemSpec()) || "".equals(ordSalesbillItemEntity.getQuantityUnit())) {
            for (int i = 0; i < emptryList.length; ++i) {
                String field = emptryList[i];
                String value = String.valueOf(newBeanMap.get((Object)field));
                if (!"".equals(value)) continue;
                String oldValue = String.valueOf(originBeanMap.get((Object)field));
                MsBusinessObjMetadataBean metadataBean = displayMap.get(field + "#1");
                String dispayName = String.valueOf(metadataBean != null ? metadataBean.getFieldDisplayName() : "\u672a\u77e5\u5b57\u6bb5");
                BillUpdateOperationBean billUpdateOperationBean = new BillUpdateOperationBean();
                billUpdateOperationBean.setOldValue(oldValue);
                billUpdateOperationBean.setNewValue("");
                billUpdateOperationBean.setFieldName(field);
                billUpdateOperationBean.setFieldCname(dispayName);
                billUpdateOperationBean.setGoodsName(ordSalesbillItemVO.getItemName());
                billUpdateOperationBean.setId(ordSalesbillItemVO.getSalesbillItemId());
                billUpdateOperationBean.setBillHistoryTargetType(BillHistoryTargetType.BILL_ITEM);
                billUpdateOperationBean.setBillHistoryOperation(BillHistoryActionType.UPDATE);
                list.add(billUpdateOperationBean);
            }
        }
        return list;
    }

    private String decimalFormat(BigDecimal decimal, String fieldName) {
        if (decimal == null) {
            return "";
        }
        if (BigDecimal.ZERO.compareTo(decimal) == 0) {
            return "0";
        }
        String result = "";
        if (fieldName.toLowerCase().contains("quantity")) {
            DecimalFormat decimalFormat = new DecimalFormat("###,###.0000000");
            result = decimalFormat.format(decimal);
        } else if (fieldName.toLowerCase().contains("price")) {
            DecimalFormat decimalFormat = new DecimalFormat("###,###.000000000000000");
            result = decimalFormat.format(decimal);
            result = CommonTools.removeLastZero(result);
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("###,###.00");
            result = decimalFormat.format(decimal);
        }
        return result;
    }

    private BillItemUpdateModel convertToRealGoods(BillItemUpdateModel billItemUpdateModel) {
        BillItem billItem = billItemUpdateModel.getUpdateDetailItems();
        String goodsId = billItem.getGoodsId();
        this.logger.debug("---\u8c03\u8bd5---goodsId:{}", (Object)goodsId);
        if (goodsId != null) {
            this.logger.debug("=======\u67e5\u8be2\u5546\u54c1\u4fe1\u606f========goodsId\uff1a\uff1a{}", (Object)goodsId);
            GoodsDetailReponse response = this.localTaxCodeCacheManager.getGoodsDetailById(goodsId);
            if (response.getCode() == 1) {
                GoodsModel goods = response.getResult().getGoods();
                billItem.setItemSpec(goods.getGoodsSpec());
                billItem.setItemName(goods.getGoodsName());
                billItem.setItemCode(goods.getGoodsCode());
                if (billItem.getUnitPrice() == null) {
                    billItem.setUnitPrice(goods.getUnitPrice());
                }
                String taxCodeId = billItem.getGoodsTaxcodeId();
                List taxCodeList = response.getResult().getTaxCodeList();
                for (int i = 0; i < taxCodeList.size(); ++i) {
                    TaxConvertCodeModel taxConvertCodeModel = (TaxConvertCodeModel)taxCodeList.get(i);
                    if (!taxCodeId.equals(taxConvertCodeModel.getGoodsTaxcodeId())) continue;
                    billItem.setTaxPre(taxConvertCodeModel.getTaxPre());
                    billItem.setTaxPreCon(taxConvertCodeModel.getTaxPreCon());
                    billItem.setZeroTax(taxConvertCodeModel.getZeroTax());
                    billItem.setGoodsTaxNo(taxConvertCodeModel.getGoodsTaxNo());
                    billItem.setTaxRate(taxConvertCodeModel.getTaxRate());
                }
            }
            billItem.setGoodsTaxcodeId(null);
            billItem.setGoodsId(null);
        }
        return billItemUpdateModel;
    }
}

