/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.confirm.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.cache.ucenter.LocalUcenterExternalCacheManager;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.BillResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillCatalog;
import com.xforceplus.phoenix.bill.core.service.BillQueryService;
import com.xforceplus.phoenix.bill.core.tools.BillSearchTools;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.CooperationUtils;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillConfirmTools {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Integer maxConfirmCounts = 2000;
    private final Integer maxPageSize = 2000;
    @Autowired
    private CooperationUtils cooperationUtils;
    @Autowired
    private BillQueryService billQueryService;
    @Autowired
    private LocalUcenterExternalCacheManager ucenterExternalCacheManager;

    public Response preRejectAndConfirmByCondition(BillRequest billRequest, String role, BillOperationType type) {
        this.logger.info("===============================\u8fdb\u5165preRejectAndConfirmByCondition\u65b9\u6cd5=============================");
        Integer total = billRequest.getTotal();
        if (total != null && total > this.maxConfirmCounts) {
            return Response.from((Integer)Response.Fail, (String)("\u4e00\u6b21\u64cd\u4f5c\u4e0d\u80fd\u8d85\u8fc7" + this.maxConfirmCounts + "\u6761\u6570\u636e"));
        }
        BillSearchModel searchModel = BillSearchTools.getSearchCondition(billRequest, role);
        if (searchModel == null) {
            return Response.from((Integer)Response.Fail, (String)"\u67e5\u8be2\u6761\u4ef6\u975e\u6cd5\uff0c\u672a\u4f20conditions");
        }
        UserSessionInfo userInfo = billRequest.getUserInfo();
        if (userInfo == null) {
            return Response.from((Integer)Response.Fail, (String)"\u5f53\u524d\u7528\u6237\u672a\u767b\u9646");
        }
        List<OrgModel> orgModelList = this.ucenterExternalCacheManager.getOrgList(userInfo.getGroupId(), userInfo.getSysUserId());
        searchModel.setCompanyIdList(orgModelList.stream().filter(e -> !Objects.equals(0, e.getOrgType())).map(OrgModel::getCompanyId).collect(Collectors.toList()));
        searchModel.setSysOrgIdList(orgModelList.stream().map(orgModel -> String.valueOf(orgModel.getOrgStructId())).collect(Collectors.toList()));
        searchModel.setPageNo(Integer.valueOf(1));
        searchModel.setPageSize(this.maxPageSize);
        int pages = total / this.maxPageSize + 1;
        ArrayList successEntities = Lists.newArrayList();
        for (int i = 0; i < pages; ++i) {
            BillResponse queryServiceBillList = this.billQueryService.getBillList(searchModel);
            if (queryServiceBillList.getResult() == null) {
                this.logger.info("================\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u67e5\u8be2\u6761\u4ef6-{}========================", (Object)searchModel);
                continue;
            }
            List salesbillVOS = queryServiceBillList.getResult().getList();
            if (CommonTools.isEmpty(salesbillVOS)) {
                this.logger.info("================\u67e5\u8be2\u7684\u5217\u8868BillResponse-{}========================", (Object)queryServiceBillList.getResult());
                continue;
            }
            List<OrdSalesbillEntity> entities = BillSearchTools.convertVosToEntites(salesbillVOS);
            Response response = BillOperationType.CONFIRM.equals((Object)type) ? this.preConfirmBill(entities, role) : this.preRejectBill(entities, role);
            Map map = (Map)response.getResult();
            List ordSalesbillEntities = (List)map.get("successSalesBill");
            successEntities.addAll(ordSalesbillEntities);
            searchModel.setPageNo(Integer.valueOf(searchModel.getPageNo() + 1));
        }
        HashMap map = Maps.newHashMap();
        map.put("success", successEntities.size());
        map.put("fail", total - successEntities.size());
        map.put("successSalesBill", successEntities);
        if (CommonTools.isEmpty(successEntities)) {
            return Response.from((Integer)Response.Fail, (String)("\u6821\u9a8c\u4e0d\u901a\u8fc7" + total + "\u6761"), (Object)map);
        }
        return Response.from((Integer)Response.OK, (String)("\u6821\u9a8c\u901a\u8fc7" + successEntities.size() + "\u6761\uff0c\u4e0d\u901a\u8fc7" + (total - successEntities.size()) + "\u6761"), (Object)map);
    }

    public Response preConfirmBill(List<OrdSalesbillEntity> ordSalesbillEntities, String role) {
        this.logger.info("===============================\u8fdb\u5165preConfirmBill\u65b9\u6cd5=============================");
        ArrayList successBills = Lists.newArrayList();
        for (int i = 0; i < ordSalesbillEntities.size(); ++i) {
            OrdSalesbillEntity ordSalesbillEntity = ordSalesbillEntities.get(i);
            String businessBillType = ordSalesbillEntity.getBusinessBillType();
            if (role.equals(businessBillType)) {
                if (!SalesBillCatalog.CONFIRMING.value().equals(ordSalesbillEntity.getUploadConfirmFlag()) && !SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                    this.logger.info("\u4e1a\u52a1\u5355" + ordSalesbillEntity.getSalesbillNo() + "\u72b6\u6001\u5df2\u53d8\u66f4,\u4e0d\u53ef\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c!");
                    continue;
                }
            } else if (!SalesBillCatalog.CONFIRMING.value().equals(ordSalesbillEntity.getReceiveConfirmFlag()) && !SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getReceiveConfirmFlag())) {
                this.logger.info("\u4e1a\u52a1\u5355" + ordSalesbillEntity.getSalesbillNo() + "\u72b6\u6001\u5df2\u53d8\u66f4,\u4e0d\u53ef\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c!");
                continue;
            }
            successBills.add(ordSalesbillEntity);
        }
        HashMap map = Maps.newHashMap();
        map.put("success", successBills.size());
        map.put("fail", ordSalesbillEntities.size() - successBills.size());
        map.put("successSalesBill", successBills);
        if (CommonTools.isEmpty(successBills)) {
            return Response.from((Integer)Response.Fail, (String)("\u6821\u9a8c\u4e0d\u901a\u8fc7" + ordSalesbillEntities.size() + "\u6761"), (Object)map);
        }
        return Response.from((Integer)Response.OK, (String)("\u6821\u9a8c\u901a\u8fc7" + successBills.size() + "\u6761\uff0c\u4e0d\u901a\u8fc7" + (ordSalesbillEntities.size() - successBills.size()) + "\u6761"), (Object)map);
    }

    public Response confirmBill(List<OrdSalesbillEntity> ordSalesbillEntities, String role) {
        return this.cooperationUtils.handlAutoFlag(ordSalesbillEntities, role, BillOperationType.CONFIRM, "");
    }

    public Response preRejectBill(List<OrdSalesbillEntity> ordSalesbillEntities, String role) {
        this.logger.info("===============================\u8fdb\u5165preRejectBill\u65b9\u6cd5=============================");
        ArrayList successBills = Lists.newArrayList();
        for (int i = 0; i < ordSalesbillEntities.size(); ++i) {
            OrdSalesbillEntity ordSalesbillEntity = ordSalesbillEntities.get(i);
            String businessBillType = ordSalesbillEntity.getBusinessBillType();
            if (role.equals(businessBillType)) {
                if (!SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                    this.logger.info("\u9a73\u56de\u64cd\u4f5c\u53ea\u80fd\u662f\u6709\u53d8\u66f4\u7684\u4e1a\u52a1\u5355");
                    continue;
                }
            } else if (!SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getReceiveConfirmFlag())) {
                this.logger.info("\u9a73\u56de\u64cd\u4f5c\u53ea\u80fd\u662f\u6709\u53d8\u66f4\u7684\u4e1a\u52a1\u5355");
                continue;
            }
            successBills.add(ordSalesbillEntity);
        }
        HashMap map = Maps.newHashMap();
        map.put("success", successBills.size());
        map.put("fail", ordSalesbillEntities.size() - successBills.size());
        map.put("successSalesBill", successBills);
        if (CommonTools.isEmpty(successBills)) {
            return Response.from((Integer)Response.Fail, (String)"\u5168\u90e8\u6821\u9a8c\u4e0d\u901a\u8fc7", (Object)map);
        }
        return Response.from((Integer)Response.OK, (String)"\u6821\u9a8c\u901a\u8fc7", (Object)map);
    }

    public Response rejectBill(List<OrdSalesbillEntity> ordSalesbillEntities, String role, String desc) {
        return this.cooperationUtils.handlAutoFlag(ordSalesbillEntities, role, BillOperationType.REJECT, desc);
    }
}

