/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.discount;

import com.baidu.unbiz.fluentvalidator.FluentValidator;
import com.baidu.unbiz.fluentvalidator.Result;
import com.baidu.unbiz.fluentvalidator.ResultCollectors;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.xforceplus.phoenix.bill.constant.enums.DiscountType;
import com.xforceplus.phoenix.bill.core.impl.discount.domain.DiscountRequest;
import com.xforceplus.phoenix.bill.core.impl.discount.tools.DiscountTools;
import com.xforceplus.phoenix.bill.core.service.BillDiscountService;
import com.xforceplus.phoenix.bill.core.validator.discount.BillItemDiscountValidator;
import com.xforceplus.phoenix.bill.core.validator.discount.BillMainDiscountValidator;
import com.xforceplus.phoenix.bill.exception.DiscountHandleException;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillDiscountServiceImpl
implements BillDiscountService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BillMainDiscountValidator mainDiscountValidator;
    @Autowired
    private BillItemDiscountValidator itemDiscountValidator;
    @Autowired
    private DiscountTools discountTools;

    @Override
    public DiscountRequest splitDiscount(List<OrdSalesbillInterfaceItemEntity> productItems, OrdSalesbillInterfaceEntity discountMain) {
        DiscountType discountType;
        this.logger.info("========================\u5f00\u59cb\u5206\u644a\u6298\u6263splitDiscount,salesbillNo-{}================================", (Object)discountMain.getSalesbillNo());
        Result result = (Result)FluentValidator.checkAll().on((Object)discountMain, (Validator)this.mainDiscountValidator).on(productItems, (Validator)this.itemDiscountValidator).doValidate().result(ResultCollectors.toSimple());
        if (!result.isSuccess()) {
            throw new DiscountHandleException(result.getErrors().toString());
        }
        this.logger.info("=============\u5206\u644a\u6298\u6263=======================================");
        if (this.hasValue(discountMain.getOutterDiscountWithoutTax())) {
            discountType = this.fillValue(DiscountType.outter_discount_without_tax, discountMain.getOutterDiscountWithoutTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        if (this.hasValue(discountMain.getOutterDiscountWithTax())) {
            discountType = this.fillValue(DiscountType.outter_discount_with_tax, discountMain.getOutterDiscountWithTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        if (this.hasValue(discountMain.getInnerDiscountWithoutTax())) {
            discountType = this.fillValue(DiscountType.inner_discount_without_tax, discountMain.getInnerDiscountWithoutTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        if (this.hasValue(discountMain.getInnerDiscountWithTax())) {
            discountType = this.fillValue(DiscountType.inner_discount_with_tax, discountMain.getInnerDiscountWithTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        if (this.hasValue(discountMain.getInnerPrepayAmountWithTax())) {
            discountType = this.fillValue(DiscountType.inner_prepay_amount_with_tax, discountMain.getInnerPrepayAmountWithTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        if (this.hasValue(discountMain.getInnerPrepayAmountWithoutTax())) {
            discountType = this.fillValue(DiscountType.inner_prepay_amount_without_tax, discountMain.getInnerPrepayAmountWithoutTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        if (this.hasValue(discountMain.getOutterPrepayAmountWithTax())) {
            discountType = this.fillValue(DiscountType.outter_prepay_amount_with_tax, discountMain.getOutterPrepayAmountWithTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        if (this.hasValue(discountMain.getOutterPrepayAmountWithoutTax())) {
            discountType = this.fillValue(DiscountType.outter_prepay_amount_without_tax, discountMain.getOutterPrepayAmountWithoutTax());
            this.discountTools.splitDiscountByType(productItems, discountType);
        }
        productItems.stream().forEach(item -> this.validateAmount((OrdSalesbillInterfaceItemEntity)((Object)item)));
        return new DiscountRequest(productItems, discountMain);
    }

    private void validateAmount(OrdSalesbillInterfaceItemEntity item) {
        BigDecimal actual = item.getAmountWithTax().subtract(item.getOutterPrepayAmountWithTax()).subtract(item.getInnerPrepayAmountWithTax()).subtract(item.getOutterDiscountWithTax()).subtract(item.getInnerDiscountWithTax());
        if (actual.compareTo(BigDecimal.ZERO) < 0) {
            throw new DiscountHandleException("\u5206\u644a\u6298\u6263\u540e\u5df2\u6210\u8d1f\u503c\uff01");
        }
    }

    private DiscountType fillValue(DiscountType type, BigDecimal value) {
        type = DiscountType.setValue(type, value);
        return type;
    }

    private boolean hasValue(BigDecimal amount) {
        return amount != null && amount.compareTo(BigDecimal.ZERO) != 0;
    }
}

