/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.upload.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.client.makeout.SplitAndMakeOutInvoiceClient;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.bill.client.model.PurchaseInfo;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceMakeOutMode;
import com.xforceplus.phoenix.bill.core.impl.domain.BatchMakePreviewInvoiceInfo;
import com.xforceplus.phoenix.bill.core.impl.domain.BatchNoMergeInfo;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillOperateDao;
import com.xforceplus.phoenix.bill.repository.model.OrdAutoSplitPreinvoiceInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.ExceptionUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.impl.InvoiceSplitParser;
import com.xforceplus.seller.invoice.client.model.MsSplitAndMakeOutParams;
import com.xforceplus.seller.invoice.client.model.MsSplitAndMakeOutRequest;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MakePreInvoiceTools {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IDGenerator idGenerator;
    private LocalConfigMetadataCacheManager localConfigMetadataCacheManager;
    private InvoiceSplitParser invoiceSplitParser;
    private SplitAndMakeOutInvoiceClient splitAndMakeOutInvoiceClient;
    private SalesBillOperateDao operateDao;
    private SalesBillBatchDao billBatchDao;

    @Autowired
    public MakePreInvoiceTools(IDGenerator idGenerator, LocalConfigMetadataCacheManager localConfigMetadataCacheManager, InvoiceSplitParser invoiceSplitParser, SplitAndMakeOutInvoiceClient splitAndMakeOutInvoiceClient, SalesBillOperateDao operateDao, SalesBillBatchDao billBatchDao) {
        this.idGenerator = idGenerator;
        this.localConfigMetadataCacheManager = localConfigMetadataCacheManager;
        this.invoiceSplitParser = invoiceSplitParser;
        this.splitAndMakeOutInvoiceClient = splitAndMakeOutInvoiceClient;
        this.operateDao = operateDao;
        this.billBatchDao = billBatchDao;
    }

    public void sendSplitPreInvoice(List<OrdSalesbillEntity> successMains, List<Long> salesBillIds) {
        ArrayList entities;
        block11: {
            OrdAutoSplitPreinvoiceInterfaceEntity entity;
            ArrayList paramList = Lists.newArrayList();
            ArrayList previewInvoiceInfos = Lists.newArrayList();
            entities = Lists.newArrayList();
            HashMap map = Maps.newHashMap();
            for (int i = 0; i < successMains.size(); ++i) {
                OrdSalesbillEntity ordSalesbillEntity = successMains.get(i);
                if (!salesBillIds.contains(ordSalesbillEntity.getSalesbillId())) continue;
                long batchNo = this.idGenerator.nextId();
                MsSplitAndMakeOutParams params = new MsSplitAndMakeOutParams();
                BeanUtils.copyProperties((Object)ordSalesbillEntity, params);
                params.setMode(String.valueOf(InvoiceMakeOutMode.PRE_MAKEOUT.value()));
                params.setBatchNo(Long.valueOf(batchNo));
                OrdSalesbillVO ordSalesbillVO = new OrdSalesbillVO();
                BeanUtils.copyProperties((Object)ordSalesbillEntity, ordSalesbillVO);
                BaseRuleBean baseRuleBean = null;
                try {
                    baseRuleBean = this.localConfigMetadataCacheManager.getInvoiceSplitRule(ordSalesbillVO, (ConfigParser)this.invoiceSplitParser);
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6\u62c6\u7968\u89c4\u5219\u5931\u8d25", (Throwable)e);
                }
                if (baseRuleBean == null) {
                    OrdAutoSplitPreinvoiceInterfaceEntity entity2 = new OrdAutoSplitPreinvoiceInterfaceEntity();
                    BeanUtils.copyProperties((Object)ordSalesbillEntity, (Object)entity2);
                    entity2.setId(ordSalesbillEntity.getSalesbillId());
                    entity2.setProcessRemark("\u6ca1\u6709\u62c6\u7968\u89c4\u5219");
                    entity2.setRuleId(baseRuleBean.getRuldId());
                    entities.add(entity2);
                    continue;
                }
                params.setRuleId(baseRuleBean.getRuldId());
                map.put(batchNo, ordSalesbillEntity.getSalesbillId());
                paramList.add(params);
                BatchMakePreviewInvoiceInfo previewInvoiceInfo = new BatchMakePreviewInvoiceInfo();
                BatchNoMergeInfo batchNoMergeInfo = new BatchNoMergeInfo();
                batchNoMergeInfo.setBatchNo(batchNo);
                batchNoMergeInfo.setMerge(false);
                previewInvoiceInfo.setBatchNoMergeInfo(batchNoMergeInfo);
                previewInvoiceInfo.setRuleId(baseRuleBean.getRuldId());
                previewInvoiceInfo.setSalesbillId(ordSalesbillEntity.getSalesbillId());
                PurchaseInfo purchaseInfo = new PurchaseInfo();
                BeanUtils.copyProperties((Object)ordSalesbillEntity, purchaseInfo);
                previewInvoiceInfo.setPurchaseInfo(purchaseInfo);
                previewInvoiceInfo.setStatus(BillItemStatus.PRE_INVOICED.value());
                previewInvoiceInfos.add(previewInvoiceInfo);
            }
            try {
                if (CommonTools.isEmpty(previewInvoiceInfos)) break block11;
                this.updateItemBatchNo(previewInvoiceInfos);
                ArrayList removeBatchNoInfos = Lists.newArrayList();
                for (int i = 0; i < paramList.size(); ++i) {
                    MsSplitAndMakeOutParams params = (MsSplitAndMakeOutParams)paramList.get(i);
                    Long id = (Long)map.get(params.getBatchNo());
                    MsSplitAndMakeOutRequest msSplitAndMakeOutRequest = new MsSplitAndMakeOutRequest();
                    msSplitAndMakeOutRequest.setParamList(Arrays.asList(params));
                    try {
                        BaseAsyncResponse baseAsyncResponse = this.splitAndMakeOutInvoiceClient.makeOut(msSplitAndMakeOutRequest);
                        if (BaseResponse.OK.equals(baseAsyncResponse.getCode())) continue;
                        entity = this.packAutoSplitPreInvoiceDomain(params, baseAsyncResponse.getMessage(), id);
                        entities.add(entity);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error("\u629b\u9001\u62c6\u7968\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
                        String stackTrace = ExceptionUtils.getStackTrace(e);
                        String lastCauseBy = ExceptionUtils.getExceptionCauseBy(stackTrace, 2000);
                        OrdAutoSplitPreinvoiceInterfaceEntity entity3 = this.packAutoSplitPreInvoiceDomain(params, lastCauseBy, id);
                        entities.add(entity3);
                        BatchMakePreviewInvoiceInfo info = new BatchMakePreviewInvoiceInfo();
                        BatchNoMergeInfo batchNoMergeInfo = new BatchNoMergeInfo();
                        batchNoMergeInfo.setBatchNo(0L);
                        batchNoMergeInfo.setMerge(false);
                        info.setBatchNoMergeInfo(batchNoMergeInfo);
                        info.setRuleId(0L);
                        info.setSalesbillId(id);
                        info.setStatus(BillItemStatus.NORMAL.value());
                        removeBatchNoInfos.add(info);
                    }
                }
                if (CommonTools.isEmpty(removeBatchNoInfos)) break block11;
                this.updateItemBatchNo(removeBatchNoInfos);
            }
            catch (Exception e) {
                this.logger.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                for (int i = 0; i < paramList.size(); ++i) {
                    MsSplitAndMakeOutParams params = (MsSplitAndMakeOutParams)paramList.get(i);
                    Long id = (Long)map.get(params.getBatchNo());
                    String stackTrace = ExceptionUtils.getStackTrace(e);
                    String lastCauseBy = ExceptionUtils.getExceptionCauseBy(stackTrace, 2000);
                    entity = this.packAutoSplitPreInvoiceDomain(params, lastCauseBy, id);
                    entities.add(entity);
                }
            }
        }
        if (!CommonTools.isEmpty(entities)) {
            this.billBatchDao.autoSplitInvoiceBatchInsert((BatchParameter<OrdAutoSplitPreinvoiceInterfaceEntity>)BatchParameter.wrap((List)entities));
        }
    }

    @Transactional
    public void updateItemBatchNo(List<BatchMakePreviewInvoiceInfo> previewInvoiceInfos) {
        this.operateDao.updateSalesBillItemBatchNo(previewInvoiceInfos);
    }

    public OrdAutoSplitPreinvoiceInterfaceEntity packAutoSplitPreInvoiceDomain(MsSplitAndMakeOutParams params, String remark, Long id) {
        OrdAutoSplitPreinvoiceInterfaceEntity entity = new OrdAutoSplitPreinvoiceInterfaceEntity();
        BeanUtils.copyProperties(params, (Object)entity);
        entity.setId(id);
        entity.setProcessRemark(remark);
        return entity;
    }
}

