/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.upload.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.constant.enums.ProcessFlag;
import com.xforceplus.phoenix.bill.core.impl.upload.tools.MakePreInvoiceTools;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillOperateDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillQueryDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillInterfaceExtExample;
import com.xforceplus.phoenix.bill.repository.model.modelext.UploadBillItemsExt;
import com.xforceplus.phoenix.bill.repository.model.modelext.UploadBillMainExt;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.DataDistributeUtils;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MakeSalesBillTools {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SalesBillBatchDao salesBillBatchDao;
    private SalesBillQueryDao salesBillQueryDao;
    private SalesBillOperateDao operateDao;
    private DataDistributeUtils dataDistributeUtils;
    private RabbitmqService rabbitmqService;
    private MakePreInvoiceTools makePreInvoiceTools;

    @Autowired
    public MakeSalesBillTools(SalesBillBatchDao salesBillBatchDao, SalesBillQueryDao salesBillQueryDao, SalesBillOperateDao operateDao, DataDistributeUtils dataDistributeUtils, RabbitmqService rabbitmqService, MakePreInvoiceTools makePreInvoiceTools) {
        this.salesBillBatchDao = salesBillBatchDao;
        this.salesBillQueryDao = salesBillQueryDao;
        this.operateDao = operateDao;
        this.dataDistributeUtils = dataDistributeUtils;
        this.rabbitmqService = rabbitmqService;
        this.makePreInvoiceTools = makePreInvoiceTools;
    }

    public void makeSalesBillFlow(List<OrdSalesbillInterfaceEntity> interfaceMains, List<OrdSalesbillInterfaceItemEntity> interfaceItems, Map headers, List<Long> salesBillIds) {
        List successMains;
        ArrayList mains = Lists.newArrayList();
        ArrayList items = Lists.newArrayList();
        ArrayList successInterfaceIds = Lists.newArrayList();
        ArrayList failIds = Lists.newArrayList();
        ArrayList failMains = Lists.newArrayList();
        ArrayList failItems = Lists.newArrayList();
        Map result = Maps.newHashMap();
        interfaceMains.stream().forEach(m -> {
            if (ProcessFlag.SUCCESS.value().equals(m.getProcessFlag())) {
                OrdSalesbillEntity entity = new OrdSalesbillEntity();
                BeanUtils.copyProperties(m, (Object)entity);
                mains.add(entity);
                successInterfaceIds.add(m.getSalesbillIntefaceId());
            } else {
                UploadBillMainExt uploadBillMainExt = new UploadBillMainExt();
                BeanUtils.copyProperties(m, (Object)uploadBillMainExt);
                failMains.add(uploadBillMainExt);
                failIds.add(m.getSalesbillId());
            }
        });
        interfaceItems.stream().forEach(m -> {
            if (successInterfaceIds.contains(m.getSalesbillIntefaceId())) {
                OrdSalesbillItemEntity itemEntity = new OrdSalesbillItemEntity();
                BeanUtils.copyProperties(m, (Object)itemEntity);
                items.add(itemEntity);
            } else {
                UploadBillItemsExt uploadBillItemsExt = new UploadBillItemsExt();
                BeanUtils.copyProperties(m, (Object)uploadBillItemsExt);
                failItems.add(uploadBillItemsExt);
            }
        });
        if (!CommonTools.isEmpty(mains) && !CommonTools.isEmpty(items)) {
            result = this.makeSalesBill(mains, items);
        }
        if (result != null && result.size() > 0) {
            successMains = (List)result.get("successMains");
            List successItems = (List)result.get("successItems");
            List failSalesBillIds = (List)result.get("failSalesBillIds");
            List successSalesBillIds = successMains.stream().map(m -> m.getSalesbillId()).collect(Collectors.toList());
            HashMap map = Maps.newHashMap();
            map.put("successSalesBillIds", successSalesBillIds);
            if (!CommonTools.isEmpty(failSalesBillIds)) {
                failIds.addAll(failSalesBillIds);
            }
            map.put("failSalesBillIds", failIds);
            String json = JsonUtils.writeObjectToFastJson(map);
            this.rabbitmqService.send("phoenix.bill.send.distribute", json, headers);
        } else if (!CommonTools.isEmpty(failMains) && !CommonTools.isEmpty(failItems)) {
            HashMap map = Maps.newHashMap();
            map.put("failSalesBillIds", failIds);
            String json = JsonUtils.writeObjectToFastJson(map);
            this.rabbitmqService.send("phoenix.bill.send.distribute", json, headers);
        }
        if (!CommonTools.isEmpty(salesBillIds) && result != null && result.size() > 0) {
            successMains = (List)result.get("successMains");
            this.makePreInvoiceTools.sendSplitPreInvoice(successMains, salesBillIds);
        }
    }

    @Transactional
    public Map makeSalesBill(List<OrdSalesbillEntity> billMains, List<OrdSalesbillItemEntity> billItems) {
        List<Long> mainIds;
        HashMap map;
        List<Object> successMains;
        boolean flag;
        block7: {
            flag = true;
            successMains = Lists.newArrayList();
            map = Maps.newHashMap();
            mainIds = billMains.stream().map(i -> {
                map.put(i.getSalesbillId(), i.getSalesbillNo());
                return i.getSalesbillId();
            }).collect(Collectors.toList());
            try {
                this.salesBillBatchDao.billBatchInsert((BatchParameter<OrdSalesbillEntity>)BatchParameter.wrap(billMains));
            }
            catch (Exception e) {
                this.logger.error("\u63d2\u5165\u5355\u636e\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                flag = false;
                successMains = this.salesBillQueryDao.getSalesBillByIds(mainIds);
                List salesBillIds = successMains.stream().map(m -> m.getSalesbillId()).collect(Collectors.toList());
                if (salesBillIds.size() == billMains.size()) break block7;
                mainIds.removeAll(salesBillIds);
                if (!CommonTools.isEmpty(mainIds)) {
                    ArrayList tempItems = Lists.newArrayList();
                    for (OrdSalesbillItemEntity itemEntity : billItems) {
                        if (!mainIds.contains(itemEntity.getSalesbillId())) continue;
                        tempItems.add(itemEntity);
                    }
                    billItems.removeAll(tempItems);
                }
                OrdSalesbillInterfaceExtExample extExample = new OrdSalesbillInterfaceExtExample();
                extExample.setSalesbillIdList(mainIds);
                extExample.setProcessFlag(ProcessFlag.FAIL.value());
                extExample.setProcessRemark("\u5355\u636e\u53f7\u3010" + this.getSalesBillNo(map, mainIds) + "\u3011\u5df2\u5b58\u5728");
                this.operateDao.updateSalesBillInterface(extExample);
            }
        }
        if (!CommonTools.isEmpty(billItems)) {
            this.salesBillBatchDao.billItemBatchInsert((BatchParameter<OrdSalesbillItemEntity>)BatchParameter.wrap(billItems));
        }
        if (!flag) {
            map.put("failSalesBillIds", mainIds);
            map.put("successMains", successMains);
        } else {
            map.put("successMains", billMains);
        }
        map.put("successItems", billItems);
        return map;
    }

    private List<Object> getSalesBillNo(Map<Object, Object> map, List<Long> mainIds) {
        List<Object> salesBillNos = mainIds.stream().map(m -> map.get(m)).collect(Collectors.toList());
        return salesBillNos;
    }
}

