/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.upload.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ant.coop.client.model.MsResponse;
import com.xforceplus.ant.coop.client.model.MsSyncAbandonOrDeleteBillRequest;
import com.xforceplus.ant.coop.client.model.MsSyncSettlement;
import com.xforceplus.phoenix.bill.client.cooperation.CooperationIntfClient;
import com.xforceplus.phoenix.bill.client.makeout.PreInvoiceToBillClient;
import com.xforceplus.phoenix.bill.constant.enums.BillItemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.CooperateFlag;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.impl.BillOperationServiceImpl;
import com.xforceplus.phoenix.bill.manager.SalesbillManager;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillQueryDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.DataDistributeUtils;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UploadAbandonOrDeleteTools {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SalesbillManager salesbillManager;
    private IDGenerator idGenerator;
    private OrdSalesbillDao ordSalesbillDao;
    private SalesBillQueryDao salesBillQueryDao;
    private DataDistributeUtils dataDistributeUtils;
    private BillOperationServiceImpl billOperationService;
    private PreInvoiceToBillClient preInvoiceToBillClient;
    private CooperationIntfClient cooperationIntfClient;

    @Autowired
    public UploadAbandonOrDeleteTools(SalesbillManager salesbillManager, IDGenerator idGenerator, OrdSalesbillDao ordSalesbillDao, SalesBillQueryDao salesBillQueryDao, DataDistributeUtils dataDistributeUtils, BillOperationServiceImpl billOperationService, PreInvoiceToBillClient preInvoiceToBillClient, CooperationIntfClient cooperationIntfClient) {
        this.salesbillManager = salesbillManager;
        this.idGenerator = idGenerator;
        this.ordSalesbillDao = ordSalesbillDao;
        this.salesBillQueryDao = salesBillQueryDao;
        this.dataDistributeUtils = dataDistributeUtils;
        this.billOperationService = billOperationService;
        this.preInvoiceToBillClient = preInvoiceToBillClient;
        this.cooperationIntfClient = cooperationIntfClient;
    }

    public void salesBillDeleteOrAbandon(OrdSalesbillInterfaceEntity main, List<OrdSalesbillInterfaceItemEntity> items, String status, Map headers) {
        StringBuilder msg = new StringBuilder();
        String salesbillType = main.getSalesbillType();
        String salesbillNo = main.getSalesbillNo();
        String businessBillType = main.getBusinessBillType();
        Long groupId = (Long)headers.get("groupId");
        String role = String.valueOf(headers.get("businessBillType"));
        Long userId = (Long)headers.get("userId");
        OrdSalesbillExample example = new OrdSalesbillExample();
        OrdSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andSalesbillNoEqualTo(salesbillNo).andStatusEqualTo(SalesBillStatus.NORMAL.value()).andBusinessBillTypeEqualTo(businessBillType).andSalesbillTypeEqualTo(salesbillType);
        if (BusinessBillType.AR.value().equals(businessBillType)) {
            criteria.andSellerGroupIdEqualTo(groupId);
        } else {
            criteria.andPurchaserGroupIdEqualTo(groupId);
        }
        OrdSalesbillEntity ordSalesbillEntity = null;
        try {
            ordSalesbillEntity = this.ordSalesbillDao.selectOneByExample(example);
            boolean b = this.abandonOrDeleteCooperationBill(ordSalesbillEntity, status, userId, msg);
            if (b) {
                Response response = this.preSalesBillDeleteOrAbandon(ordSalesbillEntity, role);
                if (Response.OK.equals(response.getCode())) {
                    List succOrdSalesbillIdList = (List)response.getResult();
                    if (!CommonTools.isEmpty(succOrdSalesbillIdList)) {
                        this.salesbillManager.abandonOrdSalesbillEntityStatusByIds(succOrdSalesbillIdList, SalesBillStatus.NORMAL.value(), SalesBillStatus.INVALID.value(), this.idGenerator.nextId(), role, userId);
                    }
                } else {
                    msg.append(response.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            msg.append(e.getMessage());
        }
        if (!CommonTools.isEmpty(msg.toString())) {
            HashMap mainMap = Maps.newHashMap();
            ArrayList mainMaps = Lists.newArrayList();
            mainMap.put("salesbillNo", main.getSalesbillNo());
            mainMap.put("processRemark", msg.toString());
            mainMaps.add(mainMap);
            ArrayList itemMaps = Lists.newArrayList();
            HashMap itemMap = Maps.newHashMap();
            itemMap.put("salebillItemNo", "");
            itemMap.put("processRemark", "");
            itemMaps.add(itemMap);
            HashMap result = Maps.newHashMap();
            result.put("main", mainMaps);
            result.put("items", itemMaps);
            String remark = JsonUtils.writeObjectToFastJson(result);
            this.dataDistributeUtils.sendBillMessage(remark, headers, -1);
        } else {
            String remark = this.getSuccessFeedBack(Arrays.asList(main), items);
            this.dataDistributeUtils.sendBillMessage(remark, headers, 1);
        }
    }

    public boolean abandonOrDeleteCooperationBill(OrdSalesbillEntity entity, String status, Long userId, StringBuilder msg) {
        if (entity != null) {
            String businessBillType = entity.getBusinessBillType();
            Integer cooperateFlag = entity.getCooperateFlag();
            if (BusinessBillType.AP.value().equals(businessBillType) && CooperateFlag.COOPERATE.value().intValue() == cooperateFlag.intValue()) {
                int optype = "9".equals(status) ? 2 : 1;
                MsSyncAbandonOrDeleteBillRequest msSyncAbandonOrDeleteBillRequest = new MsSyncAbandonOrDeleteBillRequest();
                msSyncAbandonOrDeleteBillRequest.setOpType(Integer.valueOf(optype));
                msSyncAbandonOrDeleteBillRequest.setOpUserId(userId);
                msSyncAbandonOrDeleteBillRequest.setOpUserName("phoenix");
                ArrayList<MsSyncSettlement> list = new ArrayList<MsSyncSettlement>(1);
                MsSyncSettlement settlement = new MsSyncSettlement();
                settlement.setPurchaserTaxNo(entity.getPurchaserTaxNo());
                settlement.setSellerTaxNo(entity.getSellerTaxNo());
                settlement.setSettlementNo(entity.getSalesbillNo());
                list.add(settlement);
                msSyncAbandonOrDeleteBillRequest.setSettlementList(list);
                this.logger.info("\u4f5c\u5e9f\u534f\u540c\u4e1a\u52a1\u5355--------salesBill:{}", (Object)entity.getSalesbillNo());
                MsResponse msResponse = this.cooperationIntfClient.syncAbandonOrDelete(msSyncAbandonOrDeleteBillRequest);
                this.logger.info("\u4f5c\u5e9f\u4e1a\u534f\u540c\u52a1\u5355\u8fd4\u56de------------{}", (Object)String.valueOf(msResponse));
                if (msResponse.getCode() == -1) {
                    return true;
                }
                if (msResponse.getCode() == 1) {
                    return true;
                }
                msg.append(msResponse.getMessage());
                return false;
            }
        }
        return true;
    }

    public Response preSalesBillDeleteOrAbandon(OrdSalesbillEntity ordSalesbillEntity, String role) {
        Response response;
        StringBuilder msg = new StringBuilder();
        if (ordSalesbillEntity == null) {
            msg.append("\u672a\u627e\u5230\u53ef\u4ee5\u4f5c\u5e9f\u7684\u5355\u636e--");
            return Response.from((Integer)Response.Fail, (String)msg.toString());
        }
        boolean isOriginBill = true;
        HashSet batchNos = Sets.newHashSet();
        List<OrdSalesbillItemEntity> itemEntities = this.salesBillQueryDao.countOrigin(ordSalesbillEntity.getSalesbillId());
        for (int i = 0; i < itemEntities.size(); ++i) {
            OrdSalesbillItemEntity itemEntity = itemEntities.get(i);
            if (!BillItemOrigin.ORIGINAL.value().equals(itemEntity.getOrigin())) {
                isOriginBill = false;
            }
            if (itemEntity.getBatchNo() == null || itemEntity.getBatchNo() == 0L) continue;
            batchNos.add(itemEntity.getBatchNo());
        }
        if (!isOriginBill) {
            msg.append("\u5355\u636e\u3010" + ordSalesbillEntity.getSalesbillNo() + "\u3011\u4e0d\u662f\u539f\u5355\uff0c\u8bf7\u56de\u64a4\u540e\u5728\u64cd\u4f5c");
            return Response.from((Integer)Response.Fail, (String)msg.toString());
        }
        if (!CommonTools.isEmpty(new ArrayList(batchNos)) && Response.Fail.equals((response = this.preInvoiceToBillClient.deletePreInvoiceByBatchNo(new ArrayList(batchNos))).getCode())) {
            return Response.from((Integer)Response.Fail, (String)msg.append(response.getMessage()).toString());
        }
        List<Long> succOrdSalesbillIdList = this.billOperationService.preCheckAbandonBillList(Arrays.asList(ordSalesbillEntity), role);
        if (CommonTools.isEmpty(succOrdSalesbillIdList)) {
            msg.append("\u8981\u4f5c\u5e9f\u7684\u5355\u5b50\u5df2\u5f00\u7968\u6216\u8005\u72b6\u6001\u53d1\u751f\u53d8\u5316--");
            return Response.from((Integer)Response.Fail, (String)msg.toString());
        }
        return Response.from((Integer)Response.OK, (String)"\u6821\u9a8c\u901a\u8fc7", succOrdSalesbillIdList);
    }

    public String getSuccessFeedBack(List<OrdSalesbillInterfaceEntity> successMains, List<OrdSalesbillInterfaceItemEntity> successItems) {
        HashMap result = Maps.newHashMap();
        ArrayList mainMaps = Lists.newArrayList();
        ArrayList itemMaps = Lists.newArrayList();
        successMains.stream().forEach(m -> {
            HashMap mainMap = Maps.newHashMap();
            mainMap.put("salesbillNo", m.getSalesbillNo());
            mainMap.put("processRemark", "\u4f5c\u5e9f\u6210\u529f");
            mainMaps.add(mainMap);
        });
        successItems.stream().forEach(m -> {
            HashMap itemMap = Maps.newHashMap();
            itemMap.put("salesbillItemNo", m.getSalesbillItemNo());
            itemMap.put("processRemark", "");
            itemMaps.add(itemMap);
        });
        result.put("main", mainMaps);
        result.put("items", itemMaps);
        String remark = JsonUtils.writeObjectToFastJson(result);
        return remark;
    }
}

