/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.upload.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.client.model.UploadBillMain;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillSystemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.ProcessFlag;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.constant.enums.UsingStatus;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.core.impl.discount.domain.DiscountRequest;
import com.xforceplus.phoenix.bill.core.impl.upload.tools.MakeSalesBillTools;
import com.xforceplus.phoenix.bill.core.impl.upload.tools.UploadAbandonOrDeleteTools;
import com.xforceplus.phoenix.bill.core.service.BillDiscountService;
import com.xforceplus.phoenix.bill.core.service.BillValidateService;
import com.xforceplus.phoenix.bill.exception.DiscountHandleException;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtBean;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.ExceptionUtils;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UploadTools {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RabbitmqService rabbitmqService;
    private IDGenerator idGenerator;
    private BillValidateService billValidateService;
    private BillDiscountService discountService;
    private SalesBillBatchDao billBatchDao;
    private LocalConfigMetadataCacheManager metadataCacheManager;
    private MakeSalesBillTools makeSalesBillTools;
    private UploadAbandonOrDeleteTools uploadAbandonOrDeleteTools;

    @Autowired
    public UploadTools(RabbitmqService rabbitmqService, IDGenerator idGenerator, BillValidateService billValidateService, BillDiscountService discountService, SalesBillBatchDao billBatchDao, LocalConfigMetadataCacheManager metadataCacheManager, MakeSalesBillTools makeSalesBillTools, UploadAbandonOrDeleteTools uploadAbandonOrDeleteTools) {
        this.rabbitmqService = rabbitmqService;
        this.idGenerator = idGenerator;
        this.billValidateService = billValidateService;
        this.discountService = discountService;
        this.billBatchDao = billBatchDao;
        this.metadataCacheManager = metadataCacheManager;
        this.makeSalesBillTools = makeSalesBillTools;
        this.uploadAbandonOrDeleteTools = uploadAbandonOrDeleteTools;
    }

    public void uploadBillFlow(Message message) {
        Integer count;
        Map headers = message.getMessageProperties().getHeaders();
        String data = new String(message.getBody());
        this.logger.info("=========headers-{}================uploadMessgeBody{}=====================", (Object)headers, (Object)data);
        ArrayList mains = Lists.newArrayList();
        ArrayList items = Lists.newArrayList();
        List<Object> salesBillMainAndDetails = Lists.newArrayList();
        ArrayList salesBillIds = Lists.newArrayList();
        try {
            salesBillMainAndDetails = JsonUtils.writeFastJsonToListObject(data, com.xforceplus.phoenix.bill.client.model.Message.class);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        StringBuilder remark = this.checkHeaders(headers);
        if (!CommonTools.isEmpty(remark.toString())) {
            for (com.xforceplus.phoenix.bill.client.model.Message message2 : salesBillMainAndDetails) {
                this.insertBillInterface(message2, remark.toString(), headers, mains, items);
            }
        } else {
            for (com.xforceplus.phoenix.bill.client.model.Message message3 : salesBillMainAndDetails) {
                try {
                    OrdSalesbillInterfaceEntity main = new OrdSalesbillInterfaceEntity();
                    ArrayList itemEntities = Lists.newArrayList();
                    this.initBillInfo(main, itemEntities, message3, headers);
                    String status = (String)headers.get("status");
                    if (SalesBillStatus.INVALID.value().toString().equals(status) || SalesBillStatus.DELETED.value().toString().equals(status)) {
                        this.uploadAbandonOrDeleteTools.salesBillDeleteOrAbandon(main, items, status, headers);
                        continue;
                    }
                    this.uploadBillSingle(main, itemEntities, headers, salesBillIds);
                    mains.add(main);
                    items.addAll(itemEntities);
                }
                catch (Exception e) {
                    this.logger.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    String stackTrace = ExceptionUtils.getStackTrace(e);
                    String lastCauseBy = ExceptionUtils.getExceptionCauseBy(stackTrace, 2000);
                    this.insertBillInterface(message3, lastCauseBy, headers, mains, items);
                }
            }
        }
        if ((count = this.makeSalesBillInterface(mains, items)) > 0) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put("interfaceMains", mains);
            hashMap.put("interfaceItems", items);
            hashMap.put("salesBillIds", salesBillIds);
            String json = JsonUtils.writeObjectToFastJson(hashMap);
            this.rabbitmqService.send("phoenix.bill.make", json, headers);
        }
    }

    private void uploadBillSingle(OrdSalesbillInterfaceEntity main, List<OrdSalesbillInterfaceItemEntity> items, Map headers, List<Long> salesBillIds) {
        String status = (String)headers.get("status");
        boolean autoSplitPreInvoice = false;
        StringBuilder mainRemark = this.billValidateService.allMainChecks(main, headers, ValidateType.IMPORT);
        boolean checkItemFlag = true;
        if (CommonTools.isEmpty(mainRemark.toString())) {
            checkItemFlag = this.billValidateService.checkItems(main, items, mainRemark, headers, ValidateType.IMPORT.value());
        } else {
            this.clearBillItems(items);
        }
        if (!CommonTools.isEmpty(mainRemark.toString()) || !checkItemFlag) {
            main.setProcessFlag(ProcessFlag.FAIL.value());
            main.setProcessRemark(mainRemark.append(main.getProcessRemark()).toString());
        } else {
            main.setProcessFlag(ProcessFlag.SUCCESS.value());
            main.setProcessRemark(ProcessFlag.SUCCESS.desc());
            ConfigRequestModel configRequestModel = new ConfigRequestModel();
            BeanUtils.copyProperties((Object)main, configRequestModel);
            SysConfigExtBean sysInfoRuleDTO = this.metadataCacheManager.querySysInfoConfig(configRequestModel, ConfigTypeEnum.SYS_CONFIG_TYPE);
            boolean autoSplitDiscountFlag = false;
            boolean autoSplitPreCardFlag = false;
            if (sysInfoRuleDTO != null && sysInfoRuleDTO.getAutoSplitDiscountFlag() != null) {
                autoSplitDiscountFlag = sysInfoRuleDTO.getAutoSplitDiscountFlag();
            }
            if (sysInfoRuleDTO != null && sysInfoRuleDTO.getAutoSplitDiscountFlag() != null) {
                autoSplitPreCardFlag = sysInfoRuleDTO.getAutoSplitPreCardFlag();
            }
            if (sysInfoRuleDTO != null && autoSplitDiscountFlag) {
                this.splitDiscount(main, items);
            }
            if (sysInfoRuleDTO != null && sysInfoRuleDTO.getAutoSplitBillPreInvoice() != null) {
                autoSplitPreInvoice = sysInfoRuleDTO.getAutoSplitBillPreInvoice();
            }
            if (autoSplitPreInvoice && UsingStatus.USING.value().equals(main.getUsingStatus())) {
                salesBillIds.add(main.getSalesbillId());
            }
        }
    }

    private void insertBillInterface(com.xforceplus.phoenix.bill.client.model.Message salesBillMainAndDetail, String remark, Map headers, List<OrdSalesbillInterfaceEntity> mains, List<OrdSalesbillInterfaceItemEntity> items) {
        OrdSalesbillInterfaceEntity main = new OrdSalesbillInterfaceEntity();
        ArrayList itemEntities = Lists.newArrayList();
        this.initBillInfo(main, itemEntities, salesBillMainAndDetail, headers);
        main.setProcessFlag(ProcessFlag.FAIL.value());
        main.setProcessRemark(remark);
        for (int i = 0; i < itemEntities.size(); ++i) {
            OrdSalesbillInterfaceItemEntity itemEntity = (OrdSalesbillInterfaceItemEntity)((Object)itemEntities.get(i));
            itemEntity.setSalesbillIntefaceId(main.getSalesbillIntefaceId());
            itemEntity.setSalesbillId(main.getSalesbillId());
            itemEntity.setSalesbillIntefaceItemId(this.idGenerator.nextId());
            itemEntity.setSalesbillItemId(this.idGenerator.nextId());
        }
        mains.add(main);
        items.addAll(itemEntities);
    }

    public void initBillInfo(OrdSalesbillInterfaceEntity main, List<OrdSalesbillInterfaceItemEntity> items, com.xforceplus.phoenix.bill.client.model.Message salesBillMainAndDetail, Map headers) {
        UploadBillMain salesBillMain = salesBillMainAndDetail.getSalesBillMain();
        BeanUtils.copyProperties(salesBillMain, (Object)main);
        main.setOrigData(JsonUtils.writeObjectToFastJson(salesBillMain));
        String systemOrig = String.valueOf(headers.get("systemOrig"));
        String businessBillType = String.valueOf(headers.get("businessBillType"));
        String batchNo = String.valueOf(headers.get("importBatchNo"));
        String status = (String)headers.get("status");
        String customNo = (String)headers.get("customNo");
        Long userId = CommonTools.toLong(headers.get("userId"));
        Long groupId = (Long)headers.get("groupId");
        if (CommonTools.isEmpty(batchNo)) {
            batchNo = String.valueOf(this.idGenerator.nextId());
        }
        main.setSalesbillIntefaceId(this.idGenerator.nextId());
        main.setSalesbillId(this.idGenerator.nextId());
        main.setSystemOrig(CommonTools.isEmpty(systemOrig) ? BillSystemOrigin.ERP.value() : systemOrig);
        main.setImportBatchNo(Long.valueOf(batchNo));
        main.setProcessFlag(ProcessFlag.WAITING.value());
        main.setProcessRemark("");
        main.setStatus(Integer.valueOf(status));
        main.setBusinessBillType(businessBillType);
        if (BusinessBillType.AR.value().equals(businessBillType)) {
            main.setSellerGroupId(groupId);
        } else if (BusinessBillType.AP.value().equals(businessBillType)) {
            main.setPurchaserGroupId(groupId);
        }
        main.setCreateUser(userId);
        main.setCustomerNo(customNo);
        List salesBillDetails = salesBillMainAndDetail.getSalesBillDetails();
        salesBillDetails.stream().forEach(m -> {
            OrdSalesbillInterfaceItemEntity itemEntity = new OrdSalesbillInterfaceItemEntity();
            BeanUtils.copyProperties(m, (Object)itemEntity);
            itemEntity.setOrigData(JsonUtils.writeObjectToFastJson(m));
            itemEntity.setSalesbillIntefaceId(main.getSalesbillIntefaceId());
            itemEntity.setSalesbillId(main.getSalesbillId());
            itemEntity.setSalesbillIntefaceItemId(this.idGenerator.nextId());
            itemEntity.setSalesbillItemId(this.idGenerator.nextId());
            itemEntity.setCustomerNo(main.getCustomerNo());
            itemEntity.setStatus(BillItemStatus.NORMAL.value());
            itemEntity.setCreateUser(userId);
            itemEntity.setSalesbillNo(main.getSalesbillNo());
            itemEntity.setBusinessBillType(main.getBusinessBillType());
            items.add(itemEntity);
        });
    }

    @Transactional
    public Integer makeSalesBillInterface(List<OrdSalesbillInterfaceEntity> mains, List<OrdSalesbillInterfaceItemEntity> items) {
        Integer count = 0;
        try {
            if (CommonTools.isEmpty(mains)) {
                return count;
            }
            this.billBatchDao.billInterfaceBatchInsert((BatchParameter<OrdSalesbillInterfaceEntity>)BatchParameter.wrap(mains));
            count = this.billBatchDao.billInterfaceItemBatchInsert((BatchParameter<OrdSalesbillInterfaceItemEntity>)BatchParameter.wrap(items));
        }
        catch (Exception e) {
            this.logger.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return count;
    }

    public void splitDiscount(OrdSalesbillInterfaceEntity main, List<OrdSalesbillInterfaceItemEntity> items) {
        try {
            Integer priceMethod = main.getPriceMethod();
            if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
                main.setInnerDiscountWithoutTax(BigDecimal.ZERO);
                main.setOutterDiscountWithoutTax(BigDecimal.ZERO);
                main.setOutterPrepayAmountWithoutTax(BigDecimal.ZERO);
                main.setInnerPrepayAmountWithoutTax(BigDecimal.ZERO);
            } else if (BillItemPriceMethod.WITHOUT_TAX.value().equals(priceMethod)) {
                main.setInnerDiscountWithTax(BigDecimal.ZERO);
                main.setOutterDiscountWithTax(BigDecimal.ZERO);
                main.setOutterPrepayAmountWithTax(BigDecimal.ZERO);
                main.setInnerPrepayAmountWithTax(BigDecimal.ZERO);
            }
            DiscountRequest discountRequest = this.discountService.splitDiscount(items, main);
            main.setInnerDiscountWithoutTax(BigDecimal.ZERO);
            main.setInnerDiscountWithTax(BigDecimal.ZERO);
            main.setInnerPrepayAmountWithoutTax(BigDecimal.ZERO);
            main.setInnerPrepayAmountWithTax(BigDecimal.ZERO);
            main.setOutterDiscountWithoutTax(BigDecimal.ZERO);
            main.setOutterDiscountWithTax(BigDecimal.ZERO);
            main.setOutterPrepayAmountWithoutTax(BigDecimal.ZERO);
            main.setOutterPrepayAmountWithTax(BigDecimal.ZERO);
        }
        catch (DiscountHandleException e) {
            this.logger.error("\u5206\u644a\u6298\u6263\u5931\u8d25\uff1a", (Object)e.getMessage());
            main.setProcessFlag(ProcessFlag.FAIL.value());
            main.setProcessRemark(e.getErrorMessage());
        }
    }

    public StringBuilder checkHeaders(Map headers) {
        StringBuilder remark = new StringBuilder();
        String businessBillType = String.valueOf(headers.get("businessBillType"));
        String status = (String)headers.get("status");
        if (!BusinessBillType.AR.value().equals(businessBillType) && !BusinessBillType.AP.value().equals(businessBillType)) {
            remark.append("--\u5355\u636e\u7c7b\u578b\u53ea\u80fd\u662fAR or AP,\u5f53\u524d\u586b\u5199\u503c\u4e3a").append(businessBillType).append("--");
        }
        if (!(SalesBillStatus.NORMAL.value().toString().equals(status) || SalesBillStatus.DELETED.value().toString().equals(status) || SalesBillStatus.INVALID.value().toString().equals(status))) {
            remark.append("--\u5355\u636e\u72b6\u6001\u53ea\u80fd\u4e3a 1 \uff0c0\uff0c9--");
        }
        return remark;
    }

    private void clearBillItems(List<OrdSalesbillInterfaceItemEntity> itemEntities) {
        ArrayList items = Lists.newArrayList();
        itemEntities.stream().forEach(m -> {
            OrdSalesbillInterfaceItemEntity itemEntity = new OrdSalesbillInterfaceItemEntity();
            itemEntity.setSalesbillIntefaceId(m.getSalesbillIntefaceId());
            itemEntity.setSalesbillIntefaceItemId(m.getSalesbillIntefaceItemId());
            itemEntity.setSalesbillId(m.getSalesbillId());
            itemEntity.setSalesbillItemId(m.getSalesbillItemId());
            itemEntity.setOrigData(m.getOrigData());
            BeanUtils.copyProperties((Object)itemEntity, m);
        });
    }
}

