/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.tools;

import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceType;
import com.xforceplus.phoenix.bill.constant.enums.taxcode.TaxPreCons;
import com.xforceplus.phoenix.bill.constant.enums.taxcode.TaxPres;
import com.xforceplus.phoenix.bill.constant.enums.taxcode.ZeroTaxs;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaxCodeTools {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public int addTaxcodeConfig(OrdSalesbillInterfaceItemEntity billItem, OrdSalesbillInterfaceEntity billEntity) {
        return 0;
    }

    public StringBuilder getCheckItemInfo(String itemName, String shortName) {
        StringBuilder resultMsg = new StringBuilder();
        if (!CommonTools.isEmpty(itemName) && !CommonTools.isEmpty(shortName)) {
            if (CommonTools.hasShortNameInfo(itemName)) {
                if (CommonTools.checkSameItemInfo(itemName, shortName)) {
                    String combineName = String.format("*%s*", shortName);
                    if (CommonTools.exceedMaxLength(itemName, 92)) {
                        resultMsg.append("--\u5355\u636e\u660e\u7ec6\u4e2d\u8d27\u7269\u53ca\u670d\u52a1\u540d\u79f0[").append(itemName).append("]\u957f\u5ea6\u8d85\u8fc746\u4e2a\u6c49\u5b57\u621692\u4e2a\u5b57\u7b26--");
                    }
                } else {
                    resultMsg.append("--\u5355\u636e\u660e\u7ec6\u4e2d\u8d27\u7269\u53ca\u670d\u52a1\u540d\u79f0[").append(itemName).append("]\u6240\u542b\u6709\u7684\u7a0e\u7f16\u7b80\u79f0\u9519\u8bef\u6216\u4e0d\u89c4\u8303--");
                }
            } else {
                String newItemName = CommonTools.getCombineItemName(itemName, shortName);
                if (CommonTools.exceedMaxLength(newItemName, 92)) {
                    resultMsg.append("--\u5355\u636e\u660e\u7ec6\u4e2d\u8d27\u7269\u53ca\u670d\u52a1\u540d\u79f0[").append(newItemName).append("]\u957f\u5ea6\u8d85\u8fc746\u4e2a\u6c49\u5b57\u621692\u4e2a\u5b57\u7b26--");
                }
            }
        }
        return resultMsg;
    }

    public StringBuilder checkGoodsTaxNoStartWithSix(ValidatorContext context, OrdSalesbillInterfaceEntity billEntity, OrdSalesbillInterfaceItemEntity billItem) {
        String goodsTaxNo = billItem.getGoodsTaxNo();
        StringBuilder msg = new StringBuilder();
        if (!CommonTools.isEmpty(goodsTaxNo) && goodsTaxNo.startsWith("6")) {
            Object sysConfig;
            if (goodsTaxNo.startsWith("6") && InvoiceType.SPECIAL.value().equals(billEntity.getInvoiceType())) {
                msg.append("--\u5f53\u5355\u636e\u5bfc\u5165\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u65f6\uff1a\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u3010").append(goodsTaxNo).append("\u3011\u586b\u5199\u6709\u8bef\u3010\u4e0d\u80fd\u4ee56\u5f00\u5934\u3011--");
            }
            String taxPre = billItem.getTaxPre();
            String taxPreCon = billItem.getTaxPreCon();
            String zeroTax = billItem.getZeroTax();
            if (!(TaxPres.SHARE.value().equals(taxPre) && TaxPreCons.FIVE.value().equals(taxPreCon) && ZeroTaxs.TWO.value().equals(zeroTax) || (sysConfig = context.getAttribute(ConfigTypeEnum.SYS_CONFIG_TYPE.getObjCode())) == null)) {
                SysInfoRuleDTO sysInfoRuleDTO = (SysInfoRuleDTO)sysConfig;
                if (sysInfoRuleDTO != null && sysInfoRuleDTO.getAutoUpdateTaxCodeFlag() != null && sysInfoRuleDTO.getAutoUpdateTaxCodeFlag().booleanValue()) {
                    this.logger.info("--\u660e\u7ec6\u53f7-{}\uff0c\u7a0e\u7f16\u662f6\u5f00\u5934\uff0ctaxPre-{}\uff0ctaxPreCon-{}\uff0czeroTax-{},\u5206\u522b\u4fee\u6539\u4e3a1\uff0c\u4e0d\u5f81\u7a0e\uff0c2", new Object[]{billItem.getSalesbillItemNo(), taxPre, taxPreCon, zeroTax});
                    billItem.setTaxPre("1");
                    billItem.setTaxPreCon("\u4e0d\u5f81\u7a0e");
                    billItem.setZeroTax("2");
                } else {
                    msg.append("--6\u5f00\u5934\u7684\u7a0e\u7f16,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56 \u5fc5\u987b\u662f\u3010\u4eab\u53d7\u3011,\u4f18\u60e0\u653f\u7b56\u5185\u5bb9 \u5fc5\u987b\u662f\u3010\u4e0d\u5f81\u7a0e\u3011,\u96f6\u7a0e\u7387\u6807\u8bc6\u5fc5\u987b\u662f\u30102\u3011,\u5e76\u4e14\u7cfb\u7edf\u914d\u7f6e\u9879\u662f\u4e0d\u81ea\u52a8\u4fee\u6b63--");
                }
            }
        }
        return msg;
    }

    public StringBuilder checkTaxPreAndConAndZero(OrdSalesbillInterfaceItemEntity billItem) {
        StringBuilder msg = new StringBuilder();
        String taxPre = CommonTools.isEmpty(billItem.getTaxPre()) ? "" : billItem.getTaxPre();
        String taxPreCon = CommonTools.isEmpty(billItem.getTaxPreCon()) ? "" : billItem.getTaxPreCon();
        String zeroTax = CommonTools.isEmpty(billItem.getZeroTax()) ? "" : billItem.getZeroTax();
        String goodsTaxNo = CommonTools.isEmpty(billItem.getGoodsTaxNo()) ? "" : billItem.getGoodsTaxNo();
        String taxRate = String.valueOf(billItem.getTaxRate());
        if (CommonTools.isEmpty(taxRate)) {
            msg.append("----\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01--");
            return msg;
        }
        taxRate = CommonTools.subZeroAndDot(taxRate);
        BigDecimal decimalTaxRate = new BigDecimal(taxRate);
        if (goodsTaxNo != null && goodsTaxNo.startsWith("6")) {
            this.checkBySixGoodsNo(zeroTax, taxPreCon, taxPre, msg);
        }
        if (CommonTools.isEmpty(msg.toString())) {
            this.checkByShare(zeroTax, taxPreCon, taxPre, decimalTaxRate, msg);
        }
        if (decimalTaxRate.compareTo(BigDecimal.ZERO) == 0 && CommonTools.isEmpty(msg.toString())) {
            this.checkByZeroTaxRate(zeroTax, taxPreCon, taxPre, msg);
        }
        if (CommonTools.isEmpty(msg.toString())) {
            this.checkByTaxPreCon(taxPreCon, zeroTax, taxPre, taxRate, msg);
        }
        return msg;
    }

    private void checkBySixGoodsNo(String zeroTax, String taxPreCon, String taxPre, StringBuilder msg) {
        if (!taxPre.equals(TaxPres.SHARE.value())) {
            msg.append("----6 \u5f00\u5934\u7a0e\u7f16 \u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4e3a\u4eab\u53d7--");
        }
        if (!taxPreCon.equals(ZeroTaxs.TWO.description())) {
            msg.append("----6 \u5f00\u5934\u7a0e\u7f16 \u4f18\u60e0\u5185\u5bb9\u5fc5\u987b\u4e0d\u5f81\u7a0e--");
        }
        if (!zeroTax.equals(ZeroTaxs.TWO.value())) {
            msg.append("--6 \u5f00\u5934\u7a0e\u7f16 \u96f6\u7a0e\u7387\u6807\u8bc6\u5fc5\u987b2--");
        }
    }

    private void checkByShare(String zeroTax, String taxPreCon, String taxPre, BigDecimal decimalTaxRate, StringBuilder msg) {
        boolean tempFalg5;
        boolean tempFalg1 = decimalTaxRate.compareTo(new BigDecimal("0.06")) == 0;
        boolean tempFalg2 = decimalTaxRate.compareTo(new BigDecimal("0.1")) == 0;
        boolean tempFalg3 = decimalTaxRate.compareTo(new BigDecimal("0.16")) == 0;
        boolean tempFalg4 = decimalTaxRate.compareTo(new BigDecimal("0.05")) == 0;
        boolean bl = tempFalg5 = decimalTaxRate.compareTo(new BigDecimal("0.03")) == 0;
        if (tempFalg1 || tempFalg2 || tempFalg3 || tempFalg4 || tempFalg5) {
            if (TaxPres.NOT_SHARE.value().equals(taxPre)) {
                if (!CommonTools.isEmpty(taxPreCon) || !CommonTools.isEmpty(zeroTax)) {
                    msg.append("--\u7a0e\u73873%,5%,6%,10%,16%-\u4f18\u60e0\u653f\u7b56\u4e0d\u4eab\u53d7\u65f6,\u4f18\u60e0\u5185\u5bb9\u548c\u96f6\u7a0e\u7387\u6807\u8bc6\u5fc5\u987b\u662f\u7a7a--");
                }
            } else if (TaxPres.SHARE.value().equals(taxPre)) {
                if (!CommonTools.isEmpty(zeroTax)) {
                    msg.append("--\u7a0e\u73873%,5%,6%,10%,16%-\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u4e3a\u4eab\u53d7\u65f6-\u96f6\u7a0e\u7387\u6807\u8bc6\u5fc5\u987b\u4e3a\u7a7a--");
                }
                if (CommonTools.isEmpty(taxPreCon)) {
                    msg.append("--\u7a0e\u73873%,5%,6%,10%,16%-\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u4e3a\u4eab\u53d7\u65f6-\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a--");
                }
            }
        }
    }

    private void checkByZeroTaxRate(String zeroTax, String taxPreCon, String taxPre, StringBuilder msg) {
        if (TaxPres.SHARE.value().equals(taxPre)) {
            if (CommonTools.isEmpty(zeroTax)) {
                msg.append("--\u7a0e\u73870%,\u4f18\u60e0\u5185\u5bb9\u4e3a\u4eab\u53d7,\u96f6\u7a0e\u7387\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty(taxPreCon)) {
                msg.append("--\u7a0e\u73870%,\u4f18\u60e0\u5185\u5bb9\u4e3a\u4eab\u53d7,\u4f18\u60e0\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (ZeroTaxs.ONE.value().equals(zeroTax) && !ZeroTaxs.ONE.description().equals(taxPreCon.trim())) {
                msg.append("--\u7a0e\u73870%-\u4eab\u53d7-\u96f6\u7a0e\u7387\u6807\u8bc61,\u4f18\u60e0\u5185\u5bb9\u5fc5\u987b\u662f\u514d\u7a0e--");
            }
            if (ZeroTaxs.TWO.value().equals(zeroTax) && !ZeroTaxs.TWO.description().equals(taxPreCon.trim())) {
                msg.append("--\u7a0e\u73870%-\u4eab\u53d7-\u96f6\u7a0e\u7387\u6807\u8bc62,\u4f18\u60e0\u5185\u5bb9\u5fc5\u987b\u662f\u4e0d\u5f81\u7a0e--");
            }
            if (ZeroTaxs.THREE.value().equals(zeroTax)) {
                msg.append("--\u7a0e\u73870%-\u96f6\u7a0e\u7387\u6807\u8bc63,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4e3a\u4e0d\u4eab\u53d7--");
            }
            if (ZeroTaxs.THREE.description().equals(taxPreCon.trim())) {
                msg.append("--\u7a0e\u73870%-\u4f18\u60e0\u5185\u5bb9\u662f\u666e\u901a\u96f6\u7a0e\u7387,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u5fc5\u987b\u4e3a\u4e0d\u4eab\u53d7--");
            }
            if (ZeroTaxs.ZERO.value().equals(zeroTax) && !ZeroTaxs.ZERO.description().equals(taxPreCon.trim())) {
                msg.append("--\u7a0e\u73870%-\u4eab\u53d7-\u96f6\u7a0e\u7387\u6807\u8bc60,\u4f18\u60e0\u5185\u5bb9\u5fc5\u987b\u662f\u51fa\u53e3\u9000\u7a0e--");
            }
        } else if (!ZeroTaxs.THREE.value().equals(zeroTax)) {
            msg.append("--\u7a0e\u73870%-\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u4e3a\u4e0d\u4eab\u53d7\u65f6,\u96f6\u7a0e\u7387\u6807\u5fd7\u5fc5\u987b\u662f3--");
            if (!"".equals(taxPreCon.trim())) {
                msg.append("--\u7a0e\u73870%-\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u4e3a\u4e0d\u4eab\u53d7\u65f6,\u96f6\u7a0e\u7387\u6807\u5fd7\u662f3,\u4f18\u60e0\u5185\u5bb9\u5fc5\u987b\u4e3a\u7a7a--");
            }
        }
    }

    private void checkByTaxPreCon(String taxPreCon, String zeroTax, String taxPre, String taxRate, StringBuilder msg) {
        if (TaxPreCons.THREE.value().equals(taxPreCon)) {
            if (new BigDecimal(taxRate).compareTo(new BigDecimal("0.05")) != 0) {
                msg.append("--\u653f\u7b56\u5185\u5bb9\u201c\u63095%\u7b80\u6613\u5f81\u6536\u201d-\u96f6\u7a0e\u7387\u6807\u8bc6\u7a7a-\u4eab\u53d7 \u7a0e\u7387\u5fc5\u987b\u662f5%--");
            }
            if (!CommonTools.isEmpty(zeroTax)) {
                msg.append("--\u63095%\u7b80\u6613\u5f81\u6536\uff0c\u96f6\u7a0e\u7387\u5fc5\u987b\u662f\u7a7a--");
            }
            if (TaxPres.NOT_SHARE.value().equals(taxPre)) {
                msg.append("--\u63095%\u7b80\u6613\u5f81\u6536,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56 \u5fc5\u987b\u4e3a\u4eab\u53d7--");
            }
        }
        if (TaxPreCons.thirteen.value().equals(taxPreCon)) {
            if (new BigDecimal(taxRate).compareTo(new BigDecimal("0.03")) != 0) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u6309\u7b80\u6613\u5f81\u6536-\u96f6\u7a0e\u7387\u6807\u8bc6\u7a7a-\u4eab\u53d7 \u7a0e\u7387\u5fc5\u987b\u662f3%--");
            }
            if (!CommonTools.isEmpty(zeroTax)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u6309\u7b80\u6613\u5f81\u6536\uff0c\u96f6\u7a0e\u7387\u5fc5\u987b\u662f\u7a7a--");
            }
            if (TaxPres.NOT_SHARE.value().equals(taxPre)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u6309\u7b80\u6613\u5f81\u6536,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56 \u5fc5\u987b\u4e3a\u4eab\u53d7--");
            }
        }
        if (TaxPreCons.TWO.value().equals(taxPreCon)) {
            if (new BigDecimal(taxRate).compareTo(new BigDecimal("0.03")) != 0) {
                msg.append("--\u653f\u7b56\u5185\u5bb9\u201c\u63093%\u7b80\u6613\u5f81\u6536\u201d-\u96f6\u7a0e\u7387\u6807\u8bc6\u7a7a-\u4eab\u53d7 \u7a0e\u7387\u5fc5\u987b\u662f3%--");
            }
            if (!CommonTools.isEmpty(zeroTax)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u63093%\u7b80\u6613\u5f81\u6536\uff0c\u96f6\u7a0e\u7387\u5fc5\u987b\u662f\u7a7a--");
            }
            if (TaxPres.NOT_SHARE.value().equals(taxPre)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u63093%\u7b80\u6613\u5f81\u6536,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56 \u5fc5\u987b\u4e3a\u4eab\u53d7--");
            }
        }
        if (TaxPreCons.forteen.value().equals(taxPreCon)) {
            if (new BigDecimal(taxRate).compareTo(BigDecimal.ZERO) != 0) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u514d\u7a0e-\u96f6\u7a0e\u7387\u6807\u8bc6\u7a7a-\u4eab\u53d7 \u7a0e\u7387\u5fc5\u987b\u662f0%--");
            }
            if (!ZeroTaxs.ONE.value().equals(zeroTax)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u514d\u7a0e\uff0c\u96f6\u7a0e\u7387\u6807\u8bc6\u5fc5\u987b\u662f1--");
            }
            if (TaxPres.NOT_SHARE.value().equals(taxPre)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u514d\u7a0e,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56 \u5fc5\u987b\u4e3a\u4eab\u53d7--");
            }
        }
        if (TaxPreCons.FIVE.value().equals(taxPreCon)) {
            if (new BigDecimal(taxRate).compareTo(BigDecimal.ZERO) != 0) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u4e0d\u5f81\u7a0e-\u96f6\u7a0e\u7387\u6807\u8bc6\u7a7a-\u4eab\u53d7 \u7a0e\u7387\u5fc5\u987b\u662f0%--");
            }
            if (!ZeroTaxs.TWO.value().equals(zeroTax)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u4e0d\u5f81\u7a0e\uff0c\u96f6\u7a0e\u7387\u6807\u8bc6\u5fc5\u987b\u662f2--");
            }
            if (TaxPres.NOT_SHARE.value().equals(taxPre)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u4e0d\u5f81\u7a0e,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56 \u5fc5\u987b\u4e3a\u4eab\u53d7--");
            }
        }
        if (TaxPreCons.ninety.value().equals(taxPreCon)) {
            if (new BigDecimal(taxRate).compareTo(BigDecimal.ZERO) != 0) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u666e\u901a0\u7a0e\u7387-\u96f6\u7a0e\u7387\u6807\u8bc6\u7a7a-\u4eab\u53d7 \u7a0e\u7387\u5fc5\u987b\u662f0%---");
            }
            if (!ZeroTaxs.THREE.value().equals(zeroTax)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u666e\u901a0\u7a0e\u7387\uff0c\u96f6\u7a0e\u7387\u6807\u8bc6\u5fc5\u987b\u662f3--");
            }
        }
        if (TaxPreCons.eighteen.value().equals(taxPreCon)) {
            if (new BigDecimal(taxRate).compareTo(BigDecimal.ZERO) != 0) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u51fa\u53e3\u9000\u7a0e-\u96f6\u7a0e\u7387\u6807\u8bc6\u7a7a-\u4eab\u53d7 \u7a0e\u7387\u5fc5\u987b\u662f0%--");
            }
            if (!ZeroTaxs.ZERO.value().equals(zeroTax)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u51fa\u53e3\u9000\u7a0e\uff0c\u96f6\u7a0e\u7387\u5fc5\u987b\u662f0--");
            }
            if (TaxPres.NOT_SHARE.value().equals(taxPre)) {
                msg.append("--\u653f\u7b56\u5185\u5bb9:\u51fa\u53e3\u9000\u7a0e\uff0c\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56 \u5fc5\u987b\u4e3a\u4eab\u53d7----");
            }
        }
    }
}

