/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.billitem;

import com.baidu.unbiz.fluentvalidator.FluentValidator;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.client.model.SplitBillItemPreviewRequest;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitType;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitMergeTools;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class BillItemSplitBaseValidator
extends ValidatorHandler<SplitBillItemPreviewRequest>
implements Validator<SplitBillItemPreviewRequest> {
    public boolean accept(ValidatorContext context, SplitBillItemPreviewRequest request) {
        return super.accept(context, (Object)request);
    }

    public boolean validate(ValidatorContext context, SplitBillItemPreviewRequest request) {
        throw new UnsupportedOperationException();
    }

    public void compose(FluentValidator current, ValidatorContext context, SplitBillItemPreviewRequest request) {
        super.compose(current, context, (Object)request);
    }

    protected void apportionFieldsByFormula(OrdSalesbillItemEntity sourceBillItem, List<SalesbillItem> outTargetSalesBillItemList, BillItemSplitType splitType, Integer priceMethod) {
        if (CollectionUtils.isEmpty(outTargetSalesBillItemList)) {
            return;
        }
        for (SalesbillItem item : outTargetSalesBillItemList) {
            BigDecimal apportionRate = BillItemSplitMergeTools.getApportionRate(priceMethod, sourceBillItem, item, splitType);
            this.fillOutterDiscountFields(sourceBillItem, item, apportionRate);
            this.fillInnerDiscountFields(sourceBillItem, item, apportionRate);
            this.fillOutterPrepayFields(sourceBillItem, item, apportionRate);
            this.fillInnerPrepayFields(sourceBillItem, item, apportionRate);
        }
    }

    private void fillOutterDiscountFields(OrdSalesbillItemEntity sourceBillItem, SalesbillItem outSalesbillItem, BigDecimal apportionRate) {
        BigDecimal outterDiscountWithTax = apportionRate.multiply(sourceBillItem.getOutterDiscountWithTax()).setScale(6, 4);
        BigDecimal outterDiscountWithoutTax = apportionRate.multiply(sourceBillItem.getOutterDiscountWithoutTax()).setScale(6, 4);
        BigDecimal outterDiscountTax = outterDiscountWithTax.subtract(outterDiscountWithoutTax);
        outSalesbillItem.setOutterDiscountWithTax(outterDiscountWithTax);
        outSalesbillItem.setOutterDiscountWithoutTax(outterDiscountWithoutTax);
        outSalesbillItem.setOutterDiscountTax(outterDiscountTax);
    }

    private void fillInnerDiscountFields(OrdSalesbillItemEntity sourceBillItem, SalesbillItem outSalesbillItem, BigDecimal apportionRate) {
        BigDecimal innerDiscountWithTax = apportionRate.multiply(sourceBillItem.getInnerDiscountWithTax()).setScale(6, 4);
        BigDecimal innerDiscountWithoutTax = apportionRate.multiply(sourceBillItem.getInnerDiscountWithoutTax()).setScale(6, 4);
        BigDecimal innerDiscountTax = innerDiscountWithTax.subtract(innerDiscountWithoutTax);
        outSalesbillItem.setInnerDiscountWithTax(innerDiscountWithTax);
        outSalesbillItem.setInnerDiscountWithoutTax(innerDiscountWithoutTax);
        outSalesbillItem.setInnerDiscountTax(innerDiscountTax);
    }

    private void fillOutterPrepayFields(OrdSalesbillItemEntity sourceBillItem, SalesbillItem outSalesbillItem, BigDecimal apportionRate) {
        BigDecimal outterPrepayAmountWithTax = apportionRate.multiply(sourceBillItem.getOutterPrepayAmountWithTax()).setScale(6, 4);
        BigDecimal outterPrepayAmountWithoutTax = apportionRate.multiply(sourceBillItem.getOutterPrepayAmountWithoutTax()).setScale(6, 4);
        BigDecimal outterPrepayAmountTax = outterPrepayAmountWithTax.subtract(outterPrepayAmountWithoutTax);
        outSalesbillItem.setOutterPrepayAmountWithTax(outterPrepayAmountWithTax);
        outSalesbillItem.setOutterPrepayAmountWithoutTax(outterPrepayAmountWithoutTax);
        outSalesbillItem.setOutterPrepayAmountTax(outterPrepayAmountTax);
    }

    private void fillInnerPrepayFields(OrdSalesbillItemEntity sourceBillItem, SalesbillItem outSalesbillItem, BigDecimal apportionRate) {
        BigDecimal innerPrepayAmountWithTax = apportionRate.multiply(sourceBillItem.getInnerPrepayAmountWithTax()).setScale(6, 4);
        BigDecimal innerPrepayAmountWithoutTax = apportionRate.multiply(sourceBillItem.getInnerPrepayAmountWithoutTax()).setScale(6, 4);
        BigDecimal innerPrepayAmountTax = innerPrepayAmountWithTax.subtract(innerPrepayAmountWithoutTax);
        outSalesbillItem.setInnerPrepayAmountWithTax(innerPrepayAmountWithTax);
        outSalesbillItem.setInnerPrepayAmountWithoutTax(innerPrepayAmountWithoutTax);
        outSalesbillItem.setInnerPrepayAmountTax(innerPrepayAmountTax);
    }

    private void fillDeductionsField(OrdSalesbillItemEntity sourceBillItem, SalesbillItem outSalesbillItem, BigDecimal apportionRate) {
        BigDecimal deductions = apportionRate.multiply(sourceBillItem.getDeductions()).setScale(6, 4);
        outSalesbillItem.setDeductions(deductions);
    }
}

