/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.billitem;

import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.client.model.SplitBillItemPreviewRequest;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitByMoneyCalcType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitType;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitBaseValidator;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitMergeTools;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BillItemSplitByQuantityValidator
extends BillItemSplitBaseValidator {
    private static final Logger logger = LoggerFactory.getLogger(BillItemSplitByQuantityValidator.class);

    @Override
    public boolean validate(ValidatorContext context, SplitBillItemPreviewRequest request) {
        OrdSalesbillItemEntity sourceBillItem;
        OrdSalesbillEntity sourceOrdSalesbillEntity = (OrdSalesbillEntity)((Object)context.getAttribute("sourceOrdSalesbillEntity", OrdSalesbillEntity.class));
        Integer priceMethod = sourceOrdSalesbillEntity.getPriceMethod();
        Boolean checkResult = this.checkMustFieldsByQuantity(priceMethod, sourceBillItem = (OrdSalesbillItemEntity)((Object)context.getAttribute("sourceOrdSalesbillItemEntity", OrdSalesbillItemEntity.class)), request.getSalesbillItemSplitList(), context);
        if (!checkResult.booleanValue()) {
            return checkResult;
        }
        BillItemSplitMergeTools.derivationFields(priceMethod, request.getSalesbillItemSplitList(), sourceBillItem, BillItemSplitType.fromValue(request.getSplitType()), BillItemSplitByMoneyCalcType.fromValue(request.getSplitByCalcType()));
        this.apportionFieldsByFormula(sourceBillItem, request.getSalesbillItemSplitList(), BillItemSplitType.fromValue(request.getSplitType()), priceMethod);
        return true;
    }

    private boolean checkMustFieldsByQuantity(Integer priceMethod, OrdSalesbillItemEntity sourceBillItemEntity, List<SalesbillItem> targetSplitSalesbillItemList, ValidatorContext context) {
        ArrayList errorList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (SalesbillItem item : targetSplitSalesbillItemList) {
            BigDecimal sourceUnitPriceWithTax;
            BigDecimal itemUnitPriceWithTax;
            if (sourceBillItemEntity.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
                errorList.add("\u6309\u6570\u91cf\u62c6\u5206,\u539f\u5355\u636e\u660e\u7ec6\u3010\u6570\u91cf\u3011\u4e0d\u80fd\u662f0.");
            }
            int quantityPositiveOrNot = sourceBillItemEntity.getQuantity().compareTo(BigDecimal.ZERO);
            if (item.getQuantity().compareTo(BigDecimal.ZERO) != quantityPositiveOrNot) {
                errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u6570\u91cf\u3011\u6b63\u8d1f\u5fc5\u987b\u548c\u539f\u5355\u4fdd\u6301\u4e00\u81f4.");
            }
            if (item.getTaxRate().compareTo(sourceBillItemEntity.getTaxRate()) != 0) {
                errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u7a0e\u7387\u3011\u5fc5\u987b\u548c\u539f\u5355\u76f8\u7b49");
            }
            if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
                itemUnitPriceWithTax = item.getUnitPriceWithTax();
                sourceUnitPriceWithTax = sourceBillItemEntity.getUnitPriceWithTax();
                if (itemUnitPriceWithTax.setScale(6, 4).compareTo(sourceUnitPriceWithTax.setScale(6, 4)) != 0) {
                    errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u542b\u7a0e\u5355\u4ef7\u3011\u5fc5\u987b\u548c\u539f\u5355\u76f8\u7b49");
                }
            } else {
                itemUnitPriceWithTax = item.getUnitPrice();
                sourceUnitPriceWithTax = sourceBillItemEntity.getUnitPrice();
                if (itemUnitPriceWithTax.setScale(6, 4).compareTo(sourceUnitPriceWithTax.setScale(6, 4)) != 0) {
                    errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u4e0d\u542b\u7a0e\u5355\u4ef7\u3011\u5fc5\u987b\u548c\u539f\u5355\u76f8\u7b49");
                }
            }
            totalQuantity = totalQuantity.add(item.getQuantity());
        }
        BigDecimal compTotalQuantity = totalQuantity;
        BigDecimal sourceQuantity = sourceBillItemEntity.getQuantity();
        if (compTotalQuantity.setScale(6, 4).compareTo(sourceQuantity.setScale(6, 4)) != 0) {
            errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u6570\u91cf\u3011\u7d2f\u52a0\u548c\u5fc5\u987b\u4e0e\u539f\u5355\u76f8\u7b49");
        }
        if (errorList.size() > 0) {
            errorList.forEach(t -> context.addErrorMsg(t));
            return false;
        }
        return true;
    }
}

