/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.billitem;

import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitByMoneyCalcType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitType;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillItemSplitMergeTools {
    private static final Logger logger = LoggerFactory.getLogger(BillItemSplitMergeTools.class);

    public static List<SalesbillItem> derivationFields(Integer priceMethod, List<SalesbillItem> targetSalesbillItemList, OrdSalesbillItemEntity sourceBillItem, BillItemSplitType splitType, BillItemSplitByMoneyCalcType billItemSplitByMoneyCalcType) {
        for (SalesbillItem item : targetSalesbillItemList) {
            BigDecimal unitPrice;
            BigDecimal amountWithoutTax;
            BigDecimal taxAmount;
            BigDecimal amountWithTax;
            BigDecimal quantity;
            BigDecimal unitPriceWithTax;
            boolean clearResult;
            boolean filledResult = BillItemSplitMergeTools.fillDeductionsField(priceMethod, sourceBillItem, item, splitType);
            if (!filledResult || !(clearResult = BillItemSplitMergeTools.clearPriceAndQuantity(item, splitType, billItemSplitByMoneyCalcType))) continue;
            if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
                unitPriceWithTax = sourceBillItem.getUnitPriceWithTax();
                quantity = item.getQuantity();
                amountWithTax = unitPriceWithTax.multiply(quantity);
                taxAmount = amountWithTax.subtract(item.getDeductions()).multiply(sourceBillItem.getTaxRate()).divide(BigDecimal.ONE.add(sourceBillItem.getTaxRate()), 6, 4);
                amountWithoutTax = item.getAmountWithTax().subtract(taxAmount);
                unitPrice = amountWithoutTax.divide(item.getQuantity(), 15, 4);
                logger.info("WITH_TAX taxAmount:{}---amountWithoutTax:{}----amountWithTax:{}---unitPrice:{}---unitPriceWithTax:{}", new Object[]{taxAmount, amountWithoutTax, amountWithTax, unitPrice, unitPriceWithTax});
            } else {
                unitPrice = sourceBillItem.getUnitPrice();
                quantity = item.getQuantity();
                amountWithoutTax = quantity.multiply(unitPrice).setScale(6, 4);
                taxAmount = amountWithoutTax.subtract(item.getDeductions()).multiply(sourceBillItem.getTaxRate()).setScale(6, 4);
                amountWithTax = taxAmount.add(amountWithoutTax);
                unitPriceWithTax = amountWithTax.divide(item.getQuantity(), 15, 4);
                logger.info("WITHOUT_TAX unitPrice:{}---amountWithoutTax:{}----taxAmount:{}---amountWithTax:{}---unitPriceWithTax:{}", new Object[]{unitPrice, amountWithoutTax, taxAmount, amountWithTax, unitPriceWithTax});
            }
            item.setAmountWithoutTax(amountWithoutTax);
            item.setAmountWithTax(amountWithTax);
            item.setUnitPrice(unitPrice);
            item.setUnitPriceWithTax(unitPriceWithTax);
            item.setTaxAmount(taxAmount);
        }
        return targetSalesbillItemList;
    }

    public static BigDecimal getApportionRate(Integer priceMethod, OrdSalesbillItemEntity sourceBillItem, SalesbillItem outSalesbillItem, BillItemSplitType splitType) {
        BigDecimal apportionRate = BigDecimal.ZERO;
        if (splitType.value().equals(BillItemSplitType.SPLIT_BY_AMOUNT.value())) {
            apportionRate = outSalesbillItem.getQuantity().divide(sourceBillItem.getQuantity(), 16, 4);
        } else if (splitType.value().equals(BillItemSplitType.SPLIT_BY_MONEY.value())) {
            if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
                apportionRate = outSalesbillItem.getAmountWithTax().divide(sourceBillItem.getAmountWithTax(), 16, 4);
            } else if (BillItemPriceMethod.WITHOUT_TAX.value().equals(priceMethod)) {
                apportionRate = outSalesbillItem.getAmountWithoutTax().divide(sourceBillItem.getAmountWithoutTax(), 16, 4);
            } else {
                logger.info("\u5355\u636e\u660e\u7ec6\u8ba1\u7b97\u65b9\u5f0f\u53ea\u80fd\u662f \u542b\u7a0e\u65b9\u5f0f \u6216 \u4e0d\u542b\u7a0e\u65b9\u5f0f");
            }
        } else {
            logger.info("\u5355\u636e\u660e\u7ec6\u53ea\u80fd\u6309\u91d1\u989d\u62c6\u5206 \u6216 \u6309\u6570\u91cf\u62c6\u5206");
        }
        return apportionRate;
    }

    public static boolean fillDeductionsField(Integer priceMethod, OrdSalesbillItemEntity sourceBillItem, SalesbillItem outSalesbillItem, BillItemSplitType splitType) {
        BigDecimal apportionRate = BillItemSplitMergeTools.getApportionRate(priceMethod, sourceBillItem, outSalesbillItem, splitType);
        if (apportionRate.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        BigDecimal deductions = sourceBillItem.getDeductions().multiply(apportionRate).setScale(6, 4);
        outSalesbillItem.setDeductions(deductions);
        return true;
    }

    public static boolean clearPriceAndQuantity(SalesbillItem outSalesbillItem, BillItemSplitType splitType, BillItemSplitByMoneyCalcType billItemSplitByMoneyCalcType) {
        if (BillItemSplitType.SPLIT_BY_MONEY.value().equals(splitType.value()) && BillItemSplitByMoneyCalcType.CLEAN_QUANTITY$UNIT_PRICE.value().equals(billItemSplitByMoneyCalcType.value())) {
            outSalesbillItem.setUnitPrice(BigDecimal.ZERO);
            outSalesbillItem.setUnitPriceWithTax(BigDecimal.ZERO);
            outSalesbillItem.setQuantity(BigDecimal.ZERO);
            return false;
        }
        return true;
    }
}

