/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.datadictionnary;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.cache.LocalCacheManager;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.constant.enums.FieldGroupIndex;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtBean;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.MetaDataUtils;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesBillDataDictionaryValidator
extends ValidatorHandler<OrdSalesbillInterfaceEntity>
implements Validator<OrdSalesbillInterfaceEntity> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private LocalConfigMetadataCacheManager localConfigMetadataCacheManager;
    @Autowired
    private LocalCacheManager localCacheManager;
    @Autowired
    private LocalConfigMetadataCacheManager metadataCacheManager;

    public boolean accept(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        return true;
    }

    public void onException(Exception e, ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        context.addErrorMsg(e.getMessage());
    }

    public boolean validate(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        this.logger.info("======================SalesBillDataDictionaryValidator-\u5355\u636e\u53f7-{}==============================", (Object)ordSalesbillInterfaceEntity.getSalesbillNo());
        List<String> fields = this.localCacheManager.getTableFieldNameCache((Object)new OrdSalesbillInterfaceEntity());
        long groupId = (Long)context.getAttribute("groupId");
        String salesbillType = ordSalesbillInterfaceEntity.getSalesbillType();
        String validType = (String)context.getAttribute("validateType");
        boolean autoSplitPreInvoice = false;
        ConfigRequestModel configRequestModel = new ConfigRequestModel();
        BeanUtils.copyProperties((Object)ordSalesbillInterfaceEntity, configRequestModel);
        SysConfigExtBean sysConfigExtBean = this.metadataCacheManager.querySysInfoConfig(configRequestModel, ConfigTypeEnum.SYS_CONFIG_TYPE);
        if (sysConfigExtBean != null && sysConfigExtBean.getAutoSplitBillPreInvoice() != null) {
            autoSplitPreInvoice = sysConfigExtBean.getAutoSplitBillPreInvoice();
        }
        Map map = Maps.newHashMap();
        if (ValidateType.IMPORT.value().equals(validType) && !autoSplitPreInvoice) {
            this.logger.info("localConfigMetadataCacheManager.queryEffctiveMetaData------groupId:{},objCode:{}, salesbillType:{}", new Object[]{groupId, ObjCodeEnum.BILL.getObjCode(), salesbillType});
            map = this.localConfigMetadataCacheManager.queryEffctiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesbillType);
        } else {
            this.logger.info("localConfigMetadataCacheManager.queryEffctiveMetaData------groupId:{},objCode:{}, salesbillType:{}", new Object[]{groupId, ObjCodeEnum.BILL.getObjCode(), ""});
            map = this.localConfigMetadataCacheManager.queryEffctiveMetaData(groupId, ObjCodeEnum.INVOICINGROLE.getObjCode(), "");
        }
        String msg = MetaDataUtils.checkFieldByMetadata(map, fields, (Object)ordSalesbillInterfaceEntity, FieldGroupIndex.BILL.value());
        context.addErrorMsg(msg);
        return CommonTools.isEmpty(msg.toString());
    }
}

