/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.discount;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.xforceplus.phoenix.bill.core.impl.discount.domain.ProductItem;
import com.xforceplus.phoenix.bill.exception.DiscountHandleException;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BillItemDiscountValidator
extends ValidatorHandler<List<OrdSalesbillInterfaceItemEntity>>
implements Validator<List<OrdSalesbillInterfaceItemEntity>> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean accept(ValidatorContext context, List<OrdSalesbillInterfaceItemEntity> productItems) {
        return true;
    }

    public void onException(Exception e, ValidatorContext context, List<OrdSalesbillInterfaceItemEntity> productItems) {
    }

    public boolean validate(ValidatorContext context, List<OrdSalesbillInterfaceItemEntity> productItems) {
        for (OrdSalesbillInterfaceItemEntity item : productItems) {
            boolean checkItem = this.checkProductItem(context, item);
            if (checkItem) continue;
            return false;
        }
        return true;
    }

    private boolean checkProductItem(ValidatorContext context, OrdSalesbillInterfaceItemEntity item) {
        try {
            CommonTools.zeroBigDecimalFields((Object)item, ProductItem.class);
        }
        catch (IllegalAccessException e) {
            String msg = "\u53c2\u6570\u9519\u8bef\uff01";
            this.logger.error(msg, (Throwable)e);
            throw new DiscountHandleException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "\u6ca1\u6709\u8be5\u65b9\u6cd5";
            this.logger.error(msg, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "\u8c03\u7528\u51fa\u9519\uff01";
            this.logger.error(msg, (Throwable)e);
        }
        if (CommonTools.isEmpty(String.valueOf(item.getSalesbillItemId()))) {
            context.addErrorMsg(String.format("\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a!,\u660e\u7ec6\u7f16\u53f7: %s", item.getSalesbillItemId()));
            return false;
        }
        if (item.getAmountWithTax() == null || item.getAmountWithTax().compareTo(BigDecimal.ZERO) == 0) {
            context.addErrorMsg(String.format("\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u96f6!,\u660e\u7ec6\u7f16\u53f7: %s \u542b\u7a0e\u91d1\u989d %s", item.getSalesbillItemId(), item.getAmountWithTax()));
            return false;
        }
        if (item.getAmountWithoutTax() == null || item.getAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0) {
            context.addErrorMsg(String.format("\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u96f6!,\u660e\u7ec6\u7f16\u53f7: %s \u4e0d\u542b\u7a0e\u91d1\u989d %s", item.getSalesbillItemId(), item.getAmountWithoutTax()));
            return false;
        }
        if (item.getTaxRate() == null || item.getTaxRate().compareTo(BigDecimal.ZERO) < 0 || item.getTaxRate().compareTo(BigDecimal.ONE) >= 0) {
            context.addErrorMsg(String.format("\u660e\u7ec6\u7a0e\u7387\u5fc5\u987b\u4e3a0\u52301\u4e4b\u95f4\uff0c\u660e\u7ec6\u7f16\u53f7:%s \u660e\u7ec6\u7a0e\u7387: %s", item.getSalesbillItemId(), item.getTaxRate()));
            return false;
        }
        if (item.getAmountWithTax().subtract(Optional.ofNullable(item.getOutterDiscountWithTax()).orElse(BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) < 0) {
            context.addErrorMsg(String.format("\u6298\u6263\u540e\u5546\u54c1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u660e\u7ec6\u7f16\u53f7: %s", item.getSalesbillItemId()));
            return false;
        }
        if (item.getAmountWithoutTax().subtract(Optional.ofNullable(item.getOutterDiscountWithoutTax()).orElse(BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) < 0) {
            context.addErrorMsg(String.format("\u6298\u6263\u540e\u5546\u54c1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u660e\u7ec6\u7f16\u53f7: %s", item.getSalesbillItemId()));
            return false;
        }
        if (item.getTaxAmount().subtract(Optional.ofNullable(item.getOutterDiscountTax()).orElse(BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) < 0) {
            context.addErrorMsg(String.format("\u6298\u6263\u540e\u5546\u54c1\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u660e\u7ec6\u7f16\u53f7: %s", item.getSalesbillItemId()));
            return false;
        }
        return true;
    }
}

