/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.discount;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.phoenix.bill.client.model.DiscountRequest;
import com.xforceplus.phoenix.bill.client.model.ProductItem;
import com.xforceplus.phoenix.bill.client.model.ProductMainDiscount;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillManualDiscountValidator
extends ValidatorHandler<DiscountRequest>
implements Validator<DiscountRequest> {
    private static final String[] DISPLAY_WITH_TAX_NAMES = new String[]{"\u3010\u4ef7\u5185\u542b\u7a0e\u6298\u6263\u91d1\u989d\u3011", "\u3010\u4ef7\u5916\u542b\u7a0e\u6298\u6263\u91d1\u989d\u3011", "\u3010\u4ef7\u5185\u9884\u4ed8\u5361\u542b\u7a0e\u91d1\u989d\u3011", "\u3010\u4ef7\u5916\u9884\u4ed8\u5361\u542b\u7a0e\u91d1\u989d\u3011"};
    private static final String[] DISPLAY_WITHOUT_TAX_NAMES = new String[]{"\u3010\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d\u3011", "\u3010\u4ef7\u5916\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d\u3011", "\u3010\u4ef7\u5185\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u91d1\u989d\u3011", "\u3010\u4ef7\u5916\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u91d1\u989d\u3011"};
    private OrdSalesbillItemDao ordSalesbillItemDao;

    @Autowired
    public BillManualDiscountValidator(OrdSalesbillItemDao ordSalesbillItemDao) {
        this.ordSalesbillItemDao = ordSalesbillItemDao;
    }

    public boolean accept(ValidatorContext validatorContext, DiscountRequest discountRequest) {
        return true;
    }

    public boolean validate(ValidatorContext context, DiscountRequest discountRequest) {
        OrdSalesbillEntity dbBillEntity = (OrdSalesbillEntity)((Object)context.getAttribute("dbOrdSalesbillEntity", OrdSalesbillEntity.class));
        List dbBillItemEntityList = (List)context.getAttribute("dbOrdSalesbillItemEntityList", List.class);
        Integer priceMethod = dbBillEntity.getPriceMethod();
        BigDecimal[] dbHeaderDiscountTax = this.getHeaderDiscountTax(dbBillEntity, priceMethod);
        BigDecimal[] dbItemsDiscountTax = this.getTotalDiscountTaxItemList(dbBillItemEntityList, priceMethod);
        BigDecimal[] dbTotalDiscountTax = this.addDiscountTaxFields(dbHeaderDiscountTax, dbItemsDiscountTax);
        ProductMainDiscount productMainDiscount = discountRequest.getMainDiscount();
        List productItemList = discountRequest.getItemList();
        for (ProductItem productItem2 : productItemList) {
            if (productItem2.getTaxRate().compareTo(((OrdSalesbillItemEntity)((Object)dbBillItemEntityList.get(0))).getTaxRate()) == 0) continue;
            context.addErrorMsg("\u5206\u644a\u540e\u7684\u5355\u636e\u660e\u7ec6\u7a0e\u7387\u4e0e\u5206\u644a\u524d\u660e\u7ec6\u4e0d\u4e00\u81f4.");
            return false;
        }
        OrdSalesbillEntity productMainHeader = new OrdSalesbillEntity();
        CommonTools.copyProperties(productMainDiscount, (Object)productMainHeader);
        BigDecimal[] afterHeaderDiscountTax = this.getHeaderDiscountTax(productMainHeader, priceMethod);
        List<OrdSalesbillItemEntity> productItemEntityList = productItemList.stream().map(productItem -> {
            OrdSalesbillItemEntity item = new OrdSalesbillItemEntity();
            CommonTools.copyProperties(productItem, (Object)item);
            return item;
        }).collect(Collectors.toList());
        BigDecimal[] afterProductItemDiscountTax = this.getTotalDiscountTaxItemList(productItemEntityList, priceMethod);
        BigDecimal[] afterChangeDiscountTax = this.addDiscountTaxFields(afterHeaderDiscountTax, afterProductItemDiscountTax);
        if (!this.equalDiscountFieldsCheck(context, dbTotalDiscountTax, afterChangeDiscountTax, priceMethod)) {
            return false;
        }
        boolean checkResult = this.discountTaxHorizontalFieldsCheck(context, productItemList, priceMethod);
        if (!checkResult) {
            return false;
        }
        checkResult = this.discountTaxPortraitColumnsCheck(context, productMainDiscount, dbBillEntity, priceMethod);
        if (!checkResult) {
            return false;
        }
        HashSet salesbillItemIdSet = Sets.newHashSet();
        dbBillItemEntityList.stream().forEach(item -> salesbillItemIdSet.add(item.getSalesbillItemId()));
        List<OrdSalesbillItemEntity> ordSalesbillItemEntityList = this.getOrdSalesbillItemEntityByField(dbBillEntity.getSalesbillId(), salesbillItemIdSet, priceMethod);
        checkResult = this.remainingDiscountTaxCheck(context, productMainDiscount, ordSalesbillItemEntityList, priceMethod);
        return checkResult;
    }

    public void onException(Exception e, ValidatorContext context, DiscountRequest discountRequest) {
    }

    private BigDecimal[] getHeaderDiscountTax(OrdSalesbillEntity billEntity, Integer priceMethod) {
        BigDecimal[] itemDiscountTax = new BigDecimal[]{billEntity.getInnerDiscountWithoutTax(), billEntity.getOutterDiscountWithoutTax(), billEntity.getInnerPrepayAmountWithoutTax(), billEntity.getOutterPrepayAmountWithoutTax()};
        if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
            itemDiscountTax[0] = billEntity.getInnerDiscountWithTax();
            itemDiscountTax[1] = billEntity.getOutterDiscountWithTax();
            itemDiscountTax[2] = billEntity.getInnerPrepayAmountWithTax();
            itemDiscountTax[3] = billEntity.getOutterPrepayAmountWithTax();
        }
        return itemDiscountTax;
    }

    private BigDecimal[] getTotalDiscountTaxItemList(List<OrdSalesbillItemEntity> billItemEntityList, int priceMethod) {
        BigDecimal[] totalDiscountTax = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        for (OrdSalesbillItemEntity ordSalesbillItemEntity : billItemEntityList) {
            OrdSalesbillEntity billEntity = new OrdSalesbillEntity();
            CommonTools.copyProperties((Object)ordSalesbillItemEntity, (Object)billEntity);
            BigDecimal[] discountTax = this.getHeaderDiscountTax(billEntity, priceMethod);
            totalDiscountTax = this.addDiscountTaxFields(totalDiscountTax, discountTax);
        }
        return totalDiscountTax;
    }

    private BigDecimal[] addDiscountTaxFields(BigDecimal[] headerDiscountTax, BigDecimal[] itemDiscountTax) {
        headerDiscountTax[0] = headerDiscountTax[0].add(itemDiscountTax[0]);
        headerDiscountTax[1] = headerDiscountTax[1].add(itemDiscountTax[1]);
        headerDiscountTax[2] = headerDiscountTax[2].add(itemDiscountTax[2]);
        headerDiscountTax[3] = headerDiscountTax[3].add(itemDiscountTax[3]);
        return headerDiscountTax;
    }

    private boolean equalDiscountFieldsCheck(ValidatorContext context, BigDecimal[] dbDiscountTax, BigDecimal[] afterDiscountTax, Integer priceMethod) {
        for (int i = 0; i < dbDiscountTax.length; ++i) {
            if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
                if (dbDiscountTax[i].compareTo(afterDiscountTax[i]) == 0) continue;
                context.addErrorMsg(String.format("%s\u8c03\u6574\u524d\u540e\u7d2f\u8ba1\u548c\u4e0d\u4e00\u81f4.", DISPLAY_WITH_TAX_NAMES[i]));
                return false;
            }
            if (dbDiscountTax[i].compareTo(afterDiscountTax[i]) == 0) continue;
            context.addErrorMsg(String.format("%s\u8c03\u6574\u524d\u540e\u7d2f\u8ba1\u548c\u4e0d\u4e00\u81f4.", DISPLAY_WITHOUT_TAX_NAMES[i]));
            return false;
        }
        return true;
    }

    private boolean discountTaxHorizontalFieldsCheck(ValidatorContext context, List<ProductItem> productItemList, Integer priceMethod) {
        for (ProductItem productItem : productItemList) {
            if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
                BigDecimal totalDiscountWithTax = productItem.getInnerDiscountWithTax().add(productItem.getOutterDiscountWithTax()).add(productItem.getInnerPrepayAmountWithTax()).add(productItem.getOutterPrepayAmountWithTax());
                if (productItem.getAmountWithTax().subtract(totalDiscountWithTax).compareTo(BigDecimal.ZERO) >= 0) continue;
                context.addErrorMsg(String.format("\u5355\u636e\u660e\u7ec6\u3010%s\u3011\u3010\u542b\u7a0e\u91d1\u989d\u3011-\u3010\u542b\u7a0e\u6298\u6263\u91d1\u989d\u3011\u7d2f\u52a0\u548c\u4e0d\u80fd\u5c0f\u4e8e0.", productItem.getSalesbillItemId()));
                return false;
            }
            BigDecimal totalDiscountWithoutTax = productItem.getInnerDiscountWithoutTax().add(productItem.getOutterDiscountWithoutTax()).add(productItem.getInnerPrepayAmountWithoutTax()).add(productItem.getOutterPrepayAmountWithoutTax());
            if (productItem.getAmountWithoutTax().subtract(totalDiscountWithoutTax).compareTo(BigDecimal.ZERO) >= 0) continue;
            context.addErrorMsg(String.format("\u5355\u636e\u660e\u7ec6\u3010%s\u3011\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011-\u3010\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d\u3011\u7d2f\u52a0\u548c\u4e0d\u80fd\u5c0f\u4e8e0.", productItem.getSalesbillItemId()));
            return false;
        }
        return true;
    }

    private boolean discountTaxPortraitColumnsCheck(ValidatorContext context, ProductMainDiscount productMainDiscount, OrdSalesbillEntity dbBillEntity, Integer priceMethod) {
        boolean checkResult;
        return !(BillItemPriceMethod.WITH_TAX.value().equals(priceMethod) ? (productMainDiscount.getInnerDiscountWithTax().compareTo(dbBillEntity.getInnerDiscountWithTax()) > 0 ? !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getInnerDiscountWithTax(), "InnerDiscountWithTax", priceMethod)) : (productMainDiscount.getOutterDiscountWithTax().compareTo(dbBillEntity.getOutterDiscountWithTax()) > 0 ? !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getOutterDiscountWithTax(), "OutterDiscountWithTax", priceMethod)) : (productMainDiscount.getInnerPrepayAmountWithTax().compareTo(dbBillEntity.getInnerPrepayAmountWithTax()) > 0 ? !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getInnerPrepayAmountWithTax(), "InnerPrepayAmountWithTax", priceMethod)) : productMainDiscount.getOutterPrepayAmountWithTax().compareTo(dbBillEntity.getOutterPrepayAmountWithTax()) > 0 && !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getOutterPrepayAmountWithTax(), "OutterPrepayAmountWithTax", priceMethod))))) : (productMainDiscount.getInnerDiscountWithoutTax().compareTo(dbBillEntity.getInnerDiscountWithoutTax()) > 0 ? !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getInnerDiscountWithoutTax(), "InnerDiscountWithoutTax", priceMethod)) : (productMainDiscount.getOutterDiscountWithoutTax().compareTo(dbBillEntity.getOutterDiscountWithoutTax()) > 0 ? !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getOutterDiscountWithoutTax(), "OutterDiscountWithoutTax", priceMethod)) : (productMainDiscount.getInnerPrepayAmountWithoutTax().compareTo(dbBillEntity.getInnerPrepayAmountWithoutTax()) > 0 ? !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getInnerPrepayAmountWithoutTax(), "InnerPrepayAmountWithoutTax", priceMethod)) : productMainDiscount.getOutterPrepayAmountWithoutTax().compareTo(dbBillEntity.getOutterPrepayAmountWithoutTax()) > 0 && !(checkResult = this.sumDiscountColumnFieldCheck(context, dbBillEntity.getSalesbillId(), productMainDiscount.getOutterPrepayAmountWithoutTax(), "OutterPrepayAmountWithoutTax", priceMethod))))));
    }

    private boolean sumDiscountColumnFieldCheck(ValidatorContext context, Long salesbillId, BigDecimal discountAmount, String fieldName, int priceMethod) {
        List<OrdSalesbillItemEntity> ordSalesbillItemEntityList = this.getOrdSalesbillItemEntityByField(salesbillId, fieldName);
        if (CollectionUtils.isEmpty(ordSalesbillItemEntityList)) {
            context.addErrorMsg(String.format("\u624b\u52a8\u5206\u644a\u5931\u8d25\uff1a\u5355\u636e\u3010%s\u3011\u3010%s\u3011\u5206\u644a\u5b8c\u6bd5\uff0c\u5f85\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0.", salesbillId, fieldName));
            return false;
        }
        BigDecimal totalAmountTax = BigDecimal.ZERO;
        if (BillItemPriceMethod.WITH_TAX.value() == priceMethod) {
            for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
                totalAmountTax = totalAmountTax.add(itemEntity.getAmountWithTax());
            }
        } else {
            for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
                totalAmountTax = totalAmountTax.add(itemEntity.getAmountWithoutTax());
            }
        }
        if (totalAmountTax.compareTo(discountAmount) < 0) {
            context.addErrorMsg(String.format("\u624b\u52a8\u5206\u644a\u5931\u8d25\uff1a\u5355\u636e\u3010%s\u3011\u3010%s\u3011\u672a\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u5206\u644a\u660e\u3010%s\u3011\u7d2f\u52a0\u548c", salesbillId, fieldName, BillItemPriceMethod.WITH_TAX.value() == priceMethod ? "\u542b\u7a0e\u91d1\u989d" : "\u4e0d\u542b\u7a0e\u91d1\u989d"));
            return false;
        }
        return true;
    }

    private List<OrdSalesbillItemEntity> getOrdSalesbillItemEntityByField(Long salesBillId, String field) {
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillIdEqualTo(salesBillId);
        switch (field) {
            case "InnerDiscountWithTax": {
                criteria.andInnerDiscountWithTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            case "OutterDiscountWithTax": {
                criteria.andOutterDiscountWithTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            case "InnerPrepayAmountWithTax": {
                criteria.andInnerPrepayAmountWithTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            case "OutterPrepayAmountWithTax": {
                criteria.andOutterPrepayAmountWithTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            case "InnerDiscountWithoutTax": {
                criteria.andInnerDiscountWithoutTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            case "OutterDiscountWithoutTax": {
                criteria.andOutterDiscountWithoutTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            case "InnerPrepayAmountWithoutTax": {
                criteria.andInnerPrepayAmountWithoutTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            case "OutterPrepayAmountWithoutTax": {
                criteria.andOutterPrepayAmountWithoutTaxEqualTo(BigDecimal.ZERO);
                break;
            }
            default: {
                throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u6298\u6263\u5217\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6");
            }
        }
        return this.ordSalesbillItemDao.selectByExample(ordSalesbillItemExample);
    }

    private List<OrdSalesbillItemEntity> getOrdSalesbillItemEntityByField(Long salesBillId, HashSet<Long> salesbillItemIdSet, Integer priceMethod) {
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillIdEqualTo(salesBillId);
        criteria.andStatusEqualTo(BillItemStatus.NORMAL.value());
        List<OrdSalesbillItemEntity> itemEntityList = this.ordSalesbillItemDao.selectByExample(ordSalesbillItemExample);
        List<Object> withTaxOrNotItemEntityList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(itemEntityList)) {
            withTaxOrNotItemEntityList = BillItemPriceMethod.WITH_TAX.value().equals(priceMethod) ? itemEntityList.stream().filter(item -> (item.getInnerDiscountWithTax().compareTo(BigDecimal.ZERO) == 0 || item.getOutterDiscountWithTax().compareTo(BigDecimal.ZERO) == 0 || item.getInnerPrepayAmountWithTax().compareTo(BigDecimal.ZERO) == 0 || item.getInnerPrepayAmountWithTax().compareTo(BigDecimal.ZERO) == 0) && !salesbillItemIdSet.contains(item.getSalesbillItemId())).collect(Collectors.toList()) : itemEntityList.stream().filter(item -> (item.getInnerDiscountWithoutTax().compareTo(BigDecimal.ZERO) == 0 || item.getOutterDiscountWithoutTax().compareTo(BigDecimal.ZERO) == 0 || item.getInnerPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0 || item.getOutterPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0) && !salesbillItemIdSet.contains(item.getSalesbillItemId())).collect(Collectors.toList());
        }
        return withTaxOrNotItemEntityList;
    }

    private boolean remainingDiscountTaxCheck(ValidatorContext context, ProductMainDiscount productMainDiscount, List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, int priceMethod) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal discountAmountTotal = BigDecimal.ZERO;
        if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getInnerDiscountWithTax());
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getOutterDiscountWithTax());
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getInnerPrepayAmountWithTax());
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getOutterPrepayAmountWithTax());
            for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
                totalAmount = totalAmount.add(itemEntity.getAmountWithTax());
                totalAmount = totalAmount.subtract(itemEntity.getInnerDiscountWithTax());
                totalAmount = totalAmount.subtract(itemEntity.getOutterDiscountWithTax());
                totalAmount = totalAmount.subtract(itemEntity.getInnerPrepayAmountWithTax());
                totalAmount = totalAmount.subtract(itemEntity.getOutterPrepayAmountWithTax());
            }
        } else {
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getInnerDiscountWithoutTax());
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getOutterDiscountWithoutTax());
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getInnerPrepayAmountWithoutTax());
            discountAmountTotal = discountAmountTotal.add(productMainDiscount.getOutterPrepayAmountWithoutTax());
            for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
                totalAmount = totalAmount.add(itemEntity.getAmountWithoutTax());
                totalAmount = totalAmount.subtract(itemEntity.getInnerDiscountWithoutTax());
                totalAmount = totalAmount.subtract(itemEntity.getOutterDiscountWithoutTax());
                totalAmount = totalAmount.subtract(itemEntity.getInnerPrepayAmountWithoutTax());
                totalAmount = totalAmount.subtract(itemEntity.getOutterPrepayAmountWithoutTax());
            }
        }
        if (discountAmountTotal.compareTo(totalAmount) > 0) {
            context.addErrorMsg(String.format("\u672a\u644a\u660e\u7ec6\u3010\u542b\u7a0e\u91d1\u989d\u3011\u7d2f\u52a0\u548c \u4e0d\u80fd\u5c0f\u4e8e \u5355\u636e\u672a\u644a\u3010%s\u3011\u3010%s\u6298\u6263\u91d1\u989d\u3011\u7d2f\u52a0\u548c.", productMainDiscount.getSalesbillId(), BillItemPriceMethod.WITH_TAX.value().equals(priceMethod) ? "\u542b\u7a0e" : "\u4e0d\u542b\u7a0e"));
            return false;
        }
        return true;
    }
}

