/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.job;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.makeout.SplitAndMakeOutInvoiceClient;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceMakeOutMode;
import com.xforceplus.phoenix.bill.core.impl.domain.BatchMakePreviewInvoiceInfo;
import com.xforceplus.phoenix.bill.core.impl.domain.BatchNoMergeInfo;
import com.xforceplus.phoenix.bill.core.impl.upload.tools.MakePreInvoiceTools;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillOperateDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillQueryDao;
import com.xforceplus.phoenix.bill.repository.model.OrdAutoSplitPreinvoiceInterfaceEntity;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.invoice.client.model.MsSplitAndMakeOutParams;
import com.xforceplus.seller.invoice.client.model.MsSplitAndMakeOutRequest;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@JobHandler(value="autoSplitPreInvoiceJob")
@Service
public class AutoSplitPreInvoiceJob
extends IJobHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SalesBillQueryDao queryDao;
    private MakePreInvoiceTools makePreInvoiceTools;
    private IDGenerator idGenerator;
    private SplitAndMakeOutInvoiceClient splitAndMakeOutInvoiceClient;
    private SalesBillOperateDao operateDao;

    @Autowired
    public AutoSplitPreInvoiceJob(SalesBillQueryDao queryDao, MakePreInvoiceTools makePreInvoiceTools, IDGenerator idGenerator, SplitAndMakeOutInvoiceClient splitAndMakeOutInvoiceClient, SalesBillOperateDao operateDao) {
        this.queryDao = queryDao;
        this.makePreInvoiceTools = makePreInvoiceTools;
        this.idGenerator = idGenerator;
        this.splitAndMakeOutInvoiceClient = splitAndMakeOutInvoiceClient;
        this.operateDao = operateDao;
    }

    public ReturnT<String> execute(String s) throws Exception {
        MsSplitAndMakeOutParams params;
        List<OrdAutoSplitPreinvoiceInterfaceEntity> failSplitPreInvoice = this.queryDao.getFailSplitPreInvoice();
        if (CommonTools.isEmpty(failSplitPreInvoice)) {
            return new ReturnT((Object)"\u6ca1\u6709\u8981\u5904\u7406\u7684\u6570\u636e");
        }
        List<Long> failAutoSplitPreInvoiceIds = failSplitPreInvoice.stream().map(t -> t.getId()).collect(Collectors.toList());
        List<Long> noAlreadySplitPreInvoiceIds = this.queryDao.getNoAlreadySplitPreInvoice(failAutoSplitPreInvoiceIds);
        ArrayList paramList = Lists.newArrayList();
        ArrayList previewInvoiceInfos = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < failSplitPreInvoice.size(); ++i) {
            OrdAutoSplitPreinvoiceInterfaceEntity entity = failSplitPreInvoice.get(i);
            if (!noAlreadySplitPreInvoiceIds.contains(entity.getId())) continue;
            params = new MsSplitAndMakeOutParams();
            BeanUtils.copyProperties((Object)entity, params);
            long batchNo = this.idGenerator.nextId();
            params.setBatchNo(Long.valueOf(batchNo));
            params.setMode(String.valueOf(InvoiceMakeOutMode.PRE_MAKEOUT.value()));
            paramList.add(params);
            map.put(batchNo, entity.getId());
            BatchMakePreviewInvoiceInfo info = new BatchMakePreviewInvoiceInfo();
            BatchNoMergeInfo batchNoMergeInfo = new BatchNoMergeInfo();
            batchNoMergeInfo.setBatchNo(batchNo);
            batchNoMergeInfo.setMerge(false);
            info.setBatchNoMergeInfo(batchNoMergeInfo);
            info.setRuleId(entity.getRuleId());
            info.setSalesbillId(entity.getId());
            previewInvoiceInfos.add(info);
        }
        try {
            failAutoSplitPreInvoiceIds.removeAll(noAlreadySplitPreInvoiceIds);
            this.makePreInvoiceTools.updateItemBatchNo(previewInvoiceInfos);
            ArrayList removeBatchNoInfos = Lists.newArrayList();
            for (int i = 0; i < paramList.size(); ++i) {
                params = (MsSplitAndMakeOutParams)paramList.get(i);
                Long id = (Long)map.get(params.getBatchNo());
                MsSplitAndMakeOutRequest msSplitAndMakeOutRequest = new MsSplitAndMakeOutRequest();
                msSplitAndMakeOutRequest.setParamList(Arrays.asList(params));
                try {
                    BaseAsyncResponse baseAsyncResponse = this.splitAndMakeOutInvoiceClient.makeOut(msSplitAndMakeOutRequest);
                    if (!BaseResponse.OK.equals(baseAsyncResponse.getCode())) continue;
                    failAutoSplitPreInvoiceIds.add(id);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("\u53d1\u9001\u62c6\u7968\u6d88\u606f\u5931\u8d25", (Throwable)e);
                    BatchMakePreviewInvoiceInfo info = new BatchMakePreviewInvoiceInfo();
                    BatchNoMergeInfo batchNoMergeInfo = new BatchNoMergeInfo();
                    batchNoMergeInfo.setBatchNo(0L);
                    batchNoMergeInfo.setMerge(false);
                    info.setBatchNoMergeInfo(batchNoMergeInfo);
                    info.setRuleId(0L);
                    info.setSalesbillId(id);
                    removeBatchNoInfos.add(info);
                }
            }
            if (!CommonTools.isEmpty(removeBatchNoInfos)) {
                this.makePreInvoiceTools.updateItemBatchNo(removeBatchNoInfos);
            }
        }
        catch (Exception e) {
            this.logger.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        if (!CommonTools.isEmpty(failAutoSplitPreInvoiceIds)) {
            this.operateDao.deleteAutoSplitPreInvoice(failAutoSplitPreInvoiceIds);
        }
        return new ReturnT((Object)"\u5904\u7406\u6210\u529f");
    }
}

