/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.job;

import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.core.service.CooperationService;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@JobHandler(value="sendCooperationBillJob")
@Service
public class SendCooperationBillJob
extends IJobHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private OrdSalesbillDao ordSalesbillDao;
    private OrdSalesbillItemDao ordSalesbillItemDao;
    private CooperationService cooperationService;

    @Autowired
    public SendCooperationBillJob(OrdSalesbillDao ordSalesbillDao, OrdSalesbillItemDao ordSalesbillItemDao, CooperationService cooperationService) {
        this.ordSalesbillDao = ordSalesbillDao;
        this.ordSalesbillItemDao = ordSalesbillItemDao;
        this.cooperationService = cooperationService;
    }

    public ReturnT<String> execute(String s) throws Exception {
        this.logger.info("\u5b9a\u65f6\u53d1\u9001\u534f\u540c\u4e1a\u52a1\u5355{}-----------", (Object)s);
        if (s != null) {
            OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
            ordSalesbillExample.createCriteria().andSalesbillNoEqualTo(s.trim());
            List<OrdSalesbillEntity> ordSalesbillEntityList = this.ordSalesbillDao.selectByExample(ordSalesbillExample);
            if (ordSalesbillEntityList.size() > 0) {
                OrdSalesbillEntity ordSalesbillEntity = ordSalesbillEntityList.get(0);
                OrdSalesbillItemExample itemExample = new OrdSalesbillItemExample();
                itemExample.createCriteria().andSalesbillNoEqualTo(s.trim());
                List<OrdSalesbillItemEntity> itemEntityList = this.ordSalesbillItemDao.selectByExample(itemExample);
                HashMap<String, Object> headers = new HashMap<String, Object>();
                headers.put("systemOrig", ordSalesbillEntity.getSystemOrig());
                headers.put("businessBillType", ordSalesbillEntity.getBusinessBillType());
                headers.put("status", "1");
                headers.put("customNo", ordSalesbillEntity.getCustomerNo());
                headers.put("userId", String.valueOf(ordSalesbillEntity.getCreateUser()));
                if (BusinessBillType.AR.value().equals(ordSalesbillEntity.getBusinessBillType())) {
                    headers.put("groupId", String.valueOf(ordSalesbillEntity.getSellerGroupId()));
                } else {
                    headers.put("groupId", String.valueOf(ordSalesbillEntity.getPurchaserGroupId()));
                }
                this.cooperationService.sendSalesbill(ordSalesbillEntityList, itemEntityList, headers);
            } else {
                this.logger.info("---------\u6839\u636e\u4e1a\u52a1\u5355\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u4e1a\u52a1\u5355----------\u5355\u53f7:{}", (Object)s);
            }
        } else {
            this.logger.info("---------\u4e1a\u52a1\u5355\u53f7\u4e3a\u7a7a----------");
        }
        return new ReturnT((Object)"\u5904\u7406\u6210\u529f");
    }
}

