/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.model.BillMainInfo;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.GetBillDetailInfoRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleRequest;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.SalesbillInfo;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.constant.enums.UserRole;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.core.service.BillValidateService;
import com.xforceplus.phoenix.bill.core.tools.BillSearchTools;
import com.xforceplus.phoenix.bill.manager.domian.PageData;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSalesbillExtDao;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSalesbillItemExtDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillExtExample;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillItemExtBatchNoUpdate;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillItemExtExample;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesbillItemExtQueryItemIdByBillId;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.xplatframework.model.Response;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SalesbillManager {
    private static final Logger logger = LoggerFactory.getLogger(SalesbillManager.class);
    public static final String SALESBILL_LIST_KEY = "ORD_SALESBILL_ENTITY_LIST";
    public static final String SALESBILL_ITEM_LIST_KEY = "ORD_SALESBILL_ITEM_ENTITY_LIST";
    private OrdSalesbillItemDao ordSalesbillItemDao;
    private OrdSalesbillDao ordSalesbillDao;
    private OrdSalesbillExtDao ordSalesbillExtDao;
    private OrdSalesbillItemExtDao ordSalesbillItemExtDao;
    private BillValidateService billValidateService;

    @Autowired
    public SalesbillManager(OrdSalesbillItemDao ordSalesbillItemDao, OrdSalesbillDao ordSalesbillDao, OrdSalesbillExtDao ordSalesbillExtDao, OrdSalesbillItemExtDao ordSalesbillItemExtDao, BillValidateService billValidateService) {
        this.ordSalesbillItemDao = ordSalesbillItemDao;
        this.ordSalesbillDao = ordSalesbillDao;
        this.ordSalesbillExtDao = ordSalesbillExtDao;
        this.ordSalesbillItemExtDao = ordSalesbillItemExtDao;
        this.billValidateService = billValidateService;
    }

    public PageData<List<OrdSalesbillItemEntity>> querySalesBillItemPage(long salesbillId, GetBillDetailInfoRequest getBillDetailInfoRequest) {
        OrdSalesbillItemExample example = new OrdSalesbillItemExample();
        example.createCriteria().andSalesbillIdEqualTo(salesbillId);
        long count = this.ordSalesbillItemDao.countByExample(example);
        int pageNo = getBillDetailInfoRequest.getPageNo() == null ? 1 : getBillDetailInfoRequest.getPageNo();
        int pageSize = getBillDetailInfoRequest.getPageSize() == null ? 20 : getBillDetailInfoRequest.getPageSize();
        example.setLimit(pageSize);
        example.setOffset((pageNo - 1) * pageSize);
        List<OrdSalesbillItemEntity> itemEntities = this.ordSalesbillItemDao.selectByExample(example);
        PageData<List<OrdSalesbillItemEntity>> pageData = new PageData<List<OrdSalesbillItemEntity>>();
        pageData.setCount(count);
        pageData.setData(itemEntities);
        return pageData;
    }

    public BillMainInfo getBillMianInfoBySalesbillId(Long salesbillId) {
        OrdSalesbillEntity ordSalesbillEntity = this.ordSalesbillDao.selectByPrimaryKey(salesbillId);
        if (null == ordSalesbillEntity) {
            return null;
        }
        BillMainInfo billMainInfo = new BillMainInfo();
        BeanUtils.copyProperties((Object)ordSalesbillEntity, billMainInfo);
        return billMainInfo;
    }

    public BillMainInfo getBillMainInfo(Integer userRole, String salesbillNo, Long groupId) {
        OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
        OrdSalesbillExample.Criteria criteria = ordSalesbillExample.createCriteria();
        criteria.andSalesbillNoEqualTo(salesbillNo);
        criteria.andSellerGroupIdEqualTo(groupId);
        if (UserRole.SELLER.intValue() == userRole.intValue()) {
            criteria.andSellerGroupIdEqualTo(groupId);
        } else {
            criteria.andPurchaserGroupIdEqualTo(groupId);
        }
        OrdSalesbillEntity ordSalesbillEntity = this.ordSalesbillDao.selectOneByExample(ordSalesbillExample);
        if (Objects.isNull((Object)ordSalesbillEntity)) {
            return null;
        }
        SalesbillInfo salesbillInfo = new SalesbillInfo();
        BillMainInfo billMainInfo = new BillMainInfo();
        BeanUtils.copyProperties((Object)ordSalesbillEntity, billMainInfo);
        salesbillInfo.setBillMainInfo(billMainInfo);
        return billMainInfo;
    }

    public Long getSalesbillItemBatchNoBySalesbillId(Long salesbillId) {
        OrdSalesbillItemExample example = new OrdSalesbillItemExample();
        example.createCriteria().andSalesbillIdEqualTo(salesbillId).andBatchNoGreaterThan(0L);
        OrdSalesbillItemEntity ordSalesbillItemEntity = this.ordSalesbillItemDao.selectOneByExample(example);
        return ordSalesbillItemEntity == null ? 0L : ordSalesbillItemEntity.getBatchNo();
    }

    public List<OrdSalesbillItemEntity> getOrdSalesbillItemEntityByIds(List<Long> idList) {
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillItemIdIn((List)idList);
        criteria.andStatusEqualTo(BillItemStatus.NORMAL.value());
        return this.ordSalesbillItemDao.selectByExample(ordSalesbillItemExample);
    }

    public List<OrdSalesbillEntity> getOrdSalesbillEntityByIds(List<Long> salesBillIdList, SalesBillStatus salesBillStatus) {
        OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
        OrdSalesbillExample.Criteria criteria1 = ordSalesbillExample.createCriteria();
        criteria1.andSalesbillIdIn((List)salesBillIdList);
        criteria1.andStatusEqualTo(salesBillStatus.value());
        List<OrdSalesbillEntity> ordSalesbillEntityList = this.ordSalesbillDao.selectByExample(ordSalesbillExample);
        logger.info("SalesbillManager--getOrdSalesbillEntityByIds():{}--size:{}", (Object)salesBillIdList.toString(), (Object)ordSalesbillEntityList.size());
        return ordSalesbillEntityList;
    }

    public int updateOrdSalesbillItemEntityStatusByIds(List<Long> idSalesbillItemList, Integer preStatus, Integer afterStatus) {
        OrdSalesbillItemExtExample ordSalesbillItemExtExample = new OrdSalesbillItemExtExample();
        ordSalesbillItemExtExample.setSalesbillItemIdList(idSalesbillItemList);
        ordSalesbillItemExtExample.setPreStatus(preStatus);
        ordSalesbillItemExtExample.setAfterStatus(afterStatus);
        return this.ordSalesbillItemExtDao.updateOrdSalesbillItemEntityByIds(ordSalesbillItemExtExample);
    }

    @Transactional(rollbackFor={Exception.class})
    public int abandonOrdSalesbillEntityStatusByIds(List<Long> salesbillIdList, Integer preStatus, Integer afterStatus, Long deleteToken, String businessBillType, Long updateUser) {
        OrdSalesbillExtExample ordSalesbillExtExample = new OrdSalesbillExtExample();
        ordSalesbillExtExample.setSalesbillIdList(salesbillIdList);
        ordSalesbillExtExample.setDeleteToken(deleteToken);
        ordSalesbillExtExample.setAfterStatus(afterStatus);
        ordSalesbillExtExample.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        ordSalesbillExtExample.setUpdateUser(updateUser);
        ordSalesbillExtExample.setPreStatus(preStatus);
        ordSalesbillExtExample.setBusinessBillType(businessBillType);
        ordSalesbillExtExample.setAlreadyMakeAmountWithoutTax(BigDecimal.ZERO);
        int affected = this.ordSalesbillExtDao.updateOrdSalesbillEntityByIds(ordSalesbillExtExample);
        if (affected != salesbillIdList.size()) {
            throw new RuntimeException("\u5355\u636e\u6279\u91cf\u4f5c\u5e9f\u5931\u8d25.");
        }
        logger.info("abandonOrdSalesbillEntityStatusByIds =============== {}", salesbillIdList);
        return affected;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteOrdSalesbillEntityStatusByIds(List<Long> salesbillIdList, Integer preStatus, Integer afterStatus, Long deleteToken, String businessBillType, Long updateUser) {
        OrdSalesbillExtExample ordSalesbillExtExample = new OrdSalesbillExtExample();
        ordSalesbillExtExample.setSalesbillIdList(salesbillIdList);
        ordSalesbillExtExample.setDeleteToken(deleteToken);
        ordSalesbillExtExample.setAfterStatus(afterStatus);
        ordSalesbillExtExample.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        ordSalesbillExtExample.setUpdateUser(updateUser);
        ordSalesbillExtExample.setPreStatus(preStatus);
        ordSalesbillExtExample.setBusinessBillType(businessBillType);
        ordSalesbillExtExample.setAlreadyMakeAmountWithoutTax(BigDecimal.ZERO);
        int affected = this.ordSalesbillExtDao.deleteOrdSalesbillEntityByIds(ordSalesbillExtExample);
        if (affected != salesbillIdList.size()) {
            throw new RuntimeException("\u5355\u636e\u6279\u91cf\u4f5c\u5e9f\u5931\u8d25.");
        }
        logger.info("abandonOrdSalesbillEntityStatusByIds =============== {}", salesbillIdList);
        return affected;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateOrdSalesbillItemEntityBatchNoByIds(List<Long> salesbillItemIdList, Long preBatchNo, Long afterBatchNo, Long ruleId, Integer preStatus, Integer afterStatus) {
        OrdSalesbillItemExtBatchNoUpdate ordSalesbillItemExtBatchNoUpdate = new OrdSalesbillItemExtBatchNoUpdate();
        ordSalesbillItemExtBatchNoUpdate.setSalesbillItemIdList(salesbillItemIdList);
        ordSalesbillItemExtBatchNoUpdate.setPreBatchNo(preBatchNo);
        ordSalesbillItemExtBatchNoUpdate.setAfterBatchNo(afterBatchNo);
        ordSalesbillItemExtBatchNoUpdate.setRuleId(ruleId);
        ordSalesbillItemExtBatchNoUpdate.setPreStatus(preStatus);
        ordSalesbillItemExtBatchNoUpdate.setAfterStatus(afterStatus);
        return this.ordSalesbillItemExtDao.updateOrdSalesbillItemEntityBatchNoByIds(ordSalesbillItemExtBatchNoUpdate);
    }

    public List<Long> getSalesBillItemIdList(List<Long> salesbillIdList, Integer status) {
        OrdSalesbillItemExtQueryItemIdByBillId ordSalesbillItemExtQueryItemIdByBillId = new OrdSalesbillItemExtQueryItemIdByBillId();
        ordSalesbillItemExtQueryItemIdByBillId.setSalesbillIdList(salesbillIdList);
        ordSalesbillItemExtQueryItemIdByBillId.setStatus(status);
        return this.ordSalesbillItemExtDao.getSalesBillItemIdList(ordSalesbillItemExtQueryItemIdByBillId);
    }

    public long countBatchNoSalesBillItemBySalesbillId(Long salesbillId) {
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillIdEqualTo(salesbillId);
        criteria.andBatchNoGreaterThan(0L);
        return this.ordSalesbillItemDao.countByExample(ordSalesbillItemExample);
    }

    public int updateCooperateModifyStatus(Long salesbillId, Integer setCooperateModifyStatus, Integer neqReceiveConfirmFlag) {
        OrdSalesbillExtExample ordSalesbillExtExample = new OrdSalesbillExtExample();
        ordSalesbillExtExample.setSalesbillIdList(Lists.newArrayList((Object[])new Long[]{salesbillId}));
        ordSalesbillExtExample.setCooperateModifyStatus(setCooperateModifyStatus);
        ordSalesbillExtExample.setReceiveConfirmFlag(neqReceiveConfirmFlag);
        return this.ordSalesbillExtDao.updateCooperateModifyStatus(ordSalesbillExtExample);
    }

    public OrdSalesbillItemEntity getOrdSalesbillItemEntityById(Long salesbillItemId) {
        return this.ordSalesbillItemDao.selectByPrimaryKey(salesbillItemId);
    }

    public OrdSalesbillEntity getOrdSalesbillEntityById(Long salesbillId) {
        return this.ordSalesbillDao.selectByPrimaryKey(salesbillId);
    }

    public BillSearchModel convertMakeoutInvoiceRequest2BillSearchModel(GetInvoiceSplitRuleRequest makeoutInvoiceRequest) {
        SearchSort sort;
        BillSearchModel billSearchModel = new BillSearchModel();
        billSearchModel.setUserRole(String.valueOf(makeoutInvoiceRequest.getUserRole()));
        billSearchModel.setBillStatus(makeoutInvoiceRequest.getConditions().getBillStatus());
        billSearchModel.setUploadSide(makeoutInvoiceRequest.getConditions().getUploadSide());
        billSearchModel.setOtherSideCompanyGroupId(makeoutInvoiceRequest.getConditions().getOtherSideCompanyGroupId());
        billSearchModel.setBillType(makeoutInvoiceRequest.getConditions().getBillType());
        billSearchModel.setBillForInvoice(makeoutInvoiceRequest.getConditions().getBillForInvoice());
        billSearchModel.setGroups(makeoutInvoiceRequest.getConditions().getGroups());
        ArrayList filterGroups = Lists.newArrayList();
        boolean isAllSelected = makeoutInvoiceRequest.getIsAllSelected();
        if (isAllSelected) {
            List excludeList = makeoutInvoiceRequest.getExcludes();
            BillSearchTools.setExcludeFilterGroups(excludeList, filterGroups);
        } else {
            List includeList = makeoutInvoiceRequest.getIncludes();
            BillSearchTools.setIncluceFilterGroups(includeList, filterGroups);
        }
        billSearchModel.setPageSize(Integer.valueOf(10000));
        billSearchModel.setChildGroups((List)filterGroups);
        if (makeoutInvoiceRequest.getConditions().getSort() == null) {
            sort = new SearchSort();
            sort.setFieldName("salesbillItemId");
            sort.setSort("1");
            makeoutInvoiceRequest.getConditions().setSort(sort);
        } else if (makeoutInvoiceRequest.getConditions().getSort() != null) {
            sort = makeoutInvoiceRequest.getConditions().getSort();
            if (CommonTools.isEmpty(makeoutInvoiceRequest.getConditions().getSort().getFieldName())) {
                sort.setFieldName("salesbillItemId");
                sort.setSort("1");
            }
            if (makeoutInvoiceRequest.getConditions().getSort().getMainSort() == null) {
                SearchSort mainSort = new SearchSort();
                mainSort.setFieldName("salesbillId");
                mainSort.setSort("1");
                sort.setMainSort(mainSort);
            }
        }
        billSearchModel.setSort(makeoutInvoiceRequest.getConditions().getSort());
        return billSearchModel;
    }

    public MakeOutInvoiceResponse checkMainAndItemList(List<OrdSalesbillDetailVO> ordSalesbillDetailVOList, Long groupId) {
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        makeOutInvoiceResponse.setCode(Response.OK);
        if (CollectionUtils.isEmpty(ordSalesbillDetailVOList)) {
            makeOutInvoiceResponse.setCode(Response.Fail);
            makeOutInvoiceResponse.setMessage("\u5f85\u6821\u9a8c\u7684\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a.");
            return makeOutInvoiceResponse;
        }
        HashMap ordSalesbillInterfaceEntityMap = Maps.newHashMap();
        ArrayList ordSalesbillIteInterfacemEntityList = Lists.newArrayList();
        ordSalesbillDetailVOList.forEach(item -> {
            OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity = new OrdSalesbillInterfaceEntity();
            OrdSalesbillInterfaceItemEntity ordSalesbillInterfaceItemEntity = new OrdSalesbillInterfaceItemEntity();
            BeanUtils.copyProperties(item.getOrdSalesbillVO(), (Object)ordSalesbillInterfaceEntity);
            BeanUtils.copyProperties(item.getOrdSalesbillItemVO(), (Object)ordSalesbillInterfaceItemEntity);
            ordSalesbillInterfaceEntityMap.put(ordSalesbillInterfaceEntity.getSalesbillId(), ordSalesbillInterfaceEntity);
            ordSalesbillIteInterfacemEntityList.add(ordSalesbillInterfaceItemEntity);
        });
        HashMap headerMap = Maps.newHashMap();
        headerMap.put("groupId", groupId);
        StringBuilder tips = new StringBuilder();
        Map<Long, List<OrdSalesbillInterfaceItemEntity>> groupOrdSalesbillItemEntityMap = ordSalesbillIteInterfacemEntityList.stream().collect(Collectors.groupingBy(item -> item.getSalesbillId()));
        if (!CollectionUtils.isEmpty(groupOrdSalesbillItemEntityMap)) {
            for (Map.Entry<Long, List<OrdSalesbillInterfaceItemEntity>> entry : groupOrdSalesbillItemEntityMap.entrySet()) {
                Long salesbillId = entry.getValue().get(0).getSalesbillId();
                OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity = (OrdSalesbillInterfaceEntity)((Object)ordSalesbillInterfaceEntityMap.get(salesbillId));
                StringBuilder stringBuilder = this.billValidateService.allMainChecks(ordSalesbillInterfaceEntity, headerMap, ValidateType.MAKE_INVOICE);
                if (!CommonTools.isEmpty(ordSalesbillInterfaceEntity.getInvoiceType()) && InvoiceType.SPECIAL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType()) && (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankName()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankAccount()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerTel()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerAddress()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankName()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankAccount()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserTel()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserAddress()))) {
                    stringBuilder.append("\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u65f6,\u9500\u65b9\u94f6\u884c\u4fe1\u606f,\u8d2d\u65b9\u94f6\u884c\u4fe1\u606f\u4e3a\u5fc5\u586b\u9879\uff01");
                }
                if (stringBuilder.length() > 0) {
                    makeOutInvoiceResponse.setCode(Response.Fail);
                    makeOutInvoiceResponse.setMessage(stringBuilder.toString());
                    return makeOutInvoiceResponse;
                }
                boolean checkResult = this.billValidateService.checkItems(ordSalesbillInterfaceEntity, entry.getValue(), tips, headerMap, ValidateType.MAKE_INVOICE.value());
                if (tips.length() > 0) {
                    makeOutInvoiceResponse.setCode(Response.Fail);
                    makeOutInvoiceResponse.setMessage(tips.toString());
                    return makeOutInvoiceResponse;
                }
                if (checkResult) continue;
                makeOutInvoiceResponse.setCode(Response.Fail);
                StringBuilder itemTips = new StringBuilder();
                entry.getValue().forEach(item -> itemTips.append(item.getProcessRemark()));
                makeOutInvoiceResponse.setMessage(itemTips.toString());
                return makeOutInvoiceResponse;
            }
        }
        return makeOutInvoiceResponse;
    }
}

