/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.manager;

import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.repository.daoext.OrdAutoSalesBillItemBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import java.math.BigDecimal;
import java.util.List;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SalesbillMergeAndSplitManager {
    private static final Logger logger = LoggerFactory.getLogger(SalesbillMergeAndSplitManager.class);
    private OrdAutoSalesBillItemBatchDao ordAutoSalesBillItemBatchDao;

    @Autowired
    public SalesbillMergeAndSplitManager(OrdAutoSalesBillItemBatchDao ordAutoSalesBillItemBatchDao) {
        this.ordAutoSalesBillItemBatchDao = ordAutoSalesBillItemBatchDao;
    }

    public static SalesbillItem fillMergedSalesbillItemFields(List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, SalesbillItem salesbillItem) {
        BigDecimal outterDiscountWithTax = BigDecimal.ZERO;
        BigDecimal outterDiscountWithoutTax = BigDecimal.ZERO;
        BigDecimal outterDiscountTax = BigDecimal.ZERO;
        BigDecimal innerDiscountWithTax = BigDecimal.ZERO;
        BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO;
        BigDecimal innerDiscountTax = BigDecimal.ZERO;
        BigDecimal outterPrepayAmountWithTax = BigDecimal.ZERO;
        BigDecimal outterPrepayAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal outterPrepayAmountTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountWithTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountTax = BigDecimal.ZERO;
        BigDecimal deductions = BigDecimal.ZERO;
        BigDecimal alreadyAmountWithTax = BigDecimal.ZERO;
        BigDecimal alreadyAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal alreadyTaxAmount = BigDecimal.ZERO;
        for (OrdSalesbillItemEntity ordSalesbillItemEntity : ordSalesbillItemEntityList) {
            outterDiscountWithTax = outterDiscountWithTax.add(ordSalesbillItemEntity.getOutterDiscountWithTax());
            outterDiscountWithoutTax = outterDiscountWithoutTax.add(ordSalesbillItemEntity.getOutterDiscountWithoutTax());
            outterDiscountTax = outterDiscountTax.add(ordSalesbillItemEntity.getOutterDiscountTax());
            innerDiscountWithTax = innerDiscountWithTax.add(ordSalesbillItemEntity.getInnerDiscountWithTax());
            innerDiscountWithoutTax = innerDiscountWithoutTax.add(ordSalesbillItemEntity.getInnerDiscountWithoutTax());
            innerDiscountTax = innerDiscountTax.add(ordSalesbillItemEntity.getInnerDiscountTax());
            outterPrepayAmountWithTax = outterPrepayAmountWithTax.add(ordSalesbillItemEntity.getOutterPrepayAmountWithTax());
            outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax.add(ordSalesbillItemEntity.getOutterPrepayAmountWithoutTax());
            outterPrepayAmountTax = outterPrepayAmountTax.add(ordSalesbillItemEntity.getOutterPrepayAmountTax());
            innerPrepayAmountWithTax = innerPrepayAmountWithTax.add(ordSalesbillItemEntity.getInnerPrepayAmountWithTax());
            innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax.add(ordSalesbillItemEntity.getInnerPrepayAmountWithoutTax());
            innerPrepayAmountTax = innerPrepayAmountTax.add(ordSalesbillItemEntity.getInnerPrepayAmountTax());
            deductions = deductions.add(ordSalesbillItemEntity.getDeductions());
            alreadyAmountWithTax = alreadyAmountWithTax.add(ordSalesbillItemEntity.getAlreadyAmountWithTax());
            alreadyAmountWithoutTax = alreadyAmountWithoutTax.add(ordSalesbillItemEntity.getAlreadyAmountWithoutTax());
            alreadyTaxAmount = alreadyTaxAmount.add(ordSalesbillItemEntity.getAlreadyTaxAmount());
        }
        SalesbillMergeAndSplitManager.fillOutterDiscountFields(salesbillItem, outterDiscountWithTax, outterDiscountWithoutTax, outterDiscountTax);
        SalesbillMergeAndSplitManager.fillInnerDiscountFields(salesbillItem, innerDiscountWithTax, innerDiscountWithoutTax, innerDiscountTax);
        SalesbillMergeAndSplitManager.fillOutterPrepayAmountFields(salesbillItem, outterPrepayAmountWithTax, outterPrepayAmountWithoutTax, outterPrepayAmountTax);
        SalesbillMergeAndSplitManager.fillInnerPrepayAmountFields(salesbillItem, innerPrepayAmountWithTax, innerPrepayAmountWithoutTax, innerPrepayAmountTax, deductions);
        SalesbillMergeAndSplitManager.fillAlreadyAmount(salesbillItem, alreadyAmountWithTax, alreadyAmountWithoutTax, alreadyTaxAmount);
        BigDecimal totalTaxAmount = salesbillItem.getAmountWithoutTax().subtract(salesbillItem.getDeductions());
        totalTaxAmount = totalTaxAmount.multiply(salesbillItem.getTaxRate());
        salesbillItem.setTaxAmount(totalTaxAmount);
        return salesbillItem;
    }

    private static void fillOutterDiscountFields(SalesbillItem salesbillItem, BigDecimal outterDiscountWithTax, BigDecimal outterDiscountWithoutTax, BigDecimal outterDiscountTax) {
        salesbillItem.setOutterDiscountWithTax(outterDiscountWithTax);
        salesbillItem.setOutterDiscountWithoutTax(outterDiscountWithoutTax);
        salesbillItem.setOutterDiscountTax(outterDiscountTax);
    }

    private static void fillInnerDiscountFields(SalesbillItem salesbillItem, BigDecimal innerDiscountWithTax, BigDecimal innerDiscountWithoutTax, BigDecimal innerDiscountTax) {
        salesbillItem.setInnerDiscountWithTax(innerDiscountWithTax);
        salesbillItem.setInnerDiscountWithoutTax(innerDiscountWithoutTax);
        salesbillItem.setInnerDiscountTax(innerDiscountTax);
    }

    private static void fillOutterPrepayAmountFields(SalesbillItem salesbillItem, BigDecimal outterPrepayAmountWithTax, BigDecimal outterPrepayAmountWithoutTax, BigDecimal outterPrepayAmountTax) {
        salesbillItem.setOutterPrepayAmountWithTax(outterPrepayAmountWithTax);
        salesbillItem.setOutterPrepayAmountWithoutTax(outterPrepayAmountWithoutTax);
        salesbillItem.setOutterPrepayAmountTax(outterPrepayAmountTax);
    }

    private static void fillInnerPrepayAmountFields(SalesbillItem salesbillItem, BigDecimal innerPrepayAmountWithTax, BigDecimal innerPrepayAmountWithoutTax, BigDecimal innerPrepayAmountTax, BigDecimal deductions) {
        salesbillItem.setInnerPrepayAmountWithTax(innerPrepayAmountWithTax);
        salesbillItem.setInnerPrepayAmountWithoutTax(innerPrepayAmountWithoutTax);
        salesbillItem.setInnerPrepayAmountTax(innerPrepayAmountTax);
        salesbillItem.setDeductions(deductions);
    }

    private static void fillAlreadyAmount(SalesbillItem salesbillItem, BigDecimal alreadyAmountWithTax, BigDecimal alreadyAmountWithoutTax, BigDecimal alreadyTaxAmount) {
        salesbillItem.setAlreadyAmountWithTax(alreadyAmountWithTax);
        salesbillItem.setAlreadyAmountWithoutTax(alreadyAmountWithoutTax);
        salesbillItem.setAlreadyTaxAmount(alreadyTaxAmount);
    }

    public int autoBillItemBatchInsert(List<OrdSalesbillItemEntity> ordAutoSalesbillItemEntityList) {
        return this.ordAutoSalesBillItemBatchDao.autoBillItemBatchInsert((BatchParameter<OrdSalesbillItemEntity>)BatchParameter.wrap(ordAutoSalesbillItemEntityList));
    }

    public static String getSellerPurchaseInfoKey(OrdSalesbillDetailVO ordSalesbillDetailVO) {
        OrdSalesbillVO ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO();
        StringBuilder sb = new StringBuilder();
        sb.append(ordSalesbillVO.getSellerGroupId());
        sb.append(ordSalesbillVO.getSellerTaxNo());
        sb.append(ordSalesbillVO.getSellerName());
        sb.append(ordSalesbillVO.getPurchaserGroupId());
        sb.append(ordSalesbillVO.getPurchaserTaxNo());
        sb.append(ordSalesbillVO.getPurchaserName());
        sb.append(ordSalesbillVO.getSalesbillType());
        sb.append(ordSalesbillVO.getInvoiceType());
        sb.append(ordSalesbillVO.getExt1());
        return sb.toString();
    }
}

