/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.rabbitmq.salesbill;

import com.xforceplus.phoenix.bill.core.service.BillInvoiceService;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.seller.invoice.client.model.NoticeBillReleaseMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AbandonInvoiceReleaseBillListener {
    private Logger logger = LoggerFactory.getLogger(AbandonInvoiceReleaseBillListener.class);
    @Autowired
    private BillInvoiceService billInvoiceService;

    @RabbitListener(queuesToDeclare={@Queue(value="bill.release.abandonInvoice")}, concurrency="12")
    public void handleMsg(Message message) {
        String body = new String(message.getBody());
        NoticeBillReleaseMsg msg = JsonUtils.writeFastJsonToObject(body, NoticeBillReleaseMsg.class);
        this.logger.info("batchNo:{}, operation:{}, release:{}", new Object[]{msg.getBatchNo(), msg.getOperationType(), msg.getReleaseType()});
        this.billInvoiceService.revertBillAndItem(msg);
    }
}

