/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.rabbitmq.salesbill;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.notice.client.model.MsDoBase;
import com.xforceplus.notice.client.model.MsOperateMessageRequest;
import com.xforceplus.notice.client.model.MsOperateMessageResponse;
import com.xforceplus.phoenix.bill.client.message.MessageClient;
import com.xforceplus.phoenix.bill.client.model.UploadBillItems;
import com.xforceplus.phoenix.bill.client.model.UploadBillMain;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSaleBillImportExtDao;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSalesBillImportFailReasonExtEntity;
import com.xforceplus.phoenix.bill.utils.DateTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ImportFailReasonExcelListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    MessageClient messageClient;
    @Autowired
    IDGenerator iDGenerator;
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    OrdSaleBillImportExtDao ordSaleBillImportExtDao;
    public static final List<String> templateList = Lists.newArrayList((Object[])new String[]{"\u53d1\u7968\u7c7b\u578b", "\u4e1a\u52a1\u5355\u53f7", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u9500\u65b9\u7f16\u53f7", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u7f16\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u4ef7\u683c\u65b9\u5f0f", "\u7a0e\u7f16\u8f6c\u6362\u4ee3\u7801", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", "\u8d27\u7269\u53ca\u670d\u52a1\u540d\u79f0", "\u6570\u91cf\u5355\u4f4d", "\u578b\u53f7\u89c4\u683c", "\u6570\u91cf", "\u7a0e\u7387", "\u542b\u7a0e\u5355\u4ef7", "\u4e0d\u542b\u7a0e\u5355\u4ef7", "\u4e0d\u542b\u7a0e\u91d1\u989d", "\u7a0e\u989d", "\u542b\u7a0e\u91d1\u989d", "\u9500\u65b9\u5730\u5740", "\u9500\u65b9\u94f6\u884c\u540d\u79f0", "\u9500\u65b9\u94f6\u884c\u8d26\u53f7", "\u9500\u65b9\u7535\u8bdd", "\u6536\u6b3e\u4eba", "\u590d\u6838\u4eba", "\u5f00\u7968\u4eba", "\u8d2d\u65b9\u5730\u5740", "\u8d2d\u65b9\u94f6\u884c\u540d\u79f0", "\u8d2d\u65b9\u94f6\u884c\u8d26\u53f7", "\u8d2d\u65b9\u7535\u8bdd", "\u4ef7\u5185\u6298\u6263\u542b\u7a0e\u603b\u91d1\u989d", "\u4ef7\u5185\u6298\u6263\u4e0d\u542b\u7a0e\u603b\u91d1\u989d", "\u4ef7\u5916\u6298\u6263\u542b\u7a0e\u603b\u91d1\u989d", "\u4ef7\u5916\u6298\u6263\u4e0d\u542b\u7a0e\u603b\u91d1\u989d", "\u4ef7\u5185\u9884\u4ed8\u5361\u542b\u7a0e\u603b\u91d1\u989d", "\u4ef7\u5185\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u603b\u91d1\u989d", "\u4ef7\u5916\u9884\u4ed8\u5361\u542b\u7a0e\u603b\u91d1\u989d", "\u4ef7\u5916\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u603b\u91d1\u989d", "\u63a5\u6536\u7535\u7968\u90ae\u7bb1", "\u539f\u53d1\u7968\u53f7\u7801", "\u539f\u53d1\u7968\u4ee3\u7801", "\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7", "\u5907\u6ce8", "\u8ba2\u5355\u660e\u7ec6\u53f7", "\u9879\u76ee\u5927\u7c7b", "\u9879\u76ee\u4e2d\u7c7b", "\u9879\u76ee\u7ec6\u7c7b", "\u8d27\u7269\u53ca\u670d\u52a1\u4ee3\u7801", "\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d", "\u4ef7\u5185\u6298\u6263\u7a0e\u989d", "\u4ef7\u5185\u542b\u7a0e\u6298\u6263\u91d1\u989d", "\u4ef7\u5916\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d", "\u4ef7\u5916\u6298\u6263\u7a0e\u989d", "\u4ef7\u5916\u542b\u7a0e\u6298\u6263\u91d1\u989d", "\u4ef7\u5185\u4e0d\u542b\u7a0e\u9884\u4ed8\u5361\u91d1\u989d", "\u4ef7\u5185\u9884\u4ed8\u5361\u7a0e\u989d", "\u4ef7\u5185\u542b\u7a0e\u9884\u4ed8\u5361\u91d1\u989d", "\u4ef7\u5916\u4e0d\u542b\u7a0e\u9884\u4ed8\u5361\u91d1\u989d", "\u4ef7\u5916\u9884\u4ed8\u5361\u7a0e\u989d", "\u4ef7\u5916\u542b\u7a0e\u9884\u4ed8\u5361\u91d1\u989d", "\u662f\u5426\u4eab\u53d7\u7a0e\u6536\u4f18\u60e0\u653f\u7b56", "\u4eab\u53d7\u7a0e\u6536\u4f18\u60e0\u653f\u7b56\u5185\u5bb9", "\u96f6\u7a0e\u7387\u6807\u5fd7", "\u6263\u9664\u989d", "\u5176\u4ed6\u7279\u6b8a\u8bf4\u660e"});

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.bill.import.fail.reason")}, concurrency="5")
    public void handleUploadMsg(Message message) {
        Map headers = message.getMessageProperties().getHeaders();
        if (headers.get("importBatchNo") != null) {
            Long importBatchNo = (Long)headers.get("importBatchNo");
            UserInfo userInfo = JsonUtils.writeFastJsonToObject((String)headers.get("userInfo"), UserInfo.class);
            String fileOriginName = (String)headers.get("fileOriginName");
            this.logger.info("importBatchNo:{}", (Object)importBatchNo);
            this.logger.info("userInfo:{}", (Object)userInfo);
            this.logger.info("fileOriginName:{}", (Object)fileOriginName);
            List<OrdSalesBillImportFailReasonExtEntity> resultList = null;
            try {
                String descKey;
                String fieldKey;
                resultList = this.ordSaleBillImportExtDao.queryBillFailByImportBatchNo(importBatchNo);
                this.logger.info("resultList:{}", resultList);
                if (CollectionUtils.isEmpty(resultList)) {
                    return;
                }
                HashMap descMap = Maps.newHashMap();
                ArrayList headList = Lists.newArrayList();
                ArrayList headDescList = Lists.newArrayList();
                for (Field field : UploadBillMain.class.getDeclaredFields()) {
                    if (field.isSynthetic()) continue;
                    fieldKey = field.getAnnotation(JsonProperty.class).value();
                    descKey = UploadBillMain.class.getDeclaredMethod("get" + ImportFailReasonExcelListener.captureName(fieldKey), new Class[0]).getDeclaredAnnotation(ApiModelProperty.class).value();
                    descMap.put(descKey, fieldKey);
                }
                for (Field field : UploadBillItems.class.getDeclaredFields()) {
                    if (field.isSynthetic()) continue;
                    fieldKey = field.getAnnotation(JsonProperty.class).value();
                    descKey = UploadBillItems.class.getDeclaredMethod("get" + ImportFailReasonExcelListener.captureName(fieldKey), new Class[0]).getDeclaredAnnotation(ApiModelProperty.class).value();
                    descMap.put(descKey, fieldKey);
                }
                headList.add("mainReason");
                headList.add("itemReason");
                headDescList.add("\u4e3b\u4fe1\u606f\u5931\u8d25\u539f\u56e0");
                headDescList.add("\u660e\u7ec6\u5931\u8d25\u539f\u56e0");
                headDescList.addAll(templateList);
                headList.addAll(templateList.stream().map(descMap::get).collect(Collectors.toList()));
                ArrayList dataList = Lists.newArrayList();
                for (OrdSalesBillImportFailReasonExtEntity entity : resultList) {
                    String mainJosn = entity.getMainData();
                    String itemjson = entity.getItemData();
                    Map data = JsonUtils.writeFastJsonToMap(mainJosn);
                    Map data2 = JsonUtils.writeFastJsonToMap(itemjson);
                    data.putAll(data2);
                    data.put("mainReason", entity.getMainReason());
                    data.put("itemReason", entity.getItemReason());
                    dataList.add(data);
                }
                this.logger.info("dataList size:{}", (Object)dataList.size());
                HSSFWorkbook workbook = new HSSFWorkbook();
                Sheet sheet = workbook.createSheet("\u5355\u636e\u5bfc\u5165\u5931\u8d25\u539f\u56e0");
                sheet.setDefaultColumnWidth(15);
                sheet.setForceFormulaRecalculation(true);
                ImportFailReasonExcelListener.buildHeader(sheet, headList, headDescList);
                ImportFailReasonExcelListener.buildBody(sheet, headList, dataList);
                String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + importBatchNo + ".xls";
                String key = this.putFile((Workbook)workbook, filepath);
                this.logger.info("\u4e0a\u4f20\u5355\u636e\u5931\u8d25\u6587\u4ef6\u6210\u529foss key:{}", (Object)key);
                MsOperateMessageRequest request = new MsOperateMessageRequest();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                request.setMessageTitle(sdf.format(new Date()) + ",\u4e1a\u52a1\u5355excel\u6587\u4ef6\u3010" + fileOriginName + "\u3011\u5bfc\u5165");
                request.setMessageUrl(this.ossUtil.fileKeyToDownloadUrlViaPlatform(key));
                this.logger.info("download url is : {}", (Object)request.getMessageUrl());
                request.setGroupId(Long.valueOf(userInfo.getGroupId()));
                request.setMessageContent("\u5bfc\u5165\u5931\u8d25" + resultList.size() + "\u6761\uff0c\u8be6\u89c1\u4e0b\u8f7d\u6587\u4ef6");
                request.setMessageId(Long.valueOf(this.iDGenerator.nextId()));
                request.setMessageType(Integer.valueOf(1));
                request.setMessageValue(Long.valueOf(1L));
                request.setUserId(Long.valueOf(userInfo.getUserId()));
                request.setAppid("bill-service");
                request.setDoType(MsDoBase.DoTypeEnum.I);
                request.setOperater(userInfo.getUserName());
                request.setOperaterid(String.valueOf(userInfo.getUserId()));
                request.setRid(String.valueOf(this.iDGenerator.nextId()));
                MsOperateMessageResponse reponse = this.messageClient.operateMessage(request);
                this.logger.info("reponse:{}", (Object)JsonUtils.writeObjectToFastJson(reponse));
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u5355\u636e\u5bfc\u5165\u5931\u8d25\u539f\u56e0\u5f02\u5e38:{}", (Throwable)e);
            }
        }
    }

    private static void buildHeader(Sheet sheet, List<String> headList, List<String> headDescList) {
        Row row = sheet.createRow(0);
        CellStyle cellStyle = ImportFailReasonExcelListener.getCellStyle(row.getSheet().getWorkbook());
        for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
            Cell cell = row.createCell(columnIndex);
            String val = headDescList.get(columnIndex);
            cell.setCellValue(val == null ? "" : val.toString());
            cell.setCellStyle(cellStyle);
        }
    }

    private static void buildBody(Sheet sheet, List<String> headList, List<Map<String, Object>> dataList) {
        CellStyle cellStyle = ImportFailReasonExcelListener.getBodyCellStyle(sheet.getWorkbook());
        for (int rowNum = 1; rowNum <= dataList.size(); ++rowNum) {
            Map<String, Object> map = dataList.get(rowNum - 1);
            Row row = sheet.createRow(rowNum);
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                Cell cell = row.createCell(columnIndex);
                Object val = map.get(headList.get(columnIndex));
                cell.setCellValue(val == null ? "" : val.toString());
                cell.setCellStyle(cellStyle);
            }
        }
    }

    public static String captureName(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(Workbook workbook, String filePath) throws IOException {
        OutputStream out = null;
        File localFile = null;
        try {
            localFile = new File(filePath);
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            out = new FileOutputStream(localFile);
            workbook.write(out);
            String key = this.ossUtil.uploadFile(filePath, Module.SELLER, true);
            FileUtils.deleteQuietly((File)localFile);
            String string = key;
            return string;
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230oss\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (localFile != null) {
                localFile.delete();
            }
        }
    }

    public static CellStyle getCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle getBodyCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)400);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static void main(String[] args) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        Sheet sheet = workbook.createSheet("\u5355\u636e\u5bfc\u5165\u5931\u8d25\u539f\u56e0");
        CellStyle cellStyle = ImportFailReasonExcelListener.getBodyCellStyle(sheet.getWorkbook());
        for (int i = 0; i < 5000; ++i) {
            Row row = sheet.createRow(i);
            for (int j = 0; j < 50; ++j) {
                Cell cell = row.createCell(j);
                cell.setCellStyle(cellStyle);
            }
        }
        System.out.println("---------------");
    }
}

