/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.rabbitmq.salesbill;

import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.seller.invoice.client.model.NoticeBillReleaseMsg;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedInvoiceListener {
    private static final Logger logger = LoggerFactory.getLogger(RedInvoiceListener.class);
    @Autowired
    private RabbitmqService rabbitmqService;

    @RabbitListener(queuesToDeclare={@Queue(value="bill.red.invoice")})
    public void handleMsg(Message message) {
        logger.info("\u5f00\u7968:{}", (Object)message.getMessageProperties());
        try {
            String body = new String(message.getBody());
            logger.info("\u7ea2\u51b2\u5f00\u7968\u6570\u636e:{}", (Object)body);
            List<NoticeBillReleaseMsg> noticeBillMsg = JsonUtils.writeFastJsonToListObject(body, NoticeBillReleaseMsg.class);
            for (NoticeBillReleaseMsg releaseMsg : noticeBillMsg) {
                this.rabbitmqService.send("bill.release.redInvoice", JsonUtils.writeObjectToFastJson(releaseMsg), (Map)Maps.newHashMap());
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f00\u7968\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }
}

