/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.rabbitmq.salesbill.upload;

import com.xforceplus.phoenix.bill.core.impl.upload.tools.MakeSalesBillTools;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesBillMakeFlowListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MakeSalesBillTools makeSalesBillTools;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.bill.make")}, concurrency="5")
    public void makeSalesBillFlow(Message message) {
        Map headers = message.getMessageProperties().getHeaders();
        String data = new String(message.getBody());
        this.logger.info("============\u8fdb\u5165\u751f\u6210\u5355\u636e\u961f\u5217-SALES_BILL_MAKE-headers-{}--data:{}==================", (Object)headers, (Object)JsonUtils.writeObjectToFastJson(data));
        Map map = JsonUtils.writeFastJsonToObject(data, Map.class);
        List<OrdSalesbillInterfaceEntity> interfaceMains = JsonUtils.writeFastJsonToListObject(JsonUtils.writeObjectToFastJson(map.get("interfaceMains")), OrdSalesbillInterfaceEntity.class);
        List<OrdSalesbillInterfaceItemEntity> interfaceItems = JsonUtils.writeFastJsonToListObject(JsonUtils.writeObjectToFastJson(map.get("interfaceItems")), OrdSalesbillInterfaceItemEntity.class);
        List<Long> salesBillIds = JsonUtils.writeFastJsonToListObject(JsonUtils.writeObjectToFastJson(map.get("salesBillIds")), Long.class);
        this.makeSalesBillTools.makeSalesBillFlow(interfaceMains, interfaceItems, headers, salesBillIds);
    }
}

