/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.rabbitmq.salesbill.upload;

import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.CooperateFlag;
import com.xforceplus.phoenix.bill.core.service.CooperationService;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillQueryDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.UploadBillItemsExt;
import com.xforceplus.phoenix.bill.repository.model.modelext.UploadBillMainExt;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.DataDistributeUtils;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.xplatframework.model.Response;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SalesBillSendDistributeListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SalesBillQueryDao salesBillQueryDao;
    @Autowired
    private DataDistributeUtils dataDistributeUtils;
    @Autowired
    CooperationService cooperationService;

    @RabbitListener(queuesToDeclare={@Queue(value="phoenix.bill.send.distribute")}, concurrency="5")
    public void handleSendDistributeMsg(Message message) {
        List failSalesBillIds;
        String remark;
        List successSalesBillIds;
        Map headers = message.getMessageProperties().getHeaders();
        String data = new String(message.getBody());
        this.logger.info("=========headers-{}================distributeMessgeBody{}=====================", (Object)headers, (Object)data);
        Map map = Maps.newHashMap();
        try {
            map = JsonUtils.writeFastJsonToObject(data, Map.class);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        if (map.get("successSalesBillIds") != null && !CommonTools.isEmpty(successSalesBillIds = (List)map.get("successSalesBillIds"))) {
            List<OrdSalesbillEntity> successMains = this.salesBillQueryDao.getSalesBillByIds(successSalesBillIds);
            List<OrdSalesbillItemEntity> successItems = this.salesBillQueryDao.getSalesBillItemByIds(successSalesBillIds);
            remark = this.dataDistributeUtils.getSuccessFeedBack(successMains, successItems);
            this.dataDistributeUtils.sendBillMessage(remark, headers, Response.OK);
            LinkedList<OrdSalesbillEntity> cooperationBillMainlist = new LinkedList<OrdSalesbillEntity>();
            HashSet cooperationBillNoset = new HashSet();
            LinkedList notooperationBillMainlist = new LinkedList();
            successMains.forEach(main -> {
                if (BusinessBillType.AP.value().equals(main.getBusinessBillType()) && CooperateFlag.COOPERATE.value().intValue() == main.getCooperateFlag().intValue()) {
                    cooperationBillNoset.add(main.getSalesbillNo());
                    cooperationBillMainlist.add((OrdSalesbillEntity)((Object)main));
                } else {
                    notooperationBillMainlist.add(main);
                }
            });
            LinkedList<OrdSalesbillItemEntity> cooperationBillItemlist = new LinkedList<OrdSalesbillItemEntity>();
            LinkedList notooperationBillItemlist = new LinkedList();
            successItems.forEach(item -> {
                if (cooperationBillNoset.contains(item.getSalesbillNo())) {
                    cooperationBillItemlist.add((OrdSalesbillItemEntity)((Object)item));
                } else {
                    notooperationBillItemlist.add(item);
                }
            });
            if (cooperationBillMainlist.size() > 0) {
                this.cooperationService.sendSalesbill(cooperationBillMainlist, cooperationBillItemlist, headers);
            }
        }
        if (map.get("failSalesBillIds") != null && !CommonTools.isEmpty(failSalesBillIds = (List)map.get("failSalesBillIds"))) {
            List<UploadBillMainExt> failUploadMainExt = this.salesBillQueryDao.getFailUploadMainExt(failSalesBillIds);
            List<UploadBillItemsExt> failUploadItemsExt = this.salesBillQueryDao.getFailUploadItemsExt(failSalesBillIds);
            remark = this.dataDistributeUtils.getFeedBack(failUploadMainExt, failUploadItemsExt);
            this.dataDistributeUtils.sendBillMessage(remark.toString(), headers, -1);
        }
    }
}

