/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.service.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.api.BillHistoryApi;
import com.xforceplus.phoenix.bill.client.api.BillInvoiceHistoryApi;
import com.xforceplus.phoenix.bill.client.config.MsPhoenixBillApi;
import com.xforceplus.phoenix.bill.client.makeout.InvoiceClient;
import com.xforceplus.phoenix.bill.client.model.BillHistoryQueryRequest;
import com.xforceplus.phoenix.bill.client.model.BillHistoryResponse;
import com.xforceplus.phoenix.bill.client.model.BillHistoryRollBackRequest;
import com.xforceplus.phoenix.bill.client.model.BillInvoiceHistoryLog;
import com.xforceplus.phoenix.bill.client.model.BillInvoiceHistoryResponse;
import com.xforceplus.phoenix.bill.client.model.BillMainInfo;
import com.xforceplus.phoenix.bill.client.model.HistoryLog;
import com.xforceplus.phoenix.bill.client.model.QueryBillInvoiceHistoryRequest;
import com.xforceplus.phoenix.bill.core.service.BillHistoryService;
import com.xforceplus.phoenix.bill.manager.SalesbillManager;
import com.xforceplus.seller.invoice.client.model.ShowInvoiceHistoryByBatchNoRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MsPhoenixBillApi
public class BillHistoryApiController
implements BillHistoryApi,
BillInvoiceHistoryApi {
    private static final Logger logger = LoggerFactory.getLogger(BillHistoryApiController.class);
    @Autowired
    private BillHistoryService billInvoiceService;
    @Autowired
    private SalesbillManager salesbillManager;
    @Autowired
    private InvoiceClient invoiceClient;

    public Response historyRollBack(@ApiParam(value="\u56de\u6eda\u6279\u6b21\u53f7") @RequestBody BillHistoryRollBackRequest billHistoryRollBackRequest) {
        return this.billInvoiceService.historyRollBack(Long.valueOf(billHistoryRollBackRequest.getBatchNo()));
    }

    public BillHistoryResponse queryBillHistory(@ApiParam(value="\u629b\u6d88\u606f\u7684\u5934\u4fe1\u606f") @RequestBody BillHistoryQueryRequest billHistoryQueryRequest) {
        return this.billInvoiceService.queryBillHistory(Long.valueOf(billHistoryQueryRequest.getBillId()));
    }

    public Response checkIsRollbackable(@ApiParam(value="\u629b\u6d88\u606f\u7684\u5934\u4fe1\u606f") @RequestBody BillHistoryRollBackRequest billHistoryRollBackRequest) {
        return this.billInvoiceService.checkIsRollbackable(Long.valueOf(billHistoryRollBackRequest.getBatchNo()));
    }

    public BillInvoiceHistoryResponse queryBillInvoiceHistory(@ApiParam(value="\u67e5\u8be2\u5355\u636e\u53ca\u53d1\u7968\u65e5\u5fd7\u8bf7\u6c42") @RequestBody QueryBillInvoiceHistoryRequest queryBillInvoiceHistoryRequest) {
        BillHistoryResponse billHistoryResponse;
        BillInvoiceHistoryResponse billInvoiceHistoryResponse = new BillInvoiceHistoryResponse();
        billInvoiceHistoryResponse.setCode(Response.OK);
        billInvoiceHistoryResponse.setMessage("\u83b7\u53d6\u6210\u529f.");
        BillInvoiceHistoryLog billInvoiceHistoryLog = new BillInvoiceHistoryLog();
        ArrayList historyLogList = Lists.newArrayList();
        Integer userRole = queryBillInvoiceHistoryRequest.getUserRole();
        Long groupId = queryBillInvoiceHistoryRequest.getGroupId();
        String salesbillNo = queryBillInvoiceHistoryRequest.getSalesbillNo();
        BillMainInfo billMainInfo = this.salesbillManager.getBillMainInfo(userRole, salesbillNo, groupId);
        if (Objects.isNull(billMainInfo)) {
            billInvoiceHistoryResponse.setCode(Response.Fail);
            billInvoiceHistoryResponse.setMessage(String.format("\u96c6\u56e2Id:\u3010%s\u3011\u4e0b\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u4e0d\u5b58\u5728!", groupId, salesbillNo));
            return billInvoiceHistoryResponse;
        }
        Long batchNo = this.salesbillManager.getSalesbillItemBatchNoBySalesbillId(billMainInfo.getSalesbillId());
        logger.info("queryBillInvoiceHistory--batchNo:{}", (Object)batchNo);
        if (batchNo > 0L) {
            ShowInvoiceHistoryByBatchNoRequest showInvoiceHistoryByBatchNoRequest = new ShowInvoiceHistoryByBatchNoRequest();
            showInvoiceHistoryByBatchNoRequest.setBatchNo(batchNo);
            Response response = this.invoiceClient.showInvoiceHistoryByBatchNo(showInvoiceHistoryByBatchNoRequest);
            if (Objects.nonNull(response) && response.getCode().intValue() == Response.OK.intValue()) {
                historyLogList.addAll(JSON.parseArray((String)JSON.toJSONString((Object)response.getResult()), HistoryLog.class));
            }
        }
        if (Objects.nonNull(billHistoryResponse = this.billInvoiceService.queryBillHistory(billMainInfo.getSalesbillId())) && !CollectionUtils.isEmpty((Collection)billHistoryResponse.getResult())) {
            historyLogList.addAll(JSON.parseArray((String)JSON.toJSONString((Object)billHistoryResponse.getResult()), HistoryLog.class));
        }
        billInvoiceHistoryLog.setBillMainInfo(billMainInfo);
        billInvoiceHistoryLog.setHistoryLogList((List)historyLogList);
        billInvoiceHistoryResponse.setResult(billInvoiceHistoryLog);
        return billInvoiceHistoryResponse;
    }
}

