/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.distribute.client.model.CallbackEventMessage;
import com.xforceplus.distribute.client.model.Response;
import com.xforceplus.phoenix.bill.client.cooperate.DistributeClient;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.EventType;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillQueryDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.UploadBillItemsExt;
import com.xforceplus.phoenix.bill.repository.model.modelext.UploadBillMainExt;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataDistributeUtils {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DistributeClient feignDataDistributeClient;
    @Autowired
    private SalesBillQueryDao salesBillQueryDao;

    public void sendBillMessage(String ramark, Map headers, Integer code) {
        Map<String, String> eventProperties = this.getEventProperties(headers);
        this.sendDistribute(ramark, code, eventProperties);
    }

    private List<Object> getSalesBillNo(Map<Object, Object> map, List<Long> mainIds) {
        List<Object> salesBillNos = mainIds.stream().map(m -> map.get(m)).collect(Collectors.toList());
        return salesBillNos;
    }

    private Map<String, String> getEventProperties(Map<String, Object> headers) {
        HashMap eventProperties = Maps.newHashMap();
        String groupId = String.valueOf(headers.get("groupId"));
        String systemOrig = String.valueOf(headers.get("systemOrig"));
        String customNo = String.valueOf(headers.get("customNo"));
        String businessBillType = String.valueOf(headers.get("businessBillType"));
        if (BusinessBillType.AR.value().equals(businessBillType)) {
            eventProperties.put("sellerGroupId", groupId);
        } else if (BusinessBillType.AP.value().equals(businessBillType)) {
            eventProperties.put("purcharserGroupId", groupId);
        }
        eventProperties.put("systemOrign", systemOrig);
        eventProperties.put("customerNo", customNo);
        return eventProperties;
    }

    private void sendDistribute(String remark, Integer code, Map<String, String> eventProperties) {
        if (!CommonTools.isEmpty(remark)) {
            try {
                CallbackEventMessage callbackEventMessage = new CallbackEventMessage();
                callbackEventMessage.setEventType(EventType.Bill_Push.value());
                Response response = new Response();
                response.setCode(code);
                response.setMessage(-1 == code ? "\u5bfc\u5165\u5931\u8d25" : "\u5bfc\u5165\u6210\u529f");
                response.setResult(remark);
                callbackEventMessage.setResponse(response);
                callbackEventMessage.setEventProperties(eventProperties);
                this.logger.info("========sendDistribute-callbackEventMessage-{}==============", (Object)callbackEventMessage);
                try {
                    this.feignDataDistributeClient.doDistributeUsingPOST(callbackEventMessage);
                }
                catch (Exception e) {
                    this.logger.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    public String getFeedBack(List<UploadBillMainExt> failUploadMainExt, List<UploadBillItemsExt> failUploadItemsExt) {
        HashMap result = Maps.newHashMap();
        ArrayList mainMaps = Lists.newArrayList();
        ArrayList itemMaps = Lists.newArrayList();
        failUploadMainExt.stream().forEach(m -> {
            HashMap mainMap = Maps.newHashMap();
            mainMap.put("salesbillNo", m.getSalesbillNo());
            mainMap.put("processRemark", m.getProcessRemark());
            mainMaps.add(mainMap);
        });
        failUploadItemsExt.stream().forEach(m -> {
            HashMap itemMap = Maps.newHashMap();
            itemMap.put("salesbillItemNo", m.getSalesbillItemNo());
            itemMap.put("processRemark", m.getProcessRemark());
            itemMaps.add(itemMap);
        });
        result.put("main", mainMaps);
        result.put("items", itemMaps);
        String remark = JsonUtils.writeObjectToFastJson(result);
        return remark;
    }

    public String getSuccessFeedBack(List<OrdSalesbillEntity> successMains, List<OrdSalesbillItemEntity> successItems) {
        HashMap result = Maps.newHashMap();
        ArrayList mainMaps = Lists.newArrayList();
        ArrayList itemMaps = Lists.newArrayList();
        successMains.stream().forEach(m -> {
            HashMap mainMap = Maps.newHashMap();
            mainMap.put("salesbillNo", m.getSalesbillNo());
            mainMap.put("processRemark", "");
            mainMaps.add(mainMap);
        });
        successItems.stream().forEach(m -> {
            HashMap itemMap = Maps.newHashMap();
            itemMap.put("salesbillItemNo", m.getSalesbillItemNo());
            itemMap.put("processRemark", "");
            itemMaps.add(itemMap);
        });
        result.put("main", mainMaps);
        result.put("items", itemMaps);
        String remark = JsonUtils.writeObjectToFastJson(result);
        return remark;
    }
}

