/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.cache;

import com.xforceplus.phoenix.bill.web.client.OrgClient;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoResponse;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalUcenterExternalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String cacheName = "UCENTER_EXTERNAL_LOCAL_CACHE";
    @Autowired
    private OrgClient orgClient;

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"})
    public OrgModel getOrgInfoByOrgCode(Long groupId, GetOrgInfoRequest.DataTypeEnum dataTypeEnum, String value) {
        GetOrgInfoRequest request = new GetOrgInfoRequest();
        request.setDataType(dataTypeEnum);
        request.setDataValue(value);
        request.setGroupID(groupId);
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        this.logger.debug("======================getOrgInfoByOrgCode-request-{}============================", (Object)request);
        GetOrgInfoResponse orgInfo = this.orgClient.getOrgInfo(request);
        OrgModel result = orgInfo.getResult();
        this.logger.debug("======================OrgModel-{}===================================", (Object)result);
        return result;
    }

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"})
    public List<OrgModel> getOrgList(Long groupId, Long userId) {
        GetOrgListRequest request = new GetOrgListRequest();
        request.setGroupID(groupId);
        request.setUserID(userId);
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(2000));
        this.logger.debug("======================getOrgList-request-{}============================", (Object)request);
        GetOrgListResponse response = this.orgClient.getOrgList(request);
        List orgModelList = response.getResult();
        this.logger.debug("======================OrgModel-List-{}===================================", (Object)orgModelList);
        return orgModelList;
    }

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"})
    public List<OrgModel> getOrgListByCompanyNo(Long groupId, Long userId, Integer orgType, String companyNo) {
        GetOrgListRequest request = new GetOrgListRequest();
        request.setGroupID(groupId);
        request.setUserID(userId);
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        if (orgType != null) {
            request.setSingleOrgType(orgType);
        }
        request.setQueryBelongToCountFlag(Boolean.valueOf(true));
        request.setCompanyNo(companyNo);
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(2000));
        this.logger.debug("======================getOrgList-request-{}============================", (Object)request);
        GetOrgListResponse response = this.orgClient.getOrgList(request);
        List orgModelList = response.getResult();
        this.logger.debug("======================OrgModel-List-{}===================================", (Object)orgModelList);
        return orgModelList;
    }
}

