/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.bss.external.client.model.SearchCompanyListRequest;
import com.xforceplus.bss.external.client.model.SearchCompanyListResponse;
import com.xforceplus.bss.external.client.model.SearchGroupListRequest;
import com.xforceplus.bss.external.client.model.SearchGroupListResponse;
import com.xforceplus.phoenix.bill.app.api.model.CommonQueryCompanyRequest;
import com.xforceplus.phoenix.bill.web.assemble.CompanyAssemble;
import com.xforceplus.phoenix.bill.web.client.BillCompanyClient;
import com.xforceplus.phoenix.bill.web.client.BillGroupClient;
import com.xforceplus.phoenix.bill.web.client.ConfigCompanyClient;
import com.xforceplus.phoenix.bill.web.core.service.BillCommonService;
import com.xforceplus.phoenix.bill.web.utils.JsonUtils;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryRequest;
import com.xforceplus.seller.config.client.model.ConfigCompanyQueryResponse;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillCommonServiceImpl
implements BillCommonService {
    private static final Logger logger = LoggerFactory.getLogger(BillCommonServiceImpl.class);
    @Autowired
    private BillCompanyClient billCompanyClient;
    @Autowired
    private BillGroupClient billGroupClient;
    @Autowired
    ConfigCompanyClient configCompanyClient;

    @Override
    public List<MsEnumBean> searchCompany(CommonQueryCompanyRequest commonQueryCompanyRequest, UserSessionInfo userSessionInfo) {
        String searchType = commonQueryCompanyRequest.getSearchType();
        SearchCompanyListRequest searchCompanyListRequest = new SearchCompanyListRequest();
        Long groupId = null;
        if (StringUtils.isEmpty((CharSequence)searchType) || StringUtils.equals((CharSequence)"1", (CharSequence)searchType)) {
            groupId = userSessionInfo.getGroupId();
        }
        if (groupId != null) {
            searchCompanyListRequest.setGroupId(groupId);
        }
        searchCompanyListRequest.dataType(SearchCompanyListRequest.DataTypeEnum.COMPANYNAME);
        searchCompanyListRequest.appid("bill-app");
        searchCompanyListRequest.dataValue(commonQueryCompanyRequest.getKeyWord());
        searchCompanyListRequest.setRid(UUID.randomUUID().toString());
        SearchCompanyListResponse companyListResponse = this.billCompanyClient.searchCompanyList(searchCompanyListRequest);
        List<MsEnumBean> enumBeans = CompanyAssemble.companyResponseTrans2EnumBean(companyListResponse);
        logger.info("sessionInfo:{}", (Object)JsonUtils.writeObjectToJson(userSessionInfo));
        String keyword = commonQueryCompanyRequest.getKeyWord();
        groupId = userSessionInfo != null ? Long.valueOf(userSessionInfo.getGroupId()) : Long.valueOf(0L);
        this.getConfigCompany(groupId, keyword, enumBeans);
        return enumBeans;
    }

    @Override
    public List<MsEnumBean> searchCompanyGroup(CommonQueryCompanyRequest commonQueryCompanyRequest, UserSessionInfo userSessionInfo) {
        String searchType = commonQueryCompanyRequest.getSearchType();
        SearchGroupListResponse companyListResponse = null;
        if (StringUtils.isEmpty((CharSequence)searchType) || StringUtils.equals((CharSequence)"1", (CharSequence)searchType)) {
            MsEnumBean msEnumBean = new MsEnumBean();
            msEnumBean.setValue(String.valueOf(userSessionInfo.getGroupId()));
            msEnumBean.setText(userSessionInfo.getGroupName());
            Response response = new Response();
            response.setCode(Response.OK);
            ArrayList msEnumBeans = Lists.newArrayList((Object[])new MsEnumBean[]{msEnumBean});
            return msEnumBeans;
        }
        SearchGroupListRequest searchCompanyListRequest = new SearchGroupListRequest();
        searchCompanyListRequest.appid("bill-app");
        searchCompanyListRequest.dataValue(commonQueryCompanyRequest.getKeyWord());
        searchCompanyListRequest.setRid(UUID.randomUUID().toString());
        companyListResponse = this.billGroupClient.searchGroupList(searchCompanyListRequest);
        return CompanyAssemble.groupResponseTrans2EnumBean(companyListResponse, userSessionInfo.getGroupId());
    }

    private void getConfigCompany(Long groupId, String keyword, List<MsEnumBean> enumBeans) {
        try {
            ConfigCompanyQueryRequest configCompanyQueryRequest = new ConfigCompanyQueryRequest();
            configCompanyQueryRequest.setGroupId(groupId);
            configCompanyQueryRequest.setKeyword(keyword);
            ConfigCompanyQueryResponse configCompanyQueryResponse = this.configCompanyClient.queryConfigCompany(configCompanyQueryRequest);
            if (!CollectionUtils.isEmpty((Collection)configCompanyQueryResponse.getList())) {
                ArrayList companyNames = Lists.newArrayList();
                enumBeans.stream().forEach(item -> companyNames.add(item.getValue()));
                List listCompanyModel = configCompanyQueryResponse.getList();
                listCompanyModel.stream().forEach(data -> {
                    if (!companyNames.contains(data.getCompanyName())) {
                        MsEnumBean msEnumBean = new MsEnumBean();
                        msEnumBean.setValue(data.getCompanyName());
                        msEnumBean.setText(data.getCompanyName());
                        msEnumBean.setDefaultflag(Integer.valueOf(0));
                        enumBeans.add(msEnumBean);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u975e\u8fd0\u8425\u516c\u53f8,\u5f02\u5e38------", (Throwable)e);
        }
    }
}

