/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.BillDetailResponse;
import com.xforceplus.phoenix.bill.client.model.BillItemResponse;
import com.xforceplus.phoenix.bill.client.model.BillResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.BillSummaryResponse;
import com.xforceplus.phoenix.bill.client.model.RequestSource;
import com.xforceplus.phoenix.bill.web.cache.LocalUcenterExternalCacheManager;
import com.xforceplus.phoenix.bill.web.client.BillQueryClient;
import com.xforceplus.phoenix.bill.web.client.OrgClient;
import com.xforceplus.phoenix.bill.web.core.service.BillQueryService;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.service.BaseService;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillQueryServiceImpl
extends BaseService
implements BillQueryService {
    @Autowired
    BillQueryClient billQueryClient;
    @Autowired
    LocalUcenterExternalCacheManager ucenterExternalCacheManager;
    @Autowired
    OrgClient orgClient;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    @Override
    public BillResponse getBillList(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.getBillList(billSearchModel);
    }

    @Override
    public BillDetailResponse getBillListByDetail(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.getBillListByDetail(billSearchModel);
    }

    @Override
    public BillItemResponse getBillDetailList(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.getBillDetailList(billSearchModel);
    }

    @Override
    public BillSummaryResponse summaryBill(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.summaryBill(billSearchModel);
    }

    @Override
    public BillSummaryResponse summaryByDetail(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.summaryByDetail(billSearchModel);
    }

    private void buildModel(BillSearchModel billSearchModel) {
        billSearchModel.setRequestSource(RequestSource.APP.value());
        GetOrgListRequest request = new GetOrgListRequest();
        request.setGroupID(Long.valueOf(((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId()));
        request.setUserID(Long.valueOf(((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserId()));
        request.setAppid("phoenix-bill-app");
        request.setRid(String.valueOf(UUID.randomUUID()));
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(2000));
        List<OrgModel> orgModelList = this.ucenterExternalCacheManager.getOrgList(((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserId());
        this.logger.debug("orgModelList:{}", orgModelList);
        billSearchModel.setCompanyIdList(orgModelList.stream().filter(e -> !Objects.equals(0, e.getOrgType())).map(OrgModel::getCompanyId).collect(Collectors.toList()));
        billSearchModel.setSysOrgIdList(orgModelList.stream().map(orgModel -> String.valueOf(orgModel.getOrgStructId())).collect(Collectors.toList()));
        List groups = billSearchModel.getGroups();
        ArrayList mainGroups = Lists.newArrayList();
        ArrayList itemGroups = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            for (int i = 0; i < groups.size(); ++i) {
                List data = (List)groups.get(i);
                if (data.size() <= 0) continue;
                SearchFilter searchFilter = (SearchFilter)data.get(0);
                if (searchFilter.getFieldGroupIndex() == 0) {
                    mainGroups.add(data);
                    continue;
                }
                String fieldName = searchFilter.getFieldName();
                if (fieldName.contains(",")) {
                    searchFilter.setFieldName(fieldName.substring(0, fieldName.indexOf(",")));
                    ArrayList searchFilters = Lists.newArrayList((Object[])new SearchFilter[]{searchFilter});
                    itemGroups.add(searchFilters);
                    continue;
                }
                itemGroups.add(data);
            }
        }
        billSearchModel.setGroups((List)mainGroups);
        billSearchModel.setChildGroups((List)itemGroups);
    }
}

