/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.controller;

import com.xforceplus.phoenix.bill.app.api.BillOperationApi;
import com.xforceplus.phoenix.bill.app.api.model.BillDetailInfoRequest;
import com.xforceplus.phoenix.bill.app.api.model.BillMainInfoRequest;
import com.xforceplus.phoenix.bill.client.model.BillDetailInfoResponse;
import com.xforceplus.phoenix.bill.client.model.BillMainInfoResponse;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.DiscountRequest;
import com.xforceplus.phoenix.bill.client.model.GetBillDetailInfoRequest;
import com.xforceplus.phoenix.bill.client.model.GetBillMainInfoRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceByBillIdsRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceByBillItemIdsRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleResponse;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.MakeoutInvoiceRequest;
import com.xforceplus.phoenix.bill.web.annotation.PhoenixBillApiV1;
import com.xforceplus.phoenix.bill.web.constants.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.web.core.service.BillOperationService;
import com.xforceplus.phoenix.bill.web.utils.JsonUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@PhoenixBillApiV1
public class BillOperationApiController
extends BaseAppController
implements BillOperationApi {
    private BillOperationService billOperationService;

    @Autowired
    public BillOperationApiController(BillOperationService billOperationService) {
        this.billOperationService = billOperationService;
    }

    public Response abandonBillsAR(@ApiParam(value="\u9875\u9762\u7684\u7b5b\u9009\u6761\u4ef6", required=true) @RequestBody BillRequest conditions) {
        return this.billOperationService.abandonBill(conditions, "AR");
    }

    public MakeOutInvoiceResponse makeOutInvoiceAR(@ApiParam(value="\u5355\u636e\u5f00\u5177\u8bf7\u6c42") @RequestBody MakeoutInvoiceRequest makeoutInvoiceRequest) {
        if (null == makeoutInvoiceRequest) {
            return this.failMakeOutInvoiceResponse();
        }
        makeoutInvoiceRequest.setUserRole(BusinessBillType.AR.getCode());
        this.logger.info("makeOutInvoiceAR makeoutInvoiceRequest:{}", (Object)JsonUtils.writeObjectToJson(makeoutInvoiceRequest));
        return this.billOperationService.makeOutInvoice(makeoutInvoiceRequest);
    }

    public Response manualSplitDiscountAR(@ApiParam(value="\u624b\u52a8\u5206\u644a\u6298\u6263", required=true) @RequestBody DiscountRequest discountRequest) {
        if (null == discountRequest) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        discountRequest.setUserRole(BusinessBillType.AR.getCode());
        return this.billOperationService.manualSplitDiscount(discountRequest);
    }

    public GetInvoiceSplitRuleResponse getInvoiceSplitRuleAR(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u660e\u7ec6\u83b7\u53d6 \u5f00\u7968\u65f6 \u9700\u8981\u7684\u62c6\u7968\u3001\u62ac\u5934\u4fe1\u606f") @RequestBody GetInvoiceSplitRuleRequest getInvoiceSplitRuleRequest) {
        if (null == getInvoiceSplitRuleRequest) {
            return this.failGetInvoiceSplitRuleResponse();
        }
        getInvoiceSplitRuleRequest.setUserRole(BusinessBillType.AR.getCode());
        return this.billOperationService.getInvoiceSplitRule(getInvoiceSplitRuleRequest);
    }

    public GetInvoiceResponse getInvoiceByBillIdsAR(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u83b7\u53d6\u53d1\u7968\u5217\u8868") @RequestBody GetInvoiceByBillIdsRequest getInvoiceByBillIdsRequest) {
        if (null == getInvoiceByBillIdsRequest) {
            return this.failGetInvoiceResponse();
        }
        getInvoiceByBillIdsRequest.setUserRole(BusinessBillType.AR.getCode());
        return this.billOperationService.getInvoiceByBillIds(getInvoiceByBillIdsRequest);
    }

    public GetInvoiceResponse getInvoiceByBillItemIdsAR(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u660e\u7ec6\u83b7\u53d6\u53d1\u7968\u5217\u8868") @RequestBody GetInvoiceByBillItemIdsRequest getInvoiceByBillItemIdsRequest) {
        if (null == getInvoiceByBillItemIdsRequest) {
            return this.failGetInvoiceResponse();
        }
        getInvoiceByBillItemIdsRequest.setUserRole(BusinessBillType.AR.getCode());
        return this.billOperationService.getInvoiceByBillItemIds(getInvoiceByBillItemIdsRequest);
    }

    public BillDetailInfoResponse getBillDetailInfoAR(@ApiParam(value="\u67e5\u8be2\u5355\u636e\u53ca\u660e\u7ec6\u8be6\u60c5") @RequestBody BillDetailInfoRequest billDetailInfoRequest) {
        if (null == billDetailInfoRequest) {
            return this.failBillDetailInfoResponse();
        }
        GetBillDetailInfoRequest getBillDetailInfoRequest = new GetBillDetailInfoRequest();
        getBillDetailInfoRequest.setSalesbillNo(billDetailInfoRequest.getSalesbillNo());
        getBillDetailInfoRequest.setGroupId(this.getGroupId());
        getBillDetailInfoRequest.setUserRole(BusinessBillType.AR.getCode());
        return this.billOperationService.getBillDetailInfo(getBillDetailInfoRequest);
    }

    public BillMainInfoResponse getBillMainInfoAR(@ApiParam(value="\u67e5\u8be2\u5355\u636e\u4e3b\u4fe1\u606f\u8be6\u60c5") @RequestBody BillMainInfoRequest billMainInfoRequest) {
        if (null == billMainInfoRequest) {
            return this.failBillMainInfoResponse();
        }
        GetBillMainInfoRequest getBillMainInfoRequest = new GetBillMainInfoRequest();
        getBillMainInfoRequest.setUserRole(BusinessBillType.AR.getCode());
        getBillMainInfoRequest.setGroupId(this.getGroupId());
        getBillMainInfoRequest.setSalesbillNo(billMainInfoRequest.getSalesbillNo());
        return this.billOperationService.getBillMainInfo(getBillMainInfoRequest);
    }

    public Response abandonBillsAP(@ApiParam(value="\u9875\u9762\u7684\u7b5b\u9009\u6761\u4ef6", required=true) @RequestBody BillRequest conditions) {
        return this.billOperationService.abandonBill(conditions, "AP");
    }

    public MakeOutInvoiceResponse makeOutInvoiceAP(@ApiParam(value="\u5355\u636e\u5f00\u5177\u8bf7\u6c42") @RequestBody MakeoutInvoiceRequest makeoutInvoiceRequest) {
        if (null == makeoutInvoiceRequest) {
            return this.failMakeOutInvoiceResponse();
        }
        makeoutInvoiceRequest.setUserRole(BusinessBillType.AP.getCode());
        return this.billOperationService.makeOutInvoice(makeoutInvoiceRequest);
    }

    public Response manualSplitDiscountAP(@ApiParam(value="\u624b\u52a8\u5206\u644a\u6298\u6263", required=true) @RequestBody DiscountRequest discountRequest) {
        if (null == discountRequest) {
            return Response.failed((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        discountRequest.setUserRole(BusinessBillType.AP.getCode());
        return this.billOperationService.manualSplitDiscount(discountRequest);
    }

    public GetInvoiceSplitRuleResponse getInvoiceSplitRuleAP(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u660e\u7ec6\u83b7\u53d6 \u5f00\u7968\u65f6 \u9700\u8981\u7684\u62c6\u7968\u3001\u62ac\u5934\u4fe1\u606f") @RequestBody GetInvoiceSplitRuleRequest getInvoiceSplitRuleRequest) {
        if (null == getInvoiceSplitRuleRequest) {
            return this.failGetInvoiceSplitRuleResponse();
        }
        getInvoiceSplitRuleRequest.setUserRole(BusinessBillType.AP.getCode());
        return this.billOperationService.getInvoiceSplitRule(getInvoiceSplitRuleRequest);
    }

    private GetInvoiceSplitRuleResponse failGetInvoiceSplitRuleResponse() {
        GetInvoiceSplitRuleResponse getInvoiceSplitRuleResponse = new GetInvoiceSplitRuleResponse();
        getInvoiceSplitRuleResponse.setCode(Response.Fail);
        getInvoiceSplitRuleResponse.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return getInvoiceSplitRuleResponse;
    }

    public GetInvoiceResponse getInvoiceByBillIdsAP(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u83b7\u53d6\u53d1\u7968\u5217\u8868") @RequestBody GetInvoiceByBillIdsRequest getInvoiceByBillIdsRequest) {
        if (null == getInvoiceByBillIdsRequest) {
            return this.failGetInvoiceResponse();
        }
        getInvoiceByBillIdsRequest.setUserRole(BusinessBillType.AP.getCode());
        return this.billOperationService.getInvoiceByBillIds(getInvoiceByBillIdsRequest);
    }

    public GetInvoiceResponse getInvoiceByBillItemIdsAP(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u660e\u7ec6\u83b7\u53d6\u53d1\u7968\u5217\u8868") @RequestBody GetInvoiceByBillItemIdsRequest getInvoiceByBillItemIdsRequest) {
        if (null == getInvoiceByBillItemIdsRequest) {
            return this.failGetInvoiceResponse();
        }
        getInvoiceByBillItemIdsRequest.setUserRole(BusinessBillType.AP.getCode());
        return this.billOperationService.getInvoiceByBillItemIds(getInvoiceByBillItemIdsRequest);
    }

    public BillDetailInfoResponse getBillDetailInfoAP(@ApiParam(value="\u67e5\u8be2\u5355\u636e\u53ca\u660e\u7ec6\u8be6\u60c5") @RequestBody BillDetailInfoRequest billDetailInfoRequest) {
        if (null == billDetailInfoRequest) {
            return this.failBillDetailInfoResponse();
        }
        GetBillDetailInfoRequest getBillDetailInfoRequest = new GetBillDetailInfoRequest();
        getBillDetailInfoRequest.setUserRole(BusinessBillType.AP.getCode());
        getBillDetailInfoRequest.setGroupId(this.getGroupId());
        getBillDetailInfoRequest.setSalesbillNo(billDetailInfoRequest.getSalesbillNo());
        return this.billOperationService.getBillDetailInfo(getBillDetailInfoRequest);
    }

    public BillMainInfoResponse getBillMainInfoAP(@ApiParam(value="\u67e5\u8be2\u5355\u636e\u4e3b\u4fe1\u606f\u8be6\u60c5") @RequestBody BillMainInfoRequest billMainInfoRequest) {
        if (null == billMainInfoRequest) {
            return this.failBillMainInfoResponse();
        }
        GetBillMainInfoRequest getBillMainInfoRequest = new GetBillMainInfoRequest();
        getBillMainInfoRequest.setUserRole(BusinessBillType.AP.getCode());
        getBillMainInfoRequest.setGroupId(this.getGroupId());
        getBillMainInfoRequest.setSalesbillNo(billMainInfoRequest.getSalesbillNo());
        return this.billOperationService.getBillMainInfo(getBillMainInfoRequest);
    }

    private BillMainInfoResponse failBillMainInfoResponse() {
        BillMainInfoResponse billMainInfoResponse = new BillMainInfoResponse();
        billMainInfoResponse.setCode(Response.Fail);
        billMainInfoResponse.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return billMainInfoResponse;
    }

    private BillDetailInfoResponse failBillDetailInfoResponse() {
        BillDetailInfoResponse billDetailInfoResponse = new BillDetailInfoResponse();
        billDetailInfoResponse.setCode(Response.Fail);
        billDetailInfoResponse.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return billDetailInfoResponse;
    }

    private GetInvoiceResponse failGetInvoiceResponse() {
        GetInvoiceResponse response = new GetInvoiceResponse();
        response.setCode(Response.Fail);
        response.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return response;
    }

    private MakeOutInvoiceResponse failMakeOutInvoiceResponse() {
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        makeOutInvoiceResponse.setCode(Response.Fail);
        makeOutInvoiceResponse.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return makeOutInvoiceResponse;
    }
}

