/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.utils;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.core.Converter;

public class BeanUtils {
    private static Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    private static Map<String, BeanCopier> copierMap = Maps.newHashMap();
    private static PropertyConverter propertyConverter = new PropertyConverter();

    public static void copyProperties(Object src, Object dest) {
        try {
            BeanCopier copier;
            String key = src.getClass().getName() + dest.getClass().getName();
            if (copierMap.containsKey(key)) {
                copier = copierMap.get(key);
            } else {
                copier = BeanCopier.create(src.getClass(), dest.getClass(), (boolean)true);
                copierMap.put(key, copier);
            }
            copier.copy(src, dest, (Converter)propertyConverter);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5c5e\u6027\u590d\u5236\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
    }

    private static class PropertyConverter
    implements Converter {
        private PropertyConverter() {
        }

        public Object convert(Object value, Class target, Object context) {
            if (value == null) {
                return null;
            }
            try {
                if (!value.getClass().equals(target)) {
                    if (target.equals(BigDecimal.class)) {
                        return new BigDecimal(value.toString());
                    }
                    if (target.equals(Long.class)) {
                        return Long.valueOf(value.toString());
                    }
                    if (target.equals(Integer.class)) {
                        return Integer.valueOf(value.toString());
                    }
                    if (target.equals(Integer.TYPE)) {
                        return (int)Integer.valueOf(value.toString());
                    }
                    if (target.equals(String.class)) {
                        return value.toString();
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            }
            return value;
        }
    }
}

