/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.cache;

import com.xforceplus.phoenix.bill.web.client.OrgClient;
import com.xforceplus.phoenix.bill.web.client.OrgUserInfoClient;
import com.xforceplus.phoenix.bill.web.client.OutSideCompanyClient;
import com.xforceplus.phoenix.bill.web.constants.enums.OutQXResponses;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoResponse;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetOrgListResponse;
import com.xforceplus.ucenter.external.client.model.GetUserInfoRequest;
import com.xforceplus.ucenter.external.client.model.GetUserInfoResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.ucenter.external.client.model.ResponseResult;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalUcenterExternalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String cacheName = "UCENTER_EXTERNAL_LOCAL_CACHE";
    @Autowired
    private OrgClient orgClient;
    @Autowired
    private OutSideCompanyClient outSideCompanyClient;
    @Autowired
    private OrgUserInfoClient orgUserClient;

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"})
    public OrgModel getOrgInfoByOrgCode(Long groupId, GetOrgInfoRequest.DataTypeEnum dataTypeEnum, String value) {
        GetOrgInfoRequest request = new GetOrgInfoRequest();
        request.setDataType(dataTypeEnum);
        request.setDataValue(value);
        request.setGroupID(groupId);
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        this.logger.debug("======================getOrgInfoByOrgCode-request-{}============================", (Object)request);
        GetOrgInfoResponse orgInfo = this.orgClient.getOrgInfo(request);
        OrgModel result = orgInfo.getResult();
        this.logger.debug("======================OrgModel-{}===================================", (Object)result);
        return result;
    }

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"})
    public List<OrgModel> getOrgList(Long groupId, Long userId) {
        GetOrgListRequest request = new GetOrgListRequest();
        request.setGroupID(groupId);
        request.setUserID(userId);
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(2000));
        this.logger.debug("======================getOrgList-request-{}============================", (Object)request);
        GetOrgListResponse response = this.orgClient.getOrgList(request);
        List orgModelList = response.getResult();
        this.logger.debug("======================OrgModel-List-{}===================================", (Object)orgModelList);
        return orgModelList;
    }

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"})
    public List<OrgModel> getOrgListByCompanyNo(Long groupId, Long userId, Integer orgType, String companyNo) {
        GetOrgListRequest request = new GetOrgListRequest();
        request.setGroupID(groupId);
        request.setUserID(userId);
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        if (orgType != null) {
            request.setSingleOrgType(orgType);
        }
        request.setQueryBelongToCountFlag(Boolean.valueOf(true));
        request.setCompanyNo(companyNo);
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(2000));
        this.logger.debug("======================getOrgList-request-{}============================", (Object)request);
        GetOrgListResponse response = this.orgClient.getOrgList(request);
        List orgModelList = response.getResult();
        this.logger.debug("======================OrgModel-List-{}===================================", (Object)orgModelList);
        return orgModelList;
    }

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    public List<String> getExternalCompanyTaxNumList(Long tenantId, Long userId) {
        try {
            this.logger.info("\u5916\u90e8\u4f9b\u5e94\u5546\u7528\u6237\u4fe1\u606f\uff0cuserId:{},tenantId:{}", (Object)userId, (Object)tenantId);
            ResponseResult responseResult = this.outSideCompanyClient.list(tenantId, userId);
            String message = JsonUtils.writeObjectToFastJson((Object)responseResult);
            this.logger.info("\u5916\u90e8\u6743\u9650\u63a5\u53e3\u56de\u6267\u4fe1\u606f\uff1a{}", (Object)message);
            OutQXResponses outQXResponses = (OutQXResponses)JsonUtils.writeFastJsonToObject((String)message, OutQXResponses.class);
            if (outQXResponses.getCode() == Response.OK.intValue()) {
                List<OutQXResponses.ResultBean> resultList = outQXResponses.getResult();
                List<String> collect = resultList.stream().map(result -> result.getTaxNum()).distinct().collect(Collectors.toList());
                return collect;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("getExternalCompany Exception {}", (Throwable)e);
        }
        return null;
    }

    @Cacheable(cacheNames={"UCENTER_EXTERNAL_LOCAL_CACHE"}, key="#root.methodName + #root.args[0] + #root.args[1]")
    public GetUserInfoResponse getUserExtPermission(Long userId, Long groupId) {
        try {
            GetUserInfoRequest getUserInfoRequest = new GetUserInfoRequest();
            getUserInfoRequest.setUserID(userId);
            getUserInfoRequest.setGroupID(groupId);
            getUserInfoRequest.setAppid("phoenix-bill-app");
            getUserInfoRequest.setRid(UUID.randomUUID().toString());
            this.logger.info("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027,userId:{},groupId:{}", (Object)userId, (Object)groupId);
            GetUserInfoResponse userInfo = this.orgUserClient.getUserInfo(getUserInfoRequest);
            this.logger.info("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027\u8fd4\u56de\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)userInfo));
            return userInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

