/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.controller;

import com.xforceplus.phoenix.bill.app.api.ConfirmApi;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.web.annotation.PhoenixBillApiV1;
import com.xforceplus.phoenix.bill.web.constants.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.web.core.service.BillConfirmService;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatsecurity.base.BaseAppController;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@PhoenixBillApiV1
public class BillConfirmApiController
extends BaseAppController
implements ConfirmApi {
    @Autowired
    private BillConfirmService billConfirmService;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    private void handleUserInfo(BillRequest billRequest) {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        billRequest.setUserInfo(userSessionInfo);
    }

    public Response confirmBillAR(@ApiParam(value="\u9875\u9762\u7684\u7b5b\u9009\u6761\u4ef6", required=true) @RequestBody BillRequest billRequest) {
        this.handleUserInfo(billRequest);
        return this.billConfirmService.confirmBillByCondition(billRequest, BusinessBillType.AR.value());
    }

    public Response rejectBillAR(@ApiParam(value="\u9875\u9762\u7684\u7b5b\u9009\u6761\u4ef6", required=true) @RequestBody BillRequest billRequest) {
        this.handleUserInfo(billRequest);
        return this.billConfirmService.rejectBillByCondition(billRequest, BusinessBillType.AR.value());
    }

    public Response confirmBillAP(@ApiParam(value="\u9875\u9762\u7684\u7b5b\u9009\u6761\u4ef6", required=true) @RequestBody BillRequest billRequest) {
        this.handleUserInfo(billRequest);
        return this.billConfirmService.confirmBillByCondition(billRequest, BusinessBillType.AP.value());
    }

    public Response rejectBillAP(@ApiParam(value="\u9875\u9762\u7684\u7b5b\u9009\u6761\u4ef6", required=true) @RequestBody BillRequest billRequest) {
        this.handleUserInfo(billRequest);
        return this.billConfirmService.rejectBillByCondition(billRequest, BusinessBillType.AP.value());
    }
}

