/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.web.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.BillDetailResponse;
import com.xforceplus.phoenix.bill.client.model.BillItemResponse;
import com.xforceplus.phoenix.bill.client.model.BillMainExt;
import com.xforceplus.phoenix.bill.client.model.BillResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.BillSummaryResponse;
import com.xforceplus.phoenix.bill.client.model.QueryBillItemModel;
import com.xforceplus.phoenix.bill.client.model.QueryBillItemResponse;
import com.xforceplus.phoenix.bill.client.model.QueryBillModel;
import com.xforceplus.phoenix.bill.client.model.RequestSource;
import com.xforceplus.phoenix.bill.web.cache.LocalUcenterExternalCacheManager;
import com.xforceplus.phoenix.bill.web.client.BillQueryClient;
import com.xforceplus.phoenix.bill.web.client.OrgClient;
import com.xforceplus.phoenix.bill.web.client.OutSideCompanyClient;
import com.xforceplus.phoenix.bill.web.core.service.BillQueryService;
import com.xforceplus.phoenix.bill.web.core.vo.BusinessExtensionAttribute;
import com.xforceplus.phoenix.bill.web.core.vo.FieldBusinessEntity;
import com.xforceplus.phoenix.bill.web.core.vo.FieldEnumEntity;
import com.xforceplus.phoenix.bill.web.utils.CommonTools;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.ucenter.external.client.model.GetOrgListRequest;
import com.xforceplus.ucenter.external.client.model.GetUserInfoResponse;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.service.BaseService;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BillQueryServiceImpl
extends BaseService
implements BillQueryService {
    @Autowired
    BillQueryClient billQueryClient;
    @Autowired
    LocalUcenterExternalCacheManager ucenterExternalCacheManager;
    @Autowired
    OrgClient orgClient;
    @Autowired
    OutSideCompanyClient outSideCompanyClient;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Value(value="${authorization.group.ids}")
    private String authorizationGroupIds;

    @Override
    public BillResponse getBillList(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.getBillList(billSearchModel);
    }

    @Override
    public BillDetailResponse getBillListByDetail(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.getBillListByDetail(billSearchModel);
    }

    @Override
    public BillItemResponse getBillDetailList(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.getBillDetailList(billSearchModel);
    }

    @Override
    public BillSummaryResponse summaryBill(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.summaryBill(billSearchModel);
    }

    @Override
    public BillSummaryResponse summaryByDetail(BillSearchModel billSearchModel) {
        this.buildModel(billSearchModel);
        return this.billQueryClient.summaryByDetail(billSearchModel);
    }

    @Override
    public List<BillMainExt> querySalesbillByBillNo(String salesbillNo) {
        QueryBillModel queryBillModel = new QueryBillModel();
        queryBillModel.setSalesbillNo(salesbillNo);
        return this.billQueryClient.querySalesbillByBillNo(queryBillModel);
    }

    @Override
    public QueryBillItemResponse querySalesbillItemByBillNo(QueryBillItemModel model) {
        return this.billQueryClient.querySalesbillItemByBillNo(model);
    }

    private void buildModel(BillSearchModel billSearchModel) {
        UserInfo userInfo_header = CommonTools.conversion(((UserContext)this.contextHolder.get()).getUserSessionInfo());
        this.userInfoHolder.put((Object)userInfo_header);
        billSearchModel.setRequestSource(RequestSource.APP.value());
        GetOrgListRequest request = new GetOrgListRequest();
        request.setGroupID(Long.valueOf(((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId()));
        request.setUserID(Long.valueOf(((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserId()));
        request.setAppid("phoenix-bill-app");
        request.setRid(String.valueOf(UUID.randomUUID()));
        request.setPage(Integer.valueOf(0));
        request.setRow(Integer.valueOf(2000));
        List<OrgModel> orgModelList = this.ucenterExternalCacheManager.getOrgList(((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserId());
        this.logger.debug("orgModelList:{}", orgModelList);
        billSearchModel.setCompanyIdList(orgModelList.stream().filter(e -> !Objects.equals(0, e.getOrgType())).map(OrgModel::getCompanyId).collect(Collectors.toList()));
        billSearchModel.setSysOrgIdList(orgModelList.stream().map(orgModel -> String.valueOf(orgModel.getOrgStructId())).collect(Collectors.toList()));
        UserInfo userInfo = new UserInfo();
        userInfo.setGroupId(((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId());
        userInfo.setUserId(((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserId());
        billSearchModel.setUserInfo(userInfo);
        List<SearchFilter> extensionSearchFilter = this.extensionAttribute(((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserId(), billSearchModel.getBillType());
        this.logger.info("extensionSearchFilter {}", (Object)JsonUtils.writeObjectToFastJson(extensionSearchFilter));
        if (!CollectionUtils.isEmpty(extensionSearchFilter)) {
            billSearchModel.setExtensionSearchFilter(extensionSearchFilter);
        }
        List<String> groupIdList = null;
        if (!StringUtils.isEmpty((CharSequence)this.authorizationGroupIds)) {
            groupIdList = Arrays.asList(this.authorizationGroupIds.split(","));
        }
        this.logger.info("authorizationGroupIds {}, groupIdList {}, user groupId {}", new Object[]{this.authorizationGroupIds, JsonUtils.writeObjectToFastJson(groupIdList), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId()});
        if (!CollectionUtils.isEmpty(groupIdList) && groupIdList.contains(String.valueOf(billSearchModel.getUserInfo().getGroupId()))) {
            List<String> externalCompanyTaxNumList = this.getExternalCompanyTaxNumList(((UserContext)this.contextHolder.get()).getUserSessionInfo().getGroupId(), ((UserContext)this.contextHolder.get()).getUserSessionInfo().getSysUserId());
            this.logger.info("externalCompanyTaxNumList {}", (Object)JsonUtils.writeObjectToFastJson(externalCompanyTaxNumList));
            if (!CollectionUtils.isEmpty(externalCompanyTaxNumList)) {
                billSearchModel.setExternalCompanyTaxNumList(externalCompanyTaxNumList);
            }
        }
        List groups = billSearchModel.getGroups();
        ArrayList mainGroups = Lists.newArrayList();
        ArrayList itemGroups = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            for (int i = 0; i < groups.size(); ++i) {
                List data = (List)groups.get(i);
                if (data.size() <= 0) continue;
                SearchFilter searchFilter = (SearchFilter)data.get(0);
                if (searchFilter.getFieldGroupIndex() == 0) {
                    mainGroups.add(data);
                    continue;
                }
                String fieldName = searchFilter.getFieldName();
                if (fieldName.contains(",")) {
                    searchFilter.setFieldName(fieldName.substring(0, fieldName.indexOf(",")));
                    ArrayList searchFilters = Lists.newArrayList((Object[])new SearchFilter[]{searchFilter});
                    itemGroups.add(searchFilters);
                    continue;
                }
                itemGroups.add(data);
            }
        }
        billSearchModel.setGroups((List)mainGroups);
        billSearchModel.setChildGroups((List)itemGroups);
    }

    private List<SearchFilter> extensionAttribute(Long groupId, Long userId, String billType) {
        ArrayList group;
        block4: {
            this.logger.info("groupId {} userId {} billType {}", new Object[]{groupId, userId, billType});
            group = Lists.newArrayList();
            try {
                GetUserInfoResponse userInfoResponse = this.ucenterExternalCacheManager.getUserExtPermission(userId, groupId);
                this.logger.info("GetUserInfoResponse userInfo {}", (Object)JsonUtils.writeObjectToFastJson((Object)userInfoResponse));
                if (userInfoResponse == null || !Response.OK.equals(userInfoResponse.getCode())) break block4;
                String businessExtensionAttribute = userInfoResponse.getResult().getBusinessExtensionAttribute();
                this.logger.info("businessExtensionAttribute {}", (Object)businessExtensionAttribute);
                List myBusinessExtensionAttributes = JsonUtils.writeJsonToListObject((String)businessExtensionAttribute, BusinessExtensionAttribute.class);
                for (BusinessExtensionAttribute bute : myBusinessExtensionAttributes) {
                    if (!Objects.nonNull(billType) || !billType.equals(bute.getObjType())) continue;
                    List<FieldBusinessEntity> metaList = bute.getMetaList();
                    for (FieldBusinessEntity entity : metaList) {
                        List valueList;
                        String fieldName = entity.getFieldName();
                        List<FieldEnumEntity> fieldEnumValueList = entity.getFieldEnumValue();
                        if (CollectionUtils.isEmpty(fieldEnumValueList) || StringUtils.isEmpty((CharSequence)fieldName) || CollectionUtils.isEmpty(valueList = fieldEnumValueList.stream().map(item -> item.getValue()).distinct().collect(Collectors.toList()))) continue;
                        SearchFilter searchFilter = new SearchFilter(fieldName, valueList, Operator.checkbox);
                        searchFilter.setClazz(String.class);
                        group.add(searchFilter);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u4e1a\u52a1\u6269\u5c55\u5c5e\u6027\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
        }
        return group;
    }

    private List<String> getExternalCompanyTaxNumList(Long groupId, Long userId) {
        List<String> externalTaxNumList = null;
        try {
            externalTaxNumList = this.ucenterExternalCacheManager.getExternalCompanyTaxNumList(groupId, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6\u5916\u90e8\u516c\u53f8GroupId\u96c6\u5408\u5931\u8d25.", (Throwable)e);
        }
        return externalTaxNumList;
    }
}

