package com.xforceplus.bssapp.client.api;

import com.xforceplus.bssapp.client.model.*;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "client", description = "the client API")
public interface ClientApi {

    @ApiOperation(value = "获取应用信息", notes = "", response = MsGetClientDetailResponse.class, tags={ "client", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetClientDetailResponse.class) })
    @RequestMapping(value = "/client/getClientDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetClientDetailResponse getClientDetail(@ApiParam(value = "request", required = true) @RequestBody MsGetClientDetailRequest request);

    @ApiOperation(value = "获取应用分页列表", notes = "获取应用分页数据", response = MsGetClientDetailResponse.class, tags={ "client", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "服务api列表", response = MsGetClientDetailResponse.class) })
    @RequestMapping(value = "/client/getClientList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetClientListResponse getClientList(@ApiParam(value = "request", required = true) @RequestBody MsGetClientListRequest request);


    @ApiOperation(value = "操作应用信息", notes = "", response = MsOperateRouteResponse.class, tags={ "client", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsOperateRouteResponse.class) })
    @RequestMapping(value = "/client/operateClient",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsOperateRouteResponse operateClient(@ApiParam(value = "request", required = true) @RequestBody MsOperateClientRequest request);



}
