package com.xforceplus.bssapp.client.api;

import com.xforceplus.bssapp.client.model.*;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "route", description = "the route API")
public interface RouteApi {

    @ApiOperation(value = "获取应用信息", notes = "", response = MsGetRouteDetailResponse.class, tags={ "route", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetRouteDetailResponse.class) })
    @RequestMapping(value = "/route/getRouteDetail",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRouteDetailResponse getRouteDetail(@ApiParam(value = "request", required = true) @RequestBody MsGetRouteDetailRequest request);


    @ApiOperation(value = "获取应用分页列表", notes = "获取应用分页数据", response = MsGetRouteListResponse.class, tags={ "route", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "服务api列表", response = MsGetRouteListResponse.class) })
    @RequestMapping(value = "/route/getRouteList",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRouteListResponse getRouteList(@ApiParam(value = "request", required = true) @RequestBody MsGetRouteListRequest request);


    @ApiOperation(value = "操作应用信息", notes = "", response = MsOperateRouteResponse.class, tags={ "route", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsOperateRouteResponse.class) })
    @RequestMapping(value = "/route/operateRoute",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsOperateRouteResponse operateRoute(@ApiParam(value = "request", required = true) @RequestBody MsOperateRouteRequest request);

}
