package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * add by liusong 2019/7/17 15:49
 **/

/**
 * 企业审核Request
 */
@ApiModel(description = "属地调用协同操作Request")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class BelongToCoorRequest {
    /**
     * msgId : 111
     * company : {"tenantId":"1","tenantCode":"11","tenantName":" t1","companyName":"c1","companyTaxNum":"123456789101213141","origin":"SG"}
     * coop : {"sellerTenantName":"xt1","sellerTenantCode":"2111","sellerCompanyName":"xc1","sellerCompanyCode":"2111","purchaserTenantCode":"1111","purchaserTenantName":"gt1","purchaserCompanyName":"gc1","purchaserCompanyCode":"112","businessType":"1","businessTypeName":"232","businessUploadPartType":"AR","operateReason":" sss","purchaserTax":" 233","sellerTax":" 234","coordinationType":"G"}
     */

    @JsonProperty("sellerTenantId")
    private String sellerTenantId;
    @JsonProperty("sellerCompanyId")
    private String sellerCompanyId;
    @JsonProperty("purchaserTenantId")
    private String purchaserTenantId;
    @JsonProperty("purchaserCompanyId")
    private String purchaserCompanyId;
    @JsonProperty("subPurchaserTenantCode")
    private String subPurchaserTenantCode;
    @JsonProperty("sellerTenantName")
    private String sellerTenantName;
    @JsonProperty("sellerTenantCode")
    private String sellerTenantCode;
    @JsonProperty("sellerCompanyName")
    private String sellerCompanyName;
    @JsonProperty("sellerCompanyCode")
    private String sellerCompanyCode;
    @JsonProperty("purchaserTenantCode")
    private String purchaserTenantCode;
    @JsonProperty("purchaserTenantName")
    private String purchaserTenantName;
    @JsonProperty("purchaserCompanyName")
    private String purchaserCompanyName;
    @JsonProperty("purchaserCompanyCode")
    private String purchaserCompanyCode;
    @JsonProperty("businessType")
    private String businessType;
    @JsonProperty("businessUploadPartType")
    private String businessUploadPartType;
    @JsonProperty("operateReason")
    private String operateReason;
    @JsonProperty("purchaserTax")
    private String purchaserTax;
    @JsonProperty("sellerTax")
    private String sellerTax;
    @JsonProperty("coordinationType")
    private String coordinationType;


    private CoorCompanyRequest coorCompanyRequest;

    /**
     * 销方租户id
     * @return sellerTenantId
     **/
    @ApiModelProperty(value = "销方租户id")
    public String getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(String sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }
    /**
     * 销方公司id
     * @return sellerCompanyId
     **/
    @ApiModelProperty(value = "销方公司id")
    public String getSellerCompanyId() {
        return sellerCompanyId;
    }

    public void setSellerCompanyId(String sellerCompanyId) {
        this.sellerCompanyId = sellerCompanyId;
    }
    /**
     * 购方租户id
     * @return purchaserTenantId
     **/
    @ApiModelProperty(value = "购方租户id")
    public String getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(String purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }
    /**
     * 购方公司id
     * @return purchaserCompanyId
     **/
    @ApiModelProperty(value = "购方公司id")
    public String getPurchaserCompanyId() {
        return purchaserCompanyId;
    }

    public void setPurchaserCompanyId(String purchaserCompanyId) {
        this.purchaserCompanyId = purchaserCompanyId;
    }

    /**
     * 来源标识 SG-苏果 WJ-万家
     * @return subPurchaserTenantCode
     **/
    @ApiModelProperty(value = "来源标识 SG-苏果 WJ-万家")
    public String getSubPurchaserTenantCode() {
        return subPurchaserTenantCode;
    }

    public void setSubPurchaserTenantCode(String subPurchaserTenantCode) {
        this.subPurchaserTenantCode = subPurchaserTenantCode;
    }
    /**
     * 销方租户名称
     * @return sellerTenantName
     **/
    @ApiModelProperty(value = "销方租户名称")
    public String getSellerTenantName() {
        return sellerTenantName;
    }

    public void setSellerTenantName(String sellerTenantName) {
        this.sellerTenantName = sellerTenantName;
    }
    /**
     * 销方租户编号
     * @return sellerTenantCode
     **/
    @ApiModelProperty(value = "销方租户编号")
    public String getSellerTenantCode() {
        return sellerTenantCode;
    }

    public void setSellerTenantCode(String sellerTenantCode) {
        this.sellerTenantCode = sellerTenantCode;
    }
    /**
     * 销方公司名称
     * @return sellerCompanyName
     **/
    @ApiModelProperty(value = "销方公司名称")
    public String getSellerCompanyName() {
        return sellerCompanyName;
    }

    public void setSellerCompanyName(String sellerCompanyName) {
        this.sellerCompanyName = sellerCompanyName;
    }
    /**
     * 销方公司编号
     * @return sellerCompanyCode
     **/
    @ApiModelProperty(value = "销方公司编号")
    public String getSellerCompanyCode() {
        return sellerCompanyCode;
    }

    public void setSellerCompanyCode(String sellerCompanyCode) {
        this.sellerCompanyCode = sellerCompanyCode;
    }
    /**
     * 购方租户编号
     * @return purchaserTenantCode
     **/
    @ApiModelProperty(value = "购方租户编号")
    public String getPurchaserTenantCode() {
        return purchaserTenantCode;
    }

    public void setPurchaserTenantCode(String purchaserTenantCode) {
        this.purchaserTenantCode = purchaserTenantCode;
    }
    /**
     * 购方租户名称
     * @return purchaserTenantName
     **/
    @ApiModelProperty(value = "购方租户名称")
    public String getPurchaserTenantName() {
        return purchaserTenantName;
    }

    public void setPurchaserTenantName(String purchaserTenantName) {
        this.purchaserTenantName = purchaserTenantName;
    }
    /**
     * 购方公司名称
     * @return purchaserCompanyName
     **/
    @ApiModelProperty(value = "购方公司名称")
    public String getPurchaserCompanyName() {
        return purchaserCompanyName;
    }

    public void setPurchaserCompanyName(String purchaserCompanyName) {
        this.purchaserCompanyName = purchaserCompanyName;
    }
    /**
     * 购方公司编号
     * @return purchaserCompanyCode
     **/
    @ApiModelProperty(value = "购方公司编号")
    public String getPurchaserCompanyCode() {
        return purchaserCompanyCode;
    }

    public void setPurchaserCompanyCode(String purchaserCompanyCode) {
        this.purchaserCompanyCode = purchaserCompanyCode;
    }
    /**
     * 业务单类型 从销项接口获取,根据业务单上传方确定元数据
     * @return businessType
     **/
    @ApiModelProperty(value = "业务单类型 从销项接口获取,根据业务单上传方确定元数据")
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    /**
     * 业务单上传方类型   AR:销方  AP:购方
     * @return businessUploadPartType
     **/
    @ApiModelProperty(value = "业务单上传方类型   AR:销方  AP:购方")
    public String getBusinessUploadPartType() {
        return businessUploadPartType;
    }

    public void setBusinessUploadPartType(String businessUploadPartType) {
        this.businessUploadPartType = businessUploadPartType;
    }
    /**
     * 注销/启用原因
     * @return operateReason
     **/
    @ApiModelProperty(value = "注销/启用原因")
    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }
    /**
     * 购方税号
     * @return purchaserTax
     **/
    @ApiModelProperty(value = "购方税号")
    public String getPurchaserTax() {
        return purchaserTax;
    }

    public void setPurchaserTax(String purchaserTax) {
        this.purchaserTax = purchaserTax;
    }
    /**
     * 销方税号
     * @return sellerTax
     **/
    @ApiModelProperty(value = "销方税号")
    public String getSellerTax() {
        return sellerTax;
    }

    public void setSellerTax(String sellerTax) {
        this.sellerTax = sellerTax;
    }
    /**
     * 协同类型 G：租户对租户，C：公司对公司
     * @return coordinationType
     **/
    @ApiModelProperty(value = "协同类型 G：租户对租户，C：公司对公司")
    public String getCoordinationType() {
        return coordinationType;
    }

    public void setCoordinationType(String coordinationType) {
        this.coordinationType = coordinationType;
    }


    public CoorCompanyRequest getCoorCompanyRequest() {
        return coorCompanyRequest;
    }

    public void setCoorCompanyRequest(CoorCompanyRequest coorCompanyRequest) {
        this.coorCompanyRequest = coorCompanyRequest;
    }
}
