package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsBssClientDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("clientAppId")
  private Integer clientAppId = null;

  @JsonProperty("clientId")
  private String clientId = null;

  @JsonProperty("secret")
  private String secret = null;

  @JsonProperty("clientName")
  private String clientName = null;

  @JsonProperty("extension")
  private String extension = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsBssClientDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键id
   * @return id
  **/
  @ApiModelProperty(value = "主键id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsBssClientDTO clientAppId(Integer clientAppId) {
    this.clientAppId = clientAppId;
    return this;
  }

   /**
   * null
   * @return clientAppId
  **/
  @ApiModelProperty(value = "null")
  public Integer getClientAppId() {
    return clientAppId;
  }

  public void setClientAppId(Integer clientAppId) {
    this.clientAppId = clientAppId;
  }

  @JsonIgnore
  public MsBssClientDTO clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

   /**
   * null
   * @return clientId
  **/
  @ApiModelProperty(value = "null")
  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  @JsonIgnore
  public MsBssClientDTO secret(String secret) {
    this.secret = secret;
    return this;
  }

   /**
   * null
   * @return secret
  **/
  @ApiModelProperty(value = "null")
  public String getSecret() {
    return secret;
  }

  public void setSecret(String secret) {
    this.secret = secret;
  }

  @JsonIgnore
  public MsBssClientDTO clientName(String clientName) {
    this.clientName = clientName;
    return this;
  }

   /**
   * null
   * @return clientName
  **/
  @ApiModelProperty(value = "null")
  public String getClientName() {
    return clientName;
  }

  public void setClientName(String clientName) {
    this.clientName = clientName;
  }

  @JsonIgnore
  public MsBssClientDTO extension(String extension) {
    this.extension = extension;
    return this;
  }

   /**
   * 额外信息
   * @return extension
  **/
  @ApiModelProperty(value = "额外信息")
  public String getExtension() {
    return extension;
  }

  public void setExtension(String extension) {
    this.extension = extension;
  }

  @JsonIgnore
  public MsBssClientDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 1 有效 0 作废
   * @return status
  **/
  @ApiModelProperty(value = "1 有效 0 作废")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsBssClientDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * null
   * @return createTime
  **/
  @ApiModelProperty(value = "null")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsBssClientDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * null
   * @return updateTime
  **/
  @ApiModelProperty(value = "null")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBssClientDTO bssClientDTO = (MsBssClientDTO) o;
    return Objects.equals(this.id, bssClientDTO.id) &&
        Objects.equals(this.clientAppId, bssClientDTO.clientAppId) &&
        Objects.equals(this.clientId, bssClientDTO.clientId) &&
        Objects.equals(this.secret, bssClientDTO.secret) &&
        Objects.equals(this.clientName, bssClientDTO.clientName) &&
        Objects.equals(this.extension, bssClientDTO.extension) &&
        Objects.equals(this.status, bssClientDTO.status) &&
        Objects.equals(this.createTime, bssClientDTO.createTime) &&
        Objects.equals(this.updateTime, bssClientDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, clientAppId, clientId, secret, clientName, extension, status, createTime, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBssClientDTO {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    clientAppId: ").append(toIndentedString(clientAppId)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
