package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "MsBssRouteDTO")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsBssRouteDTO {
  @JsonProperty("routeId")
  private Long routeId = null;

  @JsonProperty("appId")
  private Long appId = null;

  /**
   * 匹配路径
   * 表 : bss_route
   * 对应字段 : path
   */
  @ApiModelProperty("匹配路径")
  @JsonProperty("path")
  private String path;

  /**
   * 匹配url
   * 表 : bss_route
   * 对应字段 : url
   */
  @ApiModelProperty("匹配url")
  @JsonProperty("url")
  private String url;

  /**
   * 是否计费
   * 表 : bss_route
   * 对应字段 : billable
   */
  @ApiModelProperty("是否计费")
  @JsonProperty("billable")
  private Boolean billable;

  /**
   * 是否校验权限
   * 表 : bss_route
   * 对应字段 : check_auth
   */
  /**
   * 是否计费
   * 表 : bss_route
   * 对应字段 : billable
   */
  @ApiModelProperty("是否校验权限")
  @JsonProperty("checkAuth")
  private Boolean checkAuth;

  @JsonProperty("routeName")
  private String routeName = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;


  @JsonIgnore
  public MsBssRouteDTO routeId(Long routeId) {
    this.routeId = routeId;
    return this;
  }

  @JsonIgnore
  public MsBssRouteDTO appId(Long appId) {
    this.appId = appId;
    return this;
  }


  public Long getRouteId() {
    return routeId;
  }

  public void setRouteId(Long routeId) {
    this.routeId = routeId;
  }

  /**
   * null
   * @return appId
  **/
  @ApiModelProperty(value = "appId")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsBssRouteDTO routeName(String routeName) {
    this.routeName = routeName;
    return this;
  }

   /**
   * 路由名称
   * @return routeName
  **/
  @ApiModelProperty(value = "路由名称")
  public String getRouteName() {
    return routeName;
  }

  public void setRouteName(String routeName) {
    this.routeName = routeName;
  }

  @JsonIgnore
  public MsBssRouteDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsBssRouteDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsBssRouteDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBssRouteDTO bssRoteDTO = (MsBssRouteDTO) o;
    return Objects.equals(this.routeId, bssRoteDTO.routeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(routeId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBssRouteDTO {\n");

    sb.append("    routeId: ").append(toIndentedString(routeId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    routeName: ").append(toIndentedString(routeName)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
