package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 操作请求
 */
@ApiModel(description = "操作请求")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDoIU {
  @JsonProperty("operaterid")
  private String operaterid = null;

  @JsonProperty("operater")
  private String operater = null;

/**
 * 操作类型
 */
  public enum DoTypeEnum {
    I,
    U,
    S,
    D
  }
  @JsonProperty("doType")
  private DoTypeEnum doType = null;

  @JsonIgnore
  public MsDoIU operaterid(String operaterid) {
    this.operaterid = operaterid;
    return this;
  }

   /**
   * 操作人ID
   * @return operaterid
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "操作人ID")
  public String getOperaterid() {
    return operaterid;
  }

  public void setOperaterid(String operaterid) {
    this.operaterid = operaterid;
  }

  @JsonIgnore
  public MsDoIU operater(String operater) {
    this.operater = operater;
    return this;
  }

   /**
   * 操作人
   * @return operater
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "操作人")
  public String getOperater() {
    return operater;
  }

  public void setOperater(String operater) {
    this.operater = operater;
  }

  @JsonIgnore
  public MsDoIU doType(DoTypeEnum doType) {
    this.doType = doType;
    return this;
  }

   /**
   * 操作类型
   * @return doType
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "操作类型")
  public DoTypeEnum getDoType() {
    return doType;
  }

  public void setDoType(DoTypeEnum doType) {
    this.doType = doType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDoIU doIU = (MsDoIU) o;
    return Objects.equals(this.operaterid, doIU.operaterid) &&
        Objects.equals(this.operater, doIU.operater) &&
        Objects.equals(this.doType, doIU.doType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operaterid, operater, doType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDoIU {\n");

    sb.append("    operaterid: ").append(toIndentedString(operaterid)).append("\n");
    sb.append("    operater: ").append(toIndentedString(operater)).append("\n");
    sb.append("    doType: ").append(toIndentedString(doType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
