package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetClientDetailRequest {
  @JsonProperty("clientId")
  private String clientId = null;

  @JsonProperty("secret")
  private String secret = null;

  @JsonIgnore
  public MsGetClientDetailRequest clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

   /**
   * 应用ID
   * @return clientId
  **/
  @ApiModelProperty(value = "应用ID")
  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  @JsonIgnore
  public MsGetClientDetailRequest secret(String secret) {
    this.secret = secret;
    return this;
  }

   /**
   * 应用secret
   * @return secret
  **/
  @ApiModelProperty(value = "应用secret")
  public String getSecret() {
    return secret;
  }

  public void setSecret(String secret) {
    this.secret = secret;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetClientDetailRequest getClientDetailRequest = (MsGetClientDetailRequest) o;
    return Objects.equals(this.clientId, getClientDetailRequest.clientId) &&
        Objects.equals(this.secret, getClientDetailRequest.secret);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, secret);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetClientDetailRequest {\n");

    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
