package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 应用Request
 */
@ApiModel(description = "应用Request")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
@Data
public class MsGetClientListRequest {
  @ApiModelProperty("clientAppId")
  @JsonProperty("clientAppId")
  private Integer clientAppId=null;
  @ApiModelProperty("clientName")
  @JsonProperty("clientName")
  private String clientName = null;
  @ApiModelProperty("clientId")
  @JsonProperty("clientId")
  private String clientId = null;
  @ApiModelProperty("pageSie")
  @JsonProperty("pageSie")
  private Integer pageSie = null;
  @ApiModelProperty("pageNo")
  @JsonProperty("pageNo")
  private Integer pageNo = null;

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
