package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRouteDetailRequest {
  @JsonProperty("routeId")
  private Long routeId = null;

  @JsonProperty("routeName")
  private String routeName = null;

  @JsonIgnore
  public MsGetRouteDetailRequest routeId(Long routeId) {
    this.routeId = routeId;
    return this;
  }

   /**
   * 路由ID
   * @return routeId
  **/
  @ApiModelProperty(value = "路由ID")
  public Long getRouteId() {
    return routeId;
  }

  public void setRouteId(Long routeId) {
    this.routeId = routeId;
  }

  @JsonIgnore
  public MsGetRouteDetailRequest routeName(String routeName) {
    this.routeName = routeName;
    return this;
  }

   /**
   * 路由名称
   * @return routeName
  **/
  @ApiModelProperty(value = "路由名称")
  public String getRouteName() {
    return routeName;
  }

  public void setRouteName(String routeName) {
    this.routeName = routeName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRouteDetailRequest getAppDetailRequest = (MsGetRouteDetailRequest) o;
    return Objects.equals(this.routeId, getAppDetailRequest.routeId) &&
        Objects.equals(this.routeName, getAppDetailRequest.routeName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(routeId, routeName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRouteDetailRequest {\n");

    sb.append("    routeId: ").append(toIndentedString(routeId)).append("\n");
    sb.append("    routeName: ").append(toIndentedString(routeName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
