package com.xforceplus.bssapp.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * general Response object
 */
@ApiModel(description = "general Response object")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRouteListResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("result")
  private List<MsBssRouteDTO> result = new ArrayList<>();

  @JsonIgnore
  public MsGetRouteListResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetRouteListResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetRouteListResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * return total
   * @return total
  **/
  @ApiModelProperty(value = "return total")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsGetRouteListResponse result(List<MsBssRouteDTO> result) {
    this.result = result;
    return this;
  }

  public MsGetRouteListResponse addResultItem(MsBssRouteDTO resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 应用信息
   * @return result
  **/
  @ApiModelProperty(value = "应用信息")
  public List<MsBssRouteDTO> getResult() {
    return result;
  }

  public void setResult(List<MsBssRouteDTO> result) {
    this.result = result;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRouteListResponse getAppListResponse = (MsGetRouteListResponse) o;
    return Objects.equals(this.code, getAppListResponse.code) &&
        Objects.equals(this.message, getAppListResponse.message) &&
        Objects.equals(this.total, getAppListResponse.total) &&
        Objects.equals(this.result, getAppListResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRouteListResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
