package com.xforceplus.phoenix.casm.api;

import com.xforceplus.openapi.domain.entity.common.OpenApiResponse;
import com.xforceplus.phoenix.casm.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;
import java.util.Map;

@Api(value = "casmIndex", description = "the casmIndex API")
public interface CasmIndexApi {

    @ApiOperation(value = "删除客商信息", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/delCas",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response delCas(@ApiParam(value = "删除客商信息请求", required = true) @RequestBody MsDelCasRequest data);

    @ApiOperation(value = "删除客商信息", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/delCasByOpenApi",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response delCasByOpenApi(@ApiParam(value = "删除客商信息请求", required = true) @RequestBody CasmInfoDel data);

    @ApiOperation(value = "删除客商编号信息", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/delCasIdentifierNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response delCasIdentifierNo(@ApiParam(value = "删除客商编号信息请求", required = true) @RequestBody MsDelCasSubInfoRequest data);

    @ApiOperation(value = "删除客商票面信息", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/delCasInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response delCasInvoice(@ApiParam(value = "删除客商票面信息请求", required = true) @RequestBody MsDelCasSubInfoRequest data);

    @ApiOperation(value = "删除客商税号信息", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/delCasTaxNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response delCasTaxNo(@ApiParam(value = "删除客商税号信息请求", required = true) @RequestBody MsDelCasSubInfoRequest data);

    @ApiOperation(value = "导出模板", notes = "", response = MsExportTemplateResult.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = MsExportTemplateResult.class)})
    @RequestMapping(value = "/casmIndex/exportTemplate",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsExportTemplateResult exportTemplate();

    @ApiOperation(value = "根据税号获取标签", notes = "", response = MsGetCasLabelByTaxNoResponse.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "返回对象", response = MsGetCasLabelByTaxNoResponse.class)})
    @RequestMapping(value = "/casmIndex/getCasLabelByTaxNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsGetCasLabelByTaxNoResponse getCasLabelByTaxNo(@ApiParam(value = "根据税号获取标签请求", required = true) @RequestBody MsGetCasLabelByTaxNoRequest data);

//    @ApiOperation(value = "导入客商信息", notes = "", response = MsBatchResult.class, tags = {"casm",})
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "通用的回复格式", response = MsBatchResult.class)})
//    @RequestMapping(value = "/casmIndex/importCas",
//            produces = {"application/json"},
//            method = RequestMethod.POST)
//    MsBatchResult importCas(@ApiParam(value = "oss文件地址", required = true) @RequestBody MsImportCasRequest data);

    @ApiOperation(value = "银行账号是否已存在", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/isExistBankAccount",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response isExistBankAccount(@ApiParam(value = "银行账号是否已存在请求", required = true) @RequestBody MsIsExistBankAccountRequest data);

    @ApiOperation(value = "编号是否已存在", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/isExistIdentifierNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response isExistIdentifierNo(@ApiParam(value = "编号是否已存在请求", required = true) @RequestBody MsIsExistSubNoRequest data);

    @ApiOperation(value = "税号是否已存在", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/isExistTaxNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response isExistTaxNo(@ApiParam(value = "税号是否已存在请求", required = true) @RequestBody MsIsExistSubNoRequest data);

    @ApiOperation(value = "查询客商主信息", notes = "", response = MsListCasResult.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = MsListCasResult.class)})
    @RequestMapping(value = "/casmIndex/listCas",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsListCasResult listCas(@ApiParam(value = "查询客商主信息请求", required = true) @RequestBody MsListCasRequest data);

    @ApiOperation(value = "用集团id和税号，查询客商信息", notes = "", response = MsListCasByTaxNosResult.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = MsListCasByTaxNosResult.class)})
    @RequestMapping(value = "/casmIndex/listCasByTaxNos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsListCasByTaxNosResult listCasByTaxNos(@ApiParam(value = "查询客商信息请求", required = true) @RequestBody MsListCasByTaxNosRequest data);

    @ApiOperation(value = "用集团id和客商编码查询客商信息", notes = "", response = MsListCasByTaxNosResult.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = MsListCasByTaxNosResult.class)})
    @RequestMapping(value = "/casmIndex/listCasByIdentifierNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsListCasByTaxNosResult listCasByIdentifierNo(@ApiParam(value = "查询客商信息请求", required = true) @RequestBody MsListCasByTaxNosRequest data);

    @ApiOperation(value = "查询客商明细信息", notes = "", response = MsListCasDetailsResult.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = MsListCasDetailsResult.class)})
    @RequestMapping(value = "/casmIndex/listCasDetails",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsListCasDetailsResult listCasDetails(@ApiParam(value = "查询客商明细信息请求", required = true) @RequestBody MsListCasDetailsRequest data);

    @ApiOperation(value = "更新或新增客商", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/saveCas",
            produces = {"application/json"},
            method = RequestMethod.POST)
    com.xforceplus.xplatframework.model.Response saveCas(@ApiParam(value = "更新或新增客商", required = true) @RequestBody MsSaveCasRequest data);

    @ApiOperation(value = "openapi更新客商", notes = "", response = com.xforceplus.xplatframework.model.Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = com.xforceplus.xplatframework.model.Response.class)})
    @RequestMapping(value = "/casmIndex/updateCasByOpenApi",
            produces = {"application/json"},
            method = RequestMethod.POST)
    public Response updateCasByOpenApi(@ApiParam(value = "更新客商", required = true) @RequestBody CasmInfo data);

    @ApiOperation(value = "导出客商信息", notes = "", response = Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/exportCasmInfo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response exportCasmInfo(@ApiParam(value = "导出客商信息", required = true) @RequestBody MsListCasRequest data);

    @ApiOperation(value = "根据公司编号、税号、客商id查询信息", notes = "", response = Response.class, tags = {"openApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/queryCasInfo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    CasInfosResult queryCasInfo(@ApiParam(value = "根据公司编号、税号、客商id查询信息", required = true) @RequestBody MsListCasBatchRequest data);

    @ApiOperation(value = "新增客商抬头信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/createCasHeader",
            produces = {"application/json"},
            method = RequestMethod.POST)
    OpenApiResponse createCasHeader(@ApiParam(value = "抬头信息新增请求", required = true) @RequestBody CreateHeaderRequest request);

//    @ApiOperation(value = "修改客商抬头信息", notes = "", response = Response.class, authorizations = {
//            @Authorization(value = "x-access-token")
//    }, tags={ "casm", })
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
//    @RequestMapping(value = "/casmIndex/updateCasHeader",
//            produces = { "application/json" },
//            method = RequestMethod.POST)
//    OpenApiResponse updateCasHeader(@ApiParam(value = "抬头信息修改请求" ,required=true ) @RequestBody UpdateHeaderRequest request);

    @ApiOperation(value = "作废客商抬头信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/cancelCasHeader",
            produces = {"application/json"},
            method = RequestMethod.POST)
    OpenApiResponse cancelCasHeader(@ApiParam(value = "抬头信息作废请求", required = true) @RequestBody CancelHeaderRequest request);

    @ApiOperation(value = "查询客商抬头信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/searchCasHeader",
            produces = {"application/json"},
            method = RequestMethod.POST)
    OpenApiResponse searchCasHeader(@ApiParam(value = "抬头信息查询请求", required = true) @RequestBody SearchHeaderRequest request);

    @ApiOperation(value = "查询客商票面信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/searchInvoiceInfo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    OpenApiResponse searchInvoiceInfo(@ApiParam(value = "票面信息查询请求", required = true) @RequestBody SearchInvoiceInfoRequest request);

    @ApiOperation(value = "税号模糊查询客商主信息", notes = "", response = MsListCasResult.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = MsListCasResult.class)})
    @RequestMapping(value = "/casmIndex/queryCompany",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<CompanyInfo>> queryCompanyByTaxNoLike(@ApiParam(value = "税号模糊查询客商主信息", required = true) @RequestBody CasTaxNoRequest request);

    @ApiOperation(value = "通过公司名称或税号模糊查询客商主信息（给前端页面）", notes = "", response = MsListCasResult.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = MsListCasResult.class)})
    @RequestMapping(value = "/casmIndex/listCasByCompanyNameOrTaxNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsListCasResult listCasByCompanyNameOrTax(@ApiParam(value = "查询客商主信息请求", required = true) @RequestBody MsListCasRequest data);




    @ApiOperation(value = "查询组织关联的客商编号列表", notes = "", response = Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/queryOrgIdentifierList",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<CasIdentifierCheckNo>> queryOrgIdentifierList(@ApiParam(value = "查询组织关联的客商编号列表", required = true) @RequestBody QueryOrgIdentifierRequest request);

    @ApiOperation(value = "新增客商变更同步配置", notes = "", response = Response.class, tags = {"casm",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class)})
    @RequestMapping(value = "/casmIndex/addSyncConfig",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<Object> addSyncConfig(@ApiParam(value = "新增客商变更同步配置", required = true) @RequestBody AddSyncConfigRequest request);

}
