package com.xforceplus.phoenix.casm.api;

import com.xforceplus.openapi.domain.entity.common.OpenApiResponse;
import com.xforceplus.phoenix.casm.model.AssignPermissionRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


@Api(value = "openapi", description = "外部调用")
public interface PartnerOpenApi {


    @ApiOperation(value = "查询客商抬头信息", response = Response.class)
    @RequestMapping(value = "/partner/{tenantCode}/default/v1/partner",
            produces = {"application/json"},
            method = RequestMethod.GET)
    OpenApiResponse searchCasHeader(@RequestParam("partnerType") Integer partnerType,
                                    @RequestParam(value = "companyTaxNo",required = false) String companyTaxNo,
                                    @RequestParam("partnerNo") String partnerNo);

    @ApiOperation(value = "客商权限分配信息", response = Response.class)
    @RequestMapping(value = "/partner/{tenantCode}/default/v1/partner/action/assign-permission",
            produces = {"application/json"},
            method = RequestMethod.POST)
    OpenApiResponse assignPermission(@ApiParam(value = "租户代码", required = true) @PathVariable String tenantCode,
                                     @ApiParam(value = "分配信息" , required=true ) @RequestBody AssignPermissionRequest request);

}