package com.xforceplus.phoenix.casm.api;

import com.xforceplus.openapi.domain.entity.common.OpenApiResponse;
import com.xforceplus.phoenix.casm.model.otc.TradeHeaderAPIData;
import com.xforceplus.phoenix.casm.model.otc.TradeHeaderSimpleRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@Api(value = "openapi", description = "外部调用")
public interface TradeHeaderOpenApi {

    @ApiOperation(value = "批量查询交易对手信息", response = Response.class, tags={ "otc"}, authorizations = {
            @Authorization(value = "x-access-token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/{tenantId}/tradeheader/query",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse<List<TradeHeaderAPIData>> getTradeHeaders(@ApiParam(value = "批量查询交易对手信息" ,required=true ) @RequestBody TradeHeaderSimpleRequest request,@ApiParam(value = "租户ID", required = true) @PathVariable Long tenantId);


//    @ApiOperation(value = "导入交易信息", response = Response.class, tags={ "otc"})
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
//    @RequestMapping(value = "/tradeheader/import",
//            produces = { "application/json" },
//            method = RequestMethod.POST)
//    OpenApiResponse importData(@ApiParam(value = "唯一交易场景信息" ,required=true ) @RequestBody TradeHeaderRequest request);

//
//    @ApiOperation(value = "导出模板", notes = "", response = MsExportTemplateResult.class, tags = {"casm",})
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "通用的回复格式", response = MsExportTemplateResult.class)})
//    @RequestMapping(value = "/tradeheader/exportTemplate",
//            produces = {"application/json"},
//            method = RequestMethod.POST)
//    MsExportTemplateResult exportTemplate();
//
//    @ApiOperation(value = "修改交易信息", response = Response.class, tags={ "otc"})
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
//    @RequestMapping(value = "/tradeheader/",
//            produces = { "application/json" },
//            method = RequestMethod.GET)
//    OpenApiResponse modifyTradeHeader(@ApiParam(value = "唯一交易场景信息" ,required=true ) @RequestBody TradeHeaderRequest request);

}