package com.xforceplus.phoenix.casm.api;

import com.xforceplus.phoenix.casm.model.*;
import com.xforceplus.phoenix.casm.model.relation.UserCasmRelationData;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@Api(value = "casmRelationIndex", description = "the casmRelationIndex API")
public interface UserCasmRelationApi {
    @ApiOperation(value = "统计用户客商关系数量", notes = "", response = Response.class, tags={ "casm", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/casmIndex/getUserCasmRelationCount",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getUserCasmRelationCount(@ApiParam(value = "统计用户客商关系数量") @RequestBody UserCasmRelationData.UserCasmRelationRequest request);

    @ApiOperation(value = "查询用户和客户关系List", notes = "", response = Response.class, tags={ "casm", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/casmIndex/getUserCasmRelationList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<PagedData<UserCasmRelationData.RelationResult>> queryPremittedUserCasmRelationPageList(@RequestBody UserCasmRelationData.UserCasmRelationRequest request);

    @ApiOperation(value = "保存用户和客户关系List", notes = "", response = Response.class, tags={ "casm", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/casmIndex/saveUserCasmRelationList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<UserCasmRelationData.SaveUserCustomerRelationResult> importUserRelationList(@RequestBody List<UserCasmRelationData.RelationResult> userCasmRelationList);

    @ApiOperation(value = "查询客商List", notes = "", response = Response.class, tags={ "casm", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/casmIndex/queryCasmList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<List<CasHeaderFullInfo>> queryCasmList(@RequestBody UserCasmRelationData.CasmRequest casmRequest);

    @ApiOperation(value = "查询当前用户 有权限的 客户编号集合", notes = "", response = Response.class, tags={ "casm", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/user-relation/authorized/list",
        produces = { "application/json" },
        method = RequestMethod.POST)
    Response<UserCasmRelationData.AuthorizedCustomerNoInfo> queryAuthorizedCustomerNoLists(@ApiParam(value = "查询用户客商权限集合", required = true) @RequestBody UserCasmRelationData.UserCasmRelationRequest request);

}
