package com.xforceplus.phoenix.casm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 客商编号
 */
@ApiModel(description = "客商编号")
@JsonInclude(NON_NULL)
public class CasIdentifierCheckNo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("identifierNo")
  private String identifierNo = null;

  @JsonProperty("bankName")
  private String bankName = null;
  @JsonProperty("bankAccount")
  private String bankAccount = null;
  @JsonProperty("address")
  private String address = null;
  @JsonProperty("tel")
  private String tel = null;
  @JsonProperty("email")
  private String email = null;
  @JsonProperty("mobileNumber")
  private String mobileNumber = null;

  public String getMobileNumber() {
    return mobileNumber;
  }

  public void setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
  }

  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  public String getBankAccount() {
    return bankAccount;
  }

  public void setBankAccount(String bankAccount) {
    this.bankAccount = bankAccount;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public String getTel() {
    return tel;
  }

  public void setTel(String tel) {
    this.tel = tel;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public CasIdentifierCheckNo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 接口表主键
   * @return id
  **/
  @ApiModelProperty(value = "接口表主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public CasIdentifierCheckNo identifierNo(String identifierNo) {
    this.identifierNo = identifierNo;
    return this;
  }

   /**
   * 客商编号
   * @return identifierNo
  **/
  @ApiModelProperty(value = "客商编号")
  public String getIdentifierNo() {
    return identifierNo;
  }

  public void setIdentifierNo(String identifierNo) {
    this.identifierNo = identifierNo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CasIdentifierCheckNo casIdentifierNo = (CasIdentifierCheckNo) o;
    return Objects.equals(this.id, casIdentifierNo.id) &&
        Objects.equals(this.identifierNo, casIdentifierNo.identifierNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, identifierNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CasIdentifierNo {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    identifierNo: ").append(toIndentedString(identifierNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
